/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.comm.CMConnectionRecord;
import com.ibm.cics.cm.cpsm.comm.ICMSMConnection;
import com.ibm.cics.cm.model.CMObject;
import com.ibm.cics.cm.model.CMSystemOptions;
import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.CPSMConfiguration;
import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.model.ChangePackage;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ConfigurationConnection;
import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.FilteredCollection;
import com.ibm.cics.cm.model.History;
import com.ibm.cics.cm.model.HistoryEntry;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.IMutableCMObject;
import com.ibm.cics.cm.model.MigrationScheme;
import com.ibm.cics.cm.model.PackageScheme;
import com.ibm.cics.cm.model.TransformationRuleSet;
import com.ibm.cics.cm.model.builder.CMSystemOptionsBuilder;
import com.ibm.cics.cm.model.builder.ChangePackageBuilder;
import com.ibm.cics.cm.model.builder.ConfigurationBuilder;
import com.ibm.cics.cm.model.builder.MigrationSchemeBuilder;
import com.ibm.cics.cm.model.builder.PackageSchemeBuilder;
import com.ibm.cics.cm.model.builder.TransformationRuleSetBuilder;
import com.ibm.cics.cm.model.definitions.CICSRegionGroupMember;
import com.ibm.cics.cm.model.definitions.ResourceDefinitionFactory;
import com.ibm.cics.cm.model.runtime.CMConnection;
import com.ibm.cics.cm.model.runtime.CMListFactory;
import com.ibm.cics.cm.model.runtime.CMServerDeleteException;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.CMServerListException;
import com.ibm.cics.cm.model.runtime.ChangePackageObjectCriteria;
import com.ibm.cics.cm.model.runtime.ContainerData;
import com.ibm.cics.cm.model.runtime.DeployMessageResponse;
import com.ibm.cics.cm.model.runtime.HistoryMessageResponse;
import com.ibm.cics.cm.model.runtime.ICMNotificationListener;
import com.ibm.cics.cm.model.runtime.InquireMessageResponse;
import com.ibm.cics.cm.model.runtime.JournalCriteria;
import com.ibm.cics.cm.model.runtime.ListMessageResponse;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import com.ibm.cics.cm.model.runtime.ObjectCriteriaList;
import com.ibm.cics.cm.model.runtime.ObjectData;
import com.ibm.cics.cm.model.runtime.ProcessParms;
import com.ibm.cics.cm.model.runtime.RestrictionCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteriaList;
import com.ibm.cics.cm.model.runtime.SelectionCriteria;
import com.ibm.cics.cm.model.runtime.TargetCriteria;
import com.ibm.cics.cm.model.runtime.TargetLocationCriteria;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigurationManager
implements Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private CMSystemOptions cmSysOpt = null;
    private static ConfigurationManager configurationManager;
    private CMConnection connection;
    private ICMSMConnection icmsmConnection;
    Logger logger = Logger.getLogger("com.ibm.cics.cm.model");
    private CMObjectFactory configurationObjectFactory;
    private CMObjectFactory objectFactory;
    private HashMap<String, Configuration> configurations;
    private HashMap<String, MigrationScheme> schemes;
    private Map<String, String> finalAttributes = null;
    private List<Configuration> cachedConfigurations;
    private Map<String, String> configurationNameToPlex = new HashMap<String, String>();
    private Map<String, CPSMConfiguration> plexToConfiguration = new HashMap<String, CPSMConfiguration>();
    private Map<String, Configuration> configurationNameToConfiguration = new HashMap<String, Configuration>();
    private Map<String, CSDConfiguration> datasetNameToConfiguration = new HashMap<String, CSDConfiguration>();
    private Map<String, String> configurationNameToDataset = new HashMap<String, String>();
    private ICMNotificationListener uiListener;

    public static ConfigurationManager getCurrent() {
        if (configurationManager == null) {
            configurationManager = new ConfigurationManager();
        }
        return configurationManager;
    }

    public void setICMSMConnection(ICMSMConnection icmsmConnection) {
        Debug.enter((Logger)this.logger, (String)this.getClass().getName(), (String)"setICMSMConnection", (Object)icmsmConnection);
        this.icmsmConnection = icmsmConnection;
        Debug.exit((Logger)this.logger, (String)this.getClass().getName(), (String)"setICMSMConnection");
    }

    public void setConnection(CMConnection cmConnection) {
        Debug.enter((Logger)this.logger, (String)this.getClass().getName(), (String)"setConnection", (Object)cmConnection);
        this.connection = cmConnection;
        if (this.connection != null) {
            this.populateConfigurations();
        }
        Debug.exit((Logger)this.logger, (String)this.getClass().getName(), (String)"setConnection");
    }

    private CMObjectFactory getConfigurationObjectFactory() {
        if (this.configurationObjectFactory == null) {
            this.configurationObjectFactory = new CMObjectFactory(){

                @Override
                public ICMObject createObject(Map<String, String> attributes) {
                    return null;
                }
            };
        }
        return this.configurationObjectFactory;
    }

    public CMSystemOptions getSystemOptions(boolean forceRefresh) {
        if (this.cmSysOpt == null || forceRefresh) {
            this.cmSysOpt = this.inquireSystemOptions();
        }
        return this.cmSysOpt;
    }

    public IFilteredCollection<TransformationRuleSet> getTransformationRuleSets() {
        IFilteredCollection transformationRuleSets = this.getFilteredCollection(TransformationRuleSetBuilder.getObjectFactory());
        transformationRuleSets.setObjectType("TFRULE");
        return transformationRuleSets;
    }

    public IFilteredCollection<Configuration> getConfigurations() {
        IFilteredCollection configurations = this.getFilteredConfigurationCollection(ConfigurationBuilder.getObjectFactory());
        configurations.setObjectType("CCONFIG");
        return configurations;
    }

    public IFilteredCollection<ChangePackage> getChangePackages() {
        IFilteredCollection packages = this.getFilteredCollection(ChangePackageBuilder.getObjectFactory(), new ChangePackageObjectCriteria());
        return packages;
    }

    public List<ChangePackage> getRecentlyChangedPackages(int howMany, Calendar sinceTime) {
        Calendar since = sinceTime;
        if (sinceTime == null) {
            since = Calendar.getInstance();
            since.add(2, -3);
        }
        Date fromDate = since.getTime();
        String dateString = CMUtilities.toStringyyyyMMddHHmmssSSDate(fromDate);
        IFilteredCollection<ChangePackage> changePackages = this.getChangePackages();
        changePackages.addRestrictionField("LC_DATIME", FilterExpression.Operator.GT, dateString);
        List<ChangePackage> results = changePackages.getResults();
        return results;
    }

    public IFilteredCollection<MigrationScheme> getMigrationSchemes() {
        IFilteredCollection schemes = this.getFilteredMigrationSchemeCollection(new CMObjectFactory(){

            @Override
            public ICMObject createObject(Map<String, String> attributes) {
                return new MigrationScheme(attributes);
            }
        });
        return schemes;
    }

    public IFilteredCollection getJournalEntries() {
        IFilteredCollection journalEntries = this.getFilteredCollection(new CMObjectFactory(){

            @Override
            public ICMObject createObject(Map<String, String> attributes) {
                return new CMObject(attributes);
            }
        }, new JournalCriteria(), new LocationCriteria("JOURNAL"));
        return journalEntries;
    }

    public CMConnection getConnection() {
        return this.connection;
    }

    public ICMSMConnection getICMSMConnection() {
        return this.icmsmConnection;
    }

    public boolean delete(LocationCriteria locationCriteria, ObjectCriteria objectCriteria) throws CMServerDeleteException {
        if (this.connection != null) {
            CMConnection cMConnection = this.connection;
            synchronized (cMConnection) {
                try {
                    return this.connection.delete(locationCriteria, objectCriteria);
                }
                catch (CMServerException e) {
                    throw new CMServerDeleteException(e.getMessageResponse());
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse add(LocationCriteria locationCriteria, ObjectCriteriaList objectCriteria, ContainerData containerData, ProcessParms processParms) throws CMServerException {
        if (this.connection != null) {
            CMConnection cMConnection = this.connection;
            synchronized (cMConnection) {
                return this.connection.add(locationCriteria, objectCriteria, containerData, processParms);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, ContainerData containerData) throws CMServerException {
        if (this.connection != null) {
            CMConnection cMConnection = this.connection;
            synchronized (cMConnection) {
                this.connection.add(locationCriteria, objectCriteria, containerData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(LocationCriteria locationCriteria, ObjectCriteriaList objectCriteriaList, ProcessParms processParms, TargetLocationCriteria targetLocationCriteria) throws CMServerException {
        if (this.connection != null) {
            CMConnection cMConnection = this.connection;
            synchronized (cMConnection) {
                this.connection.copy(locationCriteria, objectCriteriaList, processParms, targetLocationCriteria);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse remove(LocationCriteria locationCriteria, ObjectCriteriaList objectCriteria, ContainerData containerData) throws CMServerException {
        if (this.connection != null) {
            CMConnection cMConnection = this.connection;
            synchronized (cMConnection) {
                return this.connection.remove(locationCriteria, objectCriteria, containerData);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse remove(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, ContainerData containerData) throws CMServerException {
        if (this.connection != null) {
            CMConnection cMConnection = this.connection;
            synchronized (cMConnection) {
                return this.connection.remove(locationCriteria, objectCriteria, containerData);
            }
        }
        return null;
    }

    public void log(Level severity, String message, Exception ex) {
        this.logger.log(severity, message, ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse update(IMutableCMObject mutableCMObject) throws CMServerException {
        if (this.connection != null) {
            CMConnection cMConnection = this.connection;
            synchronized (cMConnection) {
                return this.connection.alter(mutableCMObject.getObjectType(), mutableCMObject.getName(), mutableCMObject.getIntegrityToken(), mutableCMObject.getAttributes());
            }
        }
        return null;
    }

    public PackageScheme inquirePackageScheme(String cPackage, String scheme) {
        ObjectCriteria anObjectCriteria = new ObjectCriteria();
        anObjectCriteria.setObjectType("PSCHEME");
        anObjectCriteria.attributes.remove("OBJNAME");
        anObjectCriteria.attributes.put("CPID", cPackage);
        anObjectCriteria.attributes.put("SCHEME", scheme);
        return (PackageScheme)this.inquire(LocationCriteria.newRepositoryLocationCriteria(), anObjectCriteria, PackageSchemeBuilder.getObjectFactory());
    }

    public MigrationScheme getMigrationScheme(String aMigrationScheme) {
        ObjectCriteria anObjectCriteria = new ObjectCriteria();
        anObjectCriteria.setObjectType("SCHEME");
        anObjectCriteria.attributes.put("OBJNAME", aMigrationScheme);
        anObjectCriteria.attributes.put("SCHEME", aMigrationScheme);
        MigrationScheme scheme = (MigrationScheme)this.inquire(LocationCriteria.newRepositoryLocationCriteria(), anObjectCriteria, MigrationSchemeBuilder.getObjectFactory());
        if (scheme != null) {
            if (this.schemes == null) {
                this.schemes = new HashMap();
                this.schemes.put(scheme.getName(), scheme);
            } else if (this.schemes.containsKey(scheme.getName())) {
                MigrationScheme oldScheme = this.schemes.get(scheme.getName());
                oldScheme.setAttributes(scheme.getAttributes());
            } else {
                this.schemes.put(scheme.getName(), scheme);
                MigrationScheme migrationScheme = scheme;
                migrationScheme.getClass();
                MigrationScheme.MigrationSchemeListener schemeListener = new MigrationScheme.MigrationSchemeListener(migrationScheme, scheme){

                    @Override
                    public void notify(boolean changed, MigrationScheme source) {
                        if (source.isDeleted()) {
                            ConfigurationManager.this.schemes.remove(source.getName());
                        }
                    }
                };
                scheme.addListener(schemeListener);
            }
            return scheme;
        }
        return null;
    }

    public List<String> getMigrationSchemeNameList() {
        this.getMigrationSchemes().getResults();
        if (this.schemes != null) {
            ArrayList<String> schemesList = new ArrayList<String>();
            schemesList.addAll(this.schemes.keySet());
            return schemesList;
        }
        return null;
    }

    public ChangePackage inquirePackage(String aPackageName) {
        ChangePackageObjectCriteria anObjectCriteria = new ChangePackageObjectCriteria();
        anObjectCriteria.setObjectName(aPackageName);
        return (ChangePackage)this.inquire(LocationCriteria.newRepositoryLocationCriteria(), anObjectCriteria, ChangePackageBuilder.getObjectFactory());
    }

    public TransformationRuleSet inquireTransformationRule(String aTransformationRuleName) {
        ObjectCriteria anObjectCriteria = new ObjectCriteria();
        anObjectCriteria.setObjectName(aTransformationRuleName);
        return (TransformationRuleSet)this.inquire(LocationCriteria.newRepositoryLocationCriteria(), anObjectCriteria, TransformationRuleSetBuilder.getObjectFactory());
    }

    private CMSystemOptions inquireSystemOptions() {
        ObjectCriteria anObjectCriteria = ObjectCriteria.newObjectCriteriaForSystemOptions();
        CMSystemOptions sysOpts = (CMSystemOptions)this.inquire(LocationCriteria.newRepositoryLocationCriteria(), anObjectCriteria, CMSystemOptionsBuilder.getObjectFactory());
        return sysOpts;
    }

    public Configuration getConfiguration(String aConfigurationName) {
        ObjectCriteria anObjectCriteria = ObjectCriteria.newConfigurationCriteria(aConfigurationName);
        Configuration config = (Configuration)this.inquire(LocationCriteria.newRepositoryLocationCriteria(), anObjectCriteria, ConfigurationBuilder.getObjectFactory());
        if (config != null) {
            if (this.configurations == null) {
                this.configurations = new HashMap();
                this.configurations.put(config.getName(), config);
            } else if (this.configurations.containsKey(config.getName())) {
                Configuration oldConfig = this.configurations.get(config.getName());
                oldConfig.setAttributes(config.getAttributes());
            } else {
                this.configurations.put(config.getName(), config);
                Configuration configuration = config;
                configuration.getClass();
                Configuration.ConfigurationListener configurationListener = new Configuration.ConfigurationListener(configuration, config){

                    @Override
                    public void notify(boolean changed, Configuration source) {
                        if (source.isDeleted()) {
                            ConfigurationManager.this.configurations.remove(source.getName());
                        }
                    }
                };
                config.addListener(configurationListener);
            }
            return config;
        }
        return null;
    }

    public List<String> getConfigurationsNameList() {
        this.getConfigurations().getResults();
        if (this.configurations != null) {
            ArrayList<String> configList = new ArrayList<String>();
            configList.addAll(this.configurations.keySet());
            return configList;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse ready(SelectionCriteria selectionCriteria) throws CMServerException {
        if (this.connection != null) {
            CMConnection cMConnection = this.connection;
            synchronized (cMConnection) {
                return this.connection.ready(selectionCriteria);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse unready(SelectionCriteria selectionCriteria) throws CMServerException {
        if (this.connection != null) {
            CMConnection cMConnection = this.connection;
            synchronized (cMConnection) {
                return this.connection.unready(selectionCriteria);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse migrate(SelectionCriteria selectionCriteria) throws CMServerException {
        if (this.connection != null) {
            CMConnection cMConnection = this.connection;
            synchronized (cMConnection) {
                return this.connection.migrate(selectionCriteria);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse backout(SelectionCriteria selectionCriteria) throws CMServerException {
        if (this.connection != null) {
            CMConnection cMConnection = this.connection;
            synchronized (cMConnection) {
                return this.connection.backout(selectionCriteria);
            }
        }
        return null;
    }

    public HistoryEntry inquireHistory(LocationCriteria aLocationCriteria, ObjectCriteria anObjectCriteria) {
        block3: {
            if (this.connection != null) {
                HistoryMessageResponse messageResponse = new HistoryMessageResponse();
                try {
                    this.connection.inquire(aLocationCriteria, anObjectCriteria, messageResponse);
                    HistoryEntry historyEntry = null;
                    String recordType = messageResponse.getJournalObject().get("RECTYPE");
                    historyEntry = recordType != null && recordType.equals("EVENTDATA") ? new HistoryEntry(messageResponse.getJournalObject()) : new HistoryEntry(messageResponse.getJournalObject(), messageResponse.getBeforeObject(), messageResponse.getAfterObject());
                    return historyEntry;
                }
                catch (CMServerException e) {
                    if (e.isSpecifiedObjectNotFound() || e.isOKWarning()) break block3;
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    public ICMObject inquire(LocationCriteria aLocationCriteria, ObjectCriteria anObjectCriteria, CMObjectFactory aCMObjectFactory) {
        block5: {
            if (this.connection != null) {
                InquireMessageResponse messageResponse;
                block4: {
                    messageResponse = this.connection.inquire(aLocationCriteria, anObjectCriteria);
                    if (messageResponse != null) break block4;
                    return null;
                }
                try {
                    return aCMObjectFactory.createObject(messageResponse.getObject());
                }
                catch (CMServerException e) {
                    if (e.isSpecifiedObjectNotFound() || e.isOKWarning()) break block5;
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InquireMessageResponse create(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, ObjectData objectData) throws CMServerException {
        if (this.connection != null) {
            CMConnection cMConnection = this.connection;
            synchronized (cMConnection) {
                try {
                    return this.connection.create(locationCriteria, objectCriteria, objectData);
                }
                catch (Exception e) {
                    if (e instanceof CMServerException) {
                        throw (CMServerException)e;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InquireMessageResponse createChangePackage(LocationCriteria locationCriteria, ChangePackageObjectCriteria objectCriteria, ObjectData objectData) throws CMServerException {
        if (this.connection != null) {
            CMConnection cMConnection = this.connection;
            synchronized (cMConnection) {
                try {
                    return this.connection.createChangePackage(locationCriteria, objectCriteria, objectData);
                }
                catch (Exception e) {
                    if (e instanceof CMServerException) {
                        throw (CMServerException)e;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse update(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, ObjectData objectData, String integrityToken) throws CMServerException {
        MessageResponse mr;
        block5: {
            mr = null;
            try {
                if (this.connection == null) break block5;
                CMConnection cMConnection = this.connection;
                synchronized (cMConnection) {
                    mr = this.connection.alter(locationCriteria, objectCriteria, objectData, integrityToken);
                }
            }
            catch (CMServerException e) {
                if (e.isDFHEDAPWarning()) break block5;
                throw e;
            }
        }
        return mr;
    }

    public static void setCurrent(ConfigurationManager aConfigurationManager) {
        configurationManager = aConfigurationManager;
    }

    public ListMessageResponse getOrphanedResourcesList(LocationCriteria locationCriteria, ObjectCriteria objectCriteria) throws CMServerListException {
        return this.getListWithProcessParm(locationCriteria, objectCriteria, ProcessParms.getOrphanedResourcesReportSet());
    }

    public ListMessageResponse getListWithProcessParm(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, ProcessParms processParm) throws CMServerListException {
        block3: {
            if (this.connection != null) {
                try {
                    return this.connection.listWithProcessParms(locationCriteria, objectCriteria, processParm);
                }
                catch (CMServerException e) {
                    if (e.isSpecifiedObjectNotFound() || e.isMaybeIncomplete() || e.isInvalidResourceType() || e.isOKWarning()) break block3;
                    throw new CMServerListException(e.getMessageResponse());
                }
            }
        }
        return null;
    }

    public MessageResponse renameGroup(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, TargetCriteria targetCriteria) {
        block3: {
            if (this.connection != null) {
                try {
                    return this.connection.renameGroup(locationCriteria, objectCriteria, targetCriteria, ProcessParms.getAdd());
                }
                catch (CMServerException e) {
                    if (e.isSpecifiedObjectNotFound() || e.isMaybeIncomplete() || e.isInvalidResourceType() || e.isOKWarning()) break block3;
                    throw new RuntimeException(e.getReturnResponse(), e);
                }
            }
        }
        return null;
    }

    public ListMessageResponse getList(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, RestrictionCriteriaList restrictionCriteriaList) throws CMServerListException {
        block3: {
            if (this.connection != null) {
                try {
                    return this.connection.listResources(locationCriteria, objectCriteria, restrictionCriteriaList);
                }
                catch (CMServerException e) {
                    if (e.isSpecifiedObjectNotFound() || e.isOKWarning()) break block3;
                    throw new CMServerListException(e.getMessageResponse());
                }
            }
        }
        return null;
    }

    public ListMessageResponse getList(LocationCriteria locationCriteria, JournalCriteria journalCriteria, RestrictionCriteriaList restrictionCriteria) throws CMServerListException {
        block3: {
            if (this.connection != null) {
                try {
                    return this.connection.getResources(locationCriteria, journalCriteria, restrictionCriteria);
                }
                catch (CMServerException e) {
                    if (e.isSpecifiedObjectNotFound() || e.isOKWarning()) break block3;
                    throw new CMServerListException(e.getMessageResponse());
                }
            }
        }
        return null;
    }

    public ListMessageResponse getListWithChecksum(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, String checksumType) throws CMServerListException {
        return this.getListWithProcessParm(locationCriteria, objectCriteria, ProcessParms.getChecksum(checksumType));
    }

    public ListMessageResponse getListWithChecksum(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, RestrictionCriteriaList restrictionCriteriaList, String checksumType) throws CMServerListException {
        block3: {
            if (this.connection != null) {
                try {
                    return this.connection.listWithRestrictionCriteriaAndProcessParms(locationCriteria, objectCriteria, restrictionCriteriaList, ProcessParms.getChecksum(checksumType));
                }
                catch (CMServerException e) {
                    if (e.isSpecifiedObjectNotFound() || e.isMaybeIncomplete() || e.isInvalidResourceType() || e.isOKWarning()) break block3;
                    throw new CMServerListException(e.getMessageResponse());
                }
            }
        }
        return null;
    }

    public IFilteredCollection getFilteredCollection(final CMObjectFactory objectFactory, JournalCriteria aJournalCriteria, LocationCriteria aLocationCriteria) {
        FilteredCollection filteredCollection = new FilteredCollection(new CMListFactory(aLocationCriteria, aJournalCriteria){

            @Override
            public List<ICMObject> getResults() {
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.this.getList(this.locationCriteria, this.journalCriteria, this.restrictionCriteriaList);
                }
                catch (CMServerListException e) {
                    Debug.warning((Logger)ConfigurationManager.this.logger, (String)this.getClass().getName(), (String)"getFilteredCollection", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    ArrayList<ICMObject> objects = new ArrayList<ICMObject>();
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    while (iterator.hasNext()) {
                        Map<String, String> attributes = iterator.next();
                        objects.add(objectFactory.createObject(attributes));
                    }
                    return objects;
                }
                return null;
            }
        });
        return filteredCollection;
    }

    public IFilteredCollection getFilteredConfigurationCollection(final CMObjectFactory objectFactory) {
        FilteredCollection filteredCollection = new FilteredCollection(new CMListFactory(new ObjectCriteria()){

            @Override
            public List<ICMObject> getResults() throws CMServerListException {
                FilteredCollection configurationsFromServer = (FilteredCollection)ConfigurationManager.this.getFilteredCollection(objectFactory);
                configurationsFromServer.setObjectType("CCONFIG");
                configurationsFromServer.setRestrictionCriteriaList(this.getRestrictionCriteriaList());
                ArrayList<ICMObject> configs = new ArrayList<ICMObject>();
                if (ConfigurationManager.this.configurations == null) {
                    ConfigurationManager.this.configurations = new HashMap();
                    List configurationsFromServerList = configurationsFromServer.getResults();
                    for (Configuration config : configurationsFromServerList) {
                        configs.add(config);
                        ConfigurationManager.this.configurations.put(config.getName(), config);
                    }
                } else {
                    HashMap<String, Configuration> newConfigurations = new HashMap<String, Configuration>();
                    List configurationsFromServerList = configurationsFromServer.getResults();
                    for (Configuration config : configurationsFromServerList) {
                        Date newChangeTime;
                        Date oldChangeTime;
                        Configuration currentConfig = (Configuration)ConfigurationManager.this.configurations.get(config.getName());
                        if (currentConfig == null) {
                            configs.add(config);
                            newConfigurations.put(config.getName(), config);
                            continue;
                        }
                        if (currentConfig.hasListeners() && (oldChangeTime = currentConfig.getChangeTime()).compareTo(newChangeTime = config.getChangeTime()) < 0) {
                            currentConfig.setAttributes(config.getAttributes());
                        }
                        configs.add(currentConfig);
                        newConfigurations.put(currentConfig.getName(), currentConfig);
                        ConfigurationManager.this.configurations.remove(currentConfig.getName());
                    }
                    if (!ConfigurationManager.this.configurations.isEmpty()) {
                        for (Configuration oldConf : ConfigurationManager.this.configurations.values()) {
                            oldConf.setDeleted();
                        }
                    }
                    ConfigurationManager.this.configurations = newConfigurations;
                }
                return configs;
            }
        });
        return filteredCollection;
    }

    public IFilteredCollection getFilteredMigrationSchemeCollection(final CMObjectFactory objectFactory) {
        FilteredCollection filteredCollection = new FilteredCollection(new CMListFactory(new ObjectCriteria()){

            @Override
            public List<ICMObject> getResults() throws CMServerListException {
                FilteredCollection schemesFromServer = (FilteredCollection)ConfigurationManager.this.getFilteredCollection(objectFactory, ObjectCriteria.newMigrationSchemeCriteria());
                schemesFromServer.setObjectType("SCHEME");
                schemesFromServer.setRestrictionCriteriaList(this.getRestrictionCriteriaList());
                ArrayList<ICMObject> lSchemes = new ArrayList<ICMObject>();
                if (ConfigurationManager.this.schemes == null) {
                    ConfigurationManager.this.schemes = new HashMap();
                    List schemesFromServerList = schemesFromServer.getResults();
                    for (MigrationScheme scheme : schemesFromServerList) {
                        lSchemes.add(scheme);
                        ConfigurationManager.this.schemes.put(scheme.getName(), scheme);
                    }
                } else {
                    HashMap<String, MigrationScheme> newSchemes = new HashMap<String, MigrationScheme>();
                    List schemesFromServerList = schemesFromServer.getResults();
                    for (MigrationScheme scheme : schemesFromServerList) {
                        Date newChangeTime;
                        Date oldChangeTime;
                        MigrationScheme currentScheme = (MigrationScheme)ConfigurationManager.this.schemes.get(scheme.getName());
                        if (currentScheme == null) {
                            lSchemes.add(scheme);
                            newSchemes.put(scheme.getName(), scheme);
                            continue;
                        }
                        if (currentScheme.hasListeners() && (oldChangeTime = currentScheme.getChangeTime()).compareTo(newChangeTime = scheme.getChangeTime()) < 0) {
                            currentScheme.setAttributes(scheme.getAttributes());
                        }
                        lSchemes.add(currentScheme);
                        newSchemes.put(currentScheme.getName(), currentScheme);
                        ConfigurationManager.this.schemes.remove(currentScheme.getName());
                    }
                    if (!ConfigurationManager.this.schemes.isEmpty()) {
                        for (MigrationScheme oldScheme : ConfigurationManager.this.schemes.values()) {
                            oldScheme.setDeleted();
                        }
                    }
                    ConfigurationManager.this.schemes = newSchemes;
                }
                return lSchemes;
            }
        });
        return filteredCollection;
    }

    public IFilteredCollection getFilteredCollection(CMObjectFactory objectFactory) {
        return this.getFilteredCollection(objectFactory, new ObjectCriteria());
    }

    public IFilteredCollection getFilteredCollection(final CMObjectFactory objectFactory, ObjectCriteria anObjectCriteria, LocationCriteria aLocationCriteria) {
        FilteredCollection filteredCollection = new FilteredCollection(new CMListFactory(aLocationCriteria, anObjectCriteria){

            @Override
            public List<ICMObject> getResults() {
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.this.getList(this.locationCriteria, this.objectCriteria, this.restrictionCriteriaList);
                }
                catch (CMServerListException e) {
                    Debug.warning((Logger)ConfigurationManager.this.logger, (String)this.getClass().getName(), (String)"getFilteredCollection", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    ArrayList<ICMObject> objects = new ArrayList<ICMObject>();
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    while (iterator.hasNext()) {
                        Map<String, String> attributes = iterator.next();
                        objects.add(objectFactory.createObject(attributes));
                    }
                    return objects;
                }
                return null;
            }
        });
        return filteredCollection;
    }

    public IFilteredCollection getFilteredCollection(final CMObjectFactory objectFactory, ObjectCriteria anObjectCriteria) {
        FilteredCollection filteredCollection = new FilteredCollection(new CMListFactory(anObjectCriteria){

            @Override
            public List<ICMObject> getResults() {
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.this.getList(this.locationCriteria, this.objectCriteria, this.restrictionCriteriaList);
                }
                catch (CMServerListException e) {
                    Debug.warning((Logger)ConfigurationManager.this.logger, (String)this.getClass().getName(), (String)"getFilteredCollection", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    ArrayList<ICMObject> objects = new ArrayList<ICMObject>();
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    while (iterator.hasNext()) {
                        Map<String, String> attributes = iterator.next();
                        objects.add(objectFactory.createObject(attributes));
                    }
                    return objects;
                }
                return null;
            }
        });
        return filteredCollection;
    }

    public void restoreHistory(History history) throws CMServerException, SystemManagerConnectionException {
        final Configuration configuration = history.getProvider().getConfiguration();
        if (configuration == null) {
            this.logger.log(Level.WARNING, "Can't find valid Configuration to restore historical artifact", history);
            throw new CMServerException(null);
        }
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(configuration.getName());
        ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForGroup(history.getResourceGroup(), history.getType(), history.getName());
        ICMObject currentObject = this.inquire(locationCriteria, objectCriteria, new CMObjectFactory(){

            @Override
            public ICMObject createObject(Map<String, String> attributes) {
                return ResourceDefinitionFactory.getObject(configuration, attributes, false);
            }
        });
        Map<String, String> beforeAttributes = history.getAttributesBeforeChange();
        beforeAttributes.remove("TYPE");
        beforeAttributes.remove("CREATETIME");
        beforeAttributes.remove("CHANGETIME");
        String version = history.getAttributes().get("DEFVER");
        if (version != null) {
            beforeAttributes.put("DEFVER", version);
        } else {
            beforeAttributes.remove("DEFVER");
        }
        CMConnectionRecord cmRecord = new CMConnectionRecord(beforeAttributes, null, IContext.NULL_CONTEXT);
        ObjectData objectData = ObjectData.newFrom((SMConnectionRecord)cmRecord);
        if (currentObject == null) {
            this.getConnection().create(locationCriteria, objectCriteria, objectData);
        } else {
            this.getConnection().alter(locationCriteria, objectCriteria, objectData);
        }
    }

    public ListMessageResponse getRemoteConnections() throws CMServerListException {
        return this.getRemoteConnections("NETNAME");
    }

    public ListMessageResponse getRemoteConnections(String restrictionField) throws CMServerListException {
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria("CCVSVR");
        ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForList();
        objectCriteria.setObjectType("CONNDEF");
        RestrictionCriteriaList restrictionCriteriaList = new RestrictionCriteriaList();
        restrictionCriteriaList.add(new RestrictionCriteria(restrictionField, FilterExpression.Operator.EQ, "*"));
        return this.getList(locationCriteria, objectCriteria, restrictionCriteriaList);
    }

    public ListMessageResponse getSharedResourcesList(LocationCriteria locationCriteria, ObjectCriteria objectCriteria) throws CMServerListException {
        return this.getListWithProcessParm(locationCriteria, objectCriteria, ProcessParms.getSharedResourcesReportSet());
    }

    public ListMessageResponse getDuplicatesByNameAndTypeList(LocationCriteria locationCriteria, ObjectCriteria objectCriteria) throws CMServerListException {
        return this.getListWithProcessParm(locationCriteria, objectCriteria, ProcessParms.getDuplicateResourcesByNameAndTypeReportSet());
    }

    public ListMessageResponse getUniqueNames(LocationCriteria locationCriteria, ObjectCriteria objectCriteria) throws CMServerListException {
        return this.getListWithProcessParm(locationCriteria, objectCriteria, ProcessParms.getUniqueNamesReportSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateConfigurations() {
        ConfigurationManager configurationManager = this;
        synchronized (configurationManager) {
            this.cachedConfigurations = null;
            this.cachedConfigurations = this.getConfigurations().getResults();
            if (this.cachedConfigurations != null) {
                this.configurationNameToPlex.clear();
                this.plexToConfiguration.clear();
                this.datasetNameToConfiguration.clear();
                this.configurationNameToDataset.clear();
                this.configurationNameToConfiguration.clear();
                for (Configuration configuration : this.cachedConfigurations) {
                    this.configurationNameToConfiguration.put(configuration.getName(), configuration);
                    if (configuration instanceof CPSMConfiguration) {
                        CPSMConfiguration cpsmConfiguration = (CPSMConfiguration)configuration;
                        String plexName = cpsmConfiguration.getPlexName();
                        this.configurationNameToPlex.put(cpsmConfiguration.getName(), plexName);
                        this.plexToConfiguration.put(plexName, cpsmConfiguration);
                        continue;
                    }
                    if (!(configuration instanceof CSDConfiguration)) continue;
                    CSDConfiguration csdConfiguration = (CSDConfiguration)configuration;
                    String datasetName = csdConfiguration.getCSDName();
                    this.datasetNameToConfiguration.put(datasetName, csdConfiguration);
                    this.configurationNameToDataset.put(csdConfiguration.getName(), datasetName);
                }
            }
        }
    }

    public List<Configuration> getCachedConfigurations() {
        if (this.cachedConfigurations == null) {
            this.populateConfigurations();
        }
        return this.cachedConfigurations;
    }

    public Configuration getConfigurationForPlex(String plexName) {
        if (this.cachedConfigurations == null) {
            this.populateConfigurations();
        }
        return this.plexToConfiguration.get(plexName);
    }

    public Configuration getCachedConfiguration(String configurationName) {
        return this.configurationNameToConfiguration.get(configurationName);
    }

    public MessageResponse kill(String token) {
        block3: {
            if (this.connection != null) {
                try {
                    return this.connection.kill(token);
                }
                catch (CMServerException e) {
                    if (e.isSpecifiedObjectNotFound() || e.isMaybeIncomplete() || e.isInvalidResourceType() || e.isOKWarning()) break block3;
                    throw new RuntimeException(e.getReturnResponse(), e);
                }
            }
        }
        return null;
    }

    public void dispose() {
        this.cachedConfigurations = null;
        this.configurationNameToPlex.clear();
        this.datasetNameToConfiguration.clear();
        this.configurationNameToConfiguration.clear();
        this.connection = null;
    }

    public CSDConfiguration getConfigurationForConnection(ConfigurationConnection configurationConnection) {
        String mroLinkName = configurationConnection.getName();
        if (this.cachedConfigurations == null) {
            this.populateConfigurations();
        }
        for (Configuration configuration : this.cachedConfigurations) {
            CSDConfiguration cSDConfiguration;
            List<String> mrOlinks;
            if (!(configuration instanceof CSDConfiguration) || !(mrOlinks = (cSDConfiguration = (CSDConfiguration)configuration).getMROlinks()).contains(mroLinkName)) continue;
            return cSDConfiguration;
        }
        return null;
    }

    public CSDConfiguration getConfigurationForDatasetName(String datasetName) {
        if (this.cachedConfigurations == null) {
            this.populateConfigurations();
        }
        return this.datasetNameToConfiguration.get(datasetName);
    }

    public ArrayList<CICSRegionGroupMember> getSystemGroupMembers(String toGroup, Configuration configuration) {
        Map<String, String> attributes;
        Iterator<Map<String, String>> iterator;
        ArrayList<CICSRegionGroupMember> results = new ArrayList<CICSRegionGroupMember>();
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(configuration.getName());
        ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteria("CSGLCGCG");
        RestrictionCriteriaList restrictionCriteria = new RestrictionCriteriaList();
        restrictionCriteria.add(new RestrictionCriteria("TOGROUP", FilterExpression.Operator.EQ, toGroup));
        restrictionCriteria.add(new RestrictionCriteria("GROUP", FilterExpression.Operator.EQ, "*"));
        try {
            ListMessageResponse groupResponse = this.getList(locationCriteria, objectCriteria, restrictionCriteria);
            if (groupResponse != null) {
                iterator = groupResponse.getObjects();
                while (iterator.hasNext()) {
                    attributes = iterator.next();
                    if (attributes == null || !attributes.get("TYPE").equals("CSGLCGCG")) continue;
                    results.add((CICSRegionGroupMember)ResourceDefinitionFactory.getObject(configuration, attributes));
                }
            }
        }
        catch (CMServerListException e) {
            throw new RuntimeException(e.getReturnResponse(), e);
        }
        objectCriteria = ObjectCriteria.newObjectCriteria("CSGLCGCS");
        restrictionCriteria = new RestrictionCriteriaList();
        restrictionCriteria.add(new RestrictionCriteria("GROUP", FilterExpression.Operator.EQ, toGroup));
        restrictionCriteria.add(new RestrictionCriteria("CICSNAME", FilterExpression.Operator.EQ, "*"));
        try {
            ListMessageResponse systemResponse = this.getList(locationCriteria, objectCriteria, restrictionCriteria);
            if (systemResponse != null) {
                iterator = systemResponse.getObjects();
                while (iterator.hasNext()) {
                    attributes = iterator.next();
                    if (attributes == null || !attributes.get("TYPE").equals("CSGLCGCS")) continue;
                    results.add((CICSRegionGroupMember)ResourceDefinitionFactory.getObject(configuration, attributes));
                }
            }
        }
        catch (CMServerListException e) {
            throw new RuntimeException(e.getReturnResponse(), e);
        }
        return results;
    }

    public DeployMessageResponse deploy(String xmlMessage) {
        return this.connection.deploy(xmlMessage);
    }

    public void setUIListener(ICMNotificationListener cmNotificationListener) {
        if (cmNotificationListener != null) {
            this.uiListener = cmNotificationListener;
        }
    }

    public void triggerUIMessage(String message) {
        this.uiListener.event(message);
    }

    public static interface CMHistoryFactory {
        public ICMObject createBeforeObject(Map<String, String> var1);

        public ICMObject createAfterObject(Map<String, String> var1);
    }

    public static interface CMObjectFactory {
        public ICMObject createObject(Map<String, String> var1);
    }
}

