/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.runtime.MessageResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ListMessageResponse
extends MessageResponse
implements Iterable<Map<String, String>> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<Map<String, String>> objects = new ArrayList<Map<String, String>>();
    private Map<String, String> currentObject;
    private String commandType = "";
    protected String startListTag = "LISTELEMENT";
    protected String startObjectTag = "OBJECTDATA";
    protected String cmdSourceTag = "CMDASOURCE";
    protected String cmdTargetTag = "CMDATARGET";
    private boolean type;

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, name, attributes);
        if (this.status == 1) {
            if (this.cmdSourceTag.equals(name) | this.cmdTargetTag.equals(name)) {
                this.commandType = name;
            }
            if (this.startListTag.equals(name)) {
                this.currentObject = new HashMap<String, String>();
            } else if (this.startObjectTag.equals(name)) {
                this.currentObject = new HashMap<String, String>();
                if (!this.commandType.equals("")) {
                    this.currentObject.put("CMDAPOST", this.commandType);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if (this.status == 1) {
            if (this.cmdSourceTag.equals(name) | this.cmdTargetTag.equals(name)) {
                this.commandType = "";
            }
            if (this.startObjectTag.equalsIgnoreCase(name)) {
                this.objects.add(this.currentObject);
            } else if (this.startListTag.equals(name)) {
                this.currentObject = new HashMap<String, String>();
            } else if (this.currentObject != null) {
                if (this.currentObject.containsKey("TYPE") && this.currentObject.get("TYPE").equalsIgnoreCase("APPLDEF")) {
                    if (name.equalsIgnoreCase("APPLNAME")) {
                        this.currentObject.put("NAME", this.getCurrentTagValue());
                    } else if (name.equalsIgnoreCase("NAME")) {
                        this.currentObject.put("ALIAS", this.getCurrentTagValue());
                    } else {
                        this.currentObject.put(name, this.getCurrentTagValue());
                    }
                } else {
                    this.currentObject.put(name, this.getCurrentTagValue());
                }
            }
        }
    }

    public int size() {
        return this.objects.size();
    }

    public Iterator<Map<String, String>> getObjects() {
        return this.objects.iterator();
    }

    @Override
    public Iterator<Map<String, String>> iterator() {
        return this.getObjects();
    }
}

