/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.MigrationPath;
import com.ibm.cics.cm.model.TransformationVariable;
import com.ibm.cics.cm.model.runtime.Element;
import com.ibm.cics.cm.model.runtime.ObjectData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MigrationSchemeObjectData
extends ObjectData {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ArrayList<MigrationPath> migrationPaths;
    private ArrayList<TransformationVariable> transformationVariables;

    public void setMigrationPaths(ArrayList<MigrationPath> migrationPaths) {
        this.migrationPaths = migrationPaths;
    }

    public void setTransformationVariables(ArrayList<TransformationVariable> transformationVariables) {
        this.transformationVariables = transformationVariables;
    }

    public List<MigrationPath> getMigrationPaths() {
        return this.migrationPaths;
    }

    @Override
    public Element createElement(Element parentElement) {
        Element element = parentElement.createChild(this.getName());
        for (Map.Entry<String, String> nodeTag : this.getElements()) {
            if (nodeTag.getValue() == null) continue;
            element.createChild(nodeTag.getKey(), CMUtilities.encodeToEBCDICValue(nodeTag.getValue()));
        }
        Element migrationPathRGroup = element.createChild("RGroup");
        if (this.migrationPaths == null || this.migrationPaths.isEmpty()) {
            migrationPathRGroup.createChild("STCCOUNT", "00000000");
        } else {
            migrationPathRGroup.createChild("STCCOUNT", String.format("%08d", this.migrationPaths.size()));
            for (MigrationPath path : this.migrationPaths) {
                Element rGroupElement = migrationPathRGroup.createChild("RGroupElement");
                rGroupElement.createChild("S_CCONFIG", CMUtilities.encodeToEBCDICValue(path.getSource()));
                rGroupElement.createChild("T_CCONFIG", CMUtilities.encodeToEBCDICValue(path.getTarget()));
                rGroupElement.createChild("XFORMRSET", CMUtilities.encodeToEBCDICValue(path.getRule()));
                rGroupElement.createChild("SCE_DEL_OPT", CMUtilities.encodeToEBCDICValue(path.getDeleteAtSource() ? "YES" : "NO"));
            }
        }
        Element transformationVariableRGroup = element.createChild("RGroup");
        if (this.transformationVariables == null || this.transformationVariables.isEmpty()) {
            transformationVariableRGroup.createChild("STVCOUNT", "00000000");
        } else {
            transformationVariableRGroup.createChild("STVCOUNT", String.format("%08d", this.transformationVariables.size()));
            for (TransformationVariable var : this.transformationVariables) {
                Element rGroupElement = transformationVariableRGroup.createChild("RGroupElement");
                rGroupElement.createChild("S_NAME", var.getName());
                rGroupElement.createChild("S_VALUE", var.getSourceValue());
                rGroupElement.createChild("T_VALUE", var.getTargetValue());
            }
        }
        return element;
    }
}

