/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.model.CICSDateAttribute;
import com.ibm.cics.core.model.CICSDoubleAttribute;
import com.ibm.cics.core.model.CICSEnumAttribute;
import com.ibm.cics.core.model.CICSLongAttribute;
import com.ibm.cics.core.model.CICSStringAttribute;
import com.ibm.cics.model.CICSRelease;
import com.ibm.cics.model.Debug;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeHint;
import com.ibm.cics.model.ICICSAttributeValidator;
import com.ibm.cics.model.ICICSEnum;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.sm.comm.INormalizer;
import com.ibm.cics.sm.comm.NormalizationException;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CICSAttribute<T>
implements ICICSAttribute<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static Logger logger = Logger.getLogger("com.ibm.cics.model");
    public static final String DEFAULT_CATEGORY_ID = "default";
    public static final String RESOURCE_SIGNATURE_CATEGORY_ID = "resourcesignature";
    public static final String DEFINITION_SIGNATURE_CATEGORY_ID = "definitionsignature";
    private final String propertyId;
    private final String cicsName;
    private final String categoryId;
    private final Class<T> type;
    private final ICICSAttributeValidator<T> validator;
    private final T unexpectedValue;
    private final T unsupportedValue;
    private final T defaultValue;
    private final CICSRelease validFrom;
    private final CICSRelease validTo;

    protected CICSAttribute(String propertyId, String categoryId, String cicsName, Class<T> type, ICICSAttributeValidator<T> validator, T defaultValue, T unexpectedValue, T unsupportedValue, CICSRelease validFrom, CICSRelease validTo) {
        if (propertyId == null) {
            throw new IllegalArgumentException("propertyId null");
        }
        if (propertyId.trim().equals("")) {
            throw new IllegalArgumentException("propertyId blank");
        }
        if (cicsName == null) {
            throw new IllegalArgumentException("cicsName null");
        }
        if (categoryId == null) {
            throw new IllegalArgumentException("categoryId null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type null");
        }
        if (unexpectedValue == null) {
            throw new IllegalArgumentException("unexpected value null");
        }
        if (unsupportedValue == null) {
            throw new IllegalArgumentException("unsupported value null");
        }
        this.propertyId = propertyId;
        this.categoryId = categoryId;
        this.cicsName = cicsName;
        this.type = type;
        this.validator = validator != null ? validator : ICICSAttributeValidator.NULLOBJ;
        this.defaultValue = defaultValue;
        this.unexpectedValue = unexpectedValue;
        this.unsupportedValue = unsupportedValue;
        this.validFrom = validFrom;
        this.validTo = validTo;
    }

    @Deprecated
    public static <T> CICSAttribute<T> create(String propertyId, String categoryId, String cicsName, Class<T> type, boolean alwaysSupported) {
        return (CICSAttribute)CICSAttribute.create(propertyId, categoryId, cicsName, type, null, null, null, null);
    }

    @Deprecated
    public static <T> CICSAttribute<T> create(String propertyId, String categoryId, String cicsName, Class<T> type, ICICSAttributeValidator<T> validator, T defaultValue, boolean alwaysSupported) {
        return (CICSAttribute)CICSAttribute.create(propertyId, categoryId, cicsName, type, validator, defaultValue, null, null);
    }

    public static <T> ICICSAttribute<T> create(String propertyId, String categoryId, String cicsName, Class<T> type, ICICSAttributeValidator<T> validator, T defaultValue, CICSRelease validFrom, CICSRelease validTo) {
        if (String.class.equals(type)) {
            return new CICSStringAttribute(propertyId, categoryId, cicsName, validator, (String)defaultValue, validFrom, validTo);
        }
        if (Long.class.equals(type)) {
            return new CICSLongAttribute(propertyId, categoryId, cicsName, validator, (Long)defaultValue, validFrom, validTo);
        }
        if (Double.class.equals(type)) {
            return new CICSDoubleAttribute(propertyId, categoryId, cicsName, validator, (Double)defaultValue, validFrom, validTo);
        }
        if (Date.class.equals(type)) {
            return new CICSDateAttribute(propertyId, categoryId, cicsName, validator, (Date)defaultValue, validFrom, validTo);
        }
        if (ICICSEnum.class.isAssignableFrom(type) && Enum.class.isAssignableFrom(type)) {
            return new CICSEnumAttribute<Enum>(propertyId, categoryId, cicsName, type, validator, (Enum)defaultValue, validFrom, validTo);
        }
        throw new RuntimeException("CICSAttribute.create() could not create a CICS attribute for type: " + type);
    }

    public String getCicsName() {
        return this.cicsName;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public Class<T> getType() {
        return this.type;
    }

    public CICSRelease getValidFrom() {
        return this.validFrom;
    }

    public CICSRelease getValidTo() {
        return this.validTo;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[propertyId=" + this.propertyId + ", categoryId=" + this.categoryId + ", cicsName=" + this.cicsName + "]";
    }

    public final void validate(Object value) throws IllegalCICSAttributeException {
        if (value != null && this.type.isAssignableFrom(value.getClass())) {
            if (value != this.unexpectedValue && value != this.unsupportedValue) {
                try {
                    this.validator.validate(value);
                }
                catch (RuntimeException rex) {
                    throw new IllegalCICSAttributeException((Exception)rex, (ICICSAttribute)this, value);
                }
            }
        } else {
            throw new IllegalCICSAttributeException("value: " + value + " not an instance of " + this.type.getSimpleName(), (ICICSAttribute)this, value);
        }
    }

    public ICICSAttributeHint getValuesHint() {
        return this.validator.getValuesHint();
    }

    public String normalize(String denormalizedString, Map<String, INormalizer> normalizers) throws NormalizationException {
        INormalizer normalizer = normalizers.get(this.getNormalizerKey());
        if (normalizer != null) {
            return normalizer.normalize(denormalizedString);
        }
        return denormalizedString;
    }

    public String denormalize(String normalizedString, Map<String, INormalizer> normalizers) throws NormalizationException {
        INormalizer normalizer = normalizers.get(this.getNormalizerKey());
        if (normalizer != null) {
            return normalizer.denormalize(normalizedString);
        }
        return normalizedString;
    }

    public abstract String getNormalizerKey();

    public final String set(T modelValue, Map<String, INormalizer> denormalizers) throws IllegalCICSAttributeException {
        String stringValue;
        if (modelValue == this.unsupportedValue) {
            logger.logp(Level.SEVERE, this.getClass().getName(), "set(T, Map<String, INormalizer>)", "Unsupported value can not be set");
            throw new IllegalCICSAttributeException("Unsupported value can not be set", (ICICSAttribute)this, modelValue);
        }
        try {
            stringValue = this.internalToExternalImpl(modelValue);
        }
        catch (IllegalCICSAttributeException exc) {
            logger.logp(Level.SEVERE, this.getClass().getName(), "set(T, Map<String, INormalizer>)", "Error performing internal to external conversion:modelValue=" + modelValue, exc);
            throw exc;
        }
        try {
            return this.denormalize(stringValue, denormalizers);
        }
        catch (NormalizationException ex) {
            throw new IllegalCICSAttributeException((Exception)((Object)ex), (ICICSAttribute)this, (Object)stringValue);
        }
    }

    public final T get(String stringValue, Map<String, INormalizer> normalizers) {
        if (stringValue == "FORCE_ATTRIBUTE_UNSUPPORTED") {
            return this.unsupportedValue;
        }
        try {
            stringValue = this.normalize(stringValue, normalizers);
        }
        catch (NormalizationException ex) {
            if (Debug.DEBUG_ATTRIBUTES) {
                Exception exc2 = new Exception("get(String):" + this.cicsName + ":<" + stringValue + ">:unexpectedValue=" + this.unexpectedValue + ":AttributeConversionException", ex);
                logger.logp(Level.SEVERE, CICSAttribute.class.getName(), "get(String)", ex.getLocalizedMessage(), exc2);
            }
            return this.unexpectedValue;
        }
        if (stringValue == null) {
            if (this.alwaysSupported()) {
                if (Debug.DEBUG_ATTRIBUTES) {
                    Exception exc = new Exception("get(String):" + this.cicsName + ":<null>:unexpectedValue=" + this.unexpectedValue + ":validBetween=[" + this.validFrom + "," + this.validTo + "]");
                    logger.logp(Level.SEVERE, CICSAttribute.class.getName(), "get(String)", exc.getLocalizedMessage(), exc);
                }
                return this.unexpectedValue;
            }
            if (Debug.DEBUG_ATTRIBUTES) {
                Exception exc = new Exception("get(String):" + this.cicsName + ":<null>:unsupportedValue=" + this.unsupportedValue + ":validBetween=[" + this.validFrom + "," + this.validTo + "]");
                logger.logp(Level.SEVERE, CICSAttribute.class.getName(), "get(String)", exc.getLocalizedMessage(), exc);
            }
            return this.unsupportedValue;
        }
        try {
            return this.externalToInternal(stringValue);
        }
        catch (IllegalCICSAttributeException exc) {
            if (Debug.DEBUG_ATTRIBUTES) {
                Exception exc2 = new Exception("get(String):" + this.cicsName + ":<" + stringValue + ">:unexpectedValue=" + this.unexpectedValue + ":AttributeConversionException", exc);
                logger.logp(Level.SEVERE, CICSAttribute.class.getName(), "get(String)", exc.getLocalizedMessage(), exc2);
            }
            return this.unexpectedValue;
        }
    }

    private boolean alwaysSupported() {
        return this.validFrom == null && this.validTo == null;
    }

    public abstract T externalToInternal(String var1) throws IllegalCICSAttributeException;

    public String internalToExternal(T modelValue) throws IllegalCICSAttributeException {
        if (this.type.isAssignableFrom(modelValue.getClass())) {
            if (modelValue == this.getUnexpectedValue()) {
                throw new IllegalCICSAttributeException("The unexpected marker value has no external representation", (ICICSAttribute)this, modelValue);
            }
            if (modelValue == this.getUnsupportedValue()) {
                throw new IllegalCICSAttributeException("the unsupported marker value has no external representation", (ICICSAttribute)this, modelValue);
            }
            return this.internalToExternalImpl(modelValue);
        }
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("value: " + modelValue);
        if (modelValue != null) {
            errorMessage.append(" type: ");
            errorMessage.append(modelValue.getClass().getSimpleName());
        }
        errorMessage.append(" not an instance of " + this.type.getSimpleName());
        throw new IllegalCICSAttributeException(errorMessage.toString(), (ICICSAttribute)this, modelValue);
    }

    protected abstract String internalToExternalImpl(T var1) throws IllegalCICSAttributeException;

    public T getUnsupportedValue() {
        return this.unsupportedValue;
    }

    public T getUnexpectedValue() {
        return this.unexpectedValue;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isSupported(CICSRelease targetRel) {
        boolean result = true;
        CICSRelease currentValidFrom = this.getValidFrom();
        CICSRelease currentValidTo = this.getValidTo();
        if (currentValidFrom != null && !targetRel.laterThanOrEqualTo(currentValidFrom.getCICSTSLevel())) {
            result = false;
        }
        if (currentValidTo != null && targetRel.laterThan(currentValidTo.getCICSTSLevel())) {
            result = false;
        }
        return result;
    }
}

