/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.Messages;
import com.ibm.cics.model.CICSRelease;
import com.ibm.cics.model.Debug;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeConstants;
import com.ibm.cics.model.ICICSAttributeValidator;
import com.ibm.cics.model.IllegalCICSAttributeException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import org.eclipse.osgi.util.NLS;

public class CICSDateAttribute
extends CICSAttribute<Date> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ThreadLocal<DateFormat> threadLocalDateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ".substring(0, 25));
        }
    };

    CICSDateAttribute(String propertyId, String categoryId, String cicsName, ICICSAttributeValidator validator, Date defaultValue, CICSRelease validFrom, CICSRelease validTo) {
        super(propertyId, categoryId, cicsName, Date.class, validator, defaultValue, ICICSAttributeConstants.UNEXPECTED_DATE, ICICSAttributeConstants.UNSUPPORTED_DATE, validFrom, validTo);
    }

    @Override
    public String getNormalizerKey() {
        return "DATE_NORMALIZER_KEY";
    }

    @Override
    protected String internalToExternalImpl(Date modelValue) throws IllegalCICSAttributeException {
        if (ICICSAttributeConstants.UNSPECIFIED_DATE == modelValue) {
            return "";
        }
        return String.valueOf(threadLocalDateFormat.get().format(modelValue)) + "+0000";
    }

    @Override
    public Date externalToInternal(String stringValue) throws IllegalCICSAttributeException {
        if ("".equals(stringValue)) {
            if (Debug.DEBUG_ATTRIBUTES) {
                Exception exc = new Exception("e2i:" + this.getCicsName() + ": <emptystring>");
                logger.logp(Level.SEVERE, this.getClass().getName(), "e2i", exc.getLocalizedMessage(), exc);
            }
            return ICICSAttributeConstants.UNSPECIFIED_DATE;
        }
        if ("0000-00-00T00:00:00.000+0000".equals(stringValue)) {
            if (Debug.DEBUG_ATTRIBUTES) {
                Exception exc = new Exception("e2i:" + this.getCicsName() + " '" + stringValue + "' replaced by ISMCommConstants.UNSPECIFIED_DATE=" + ICICSAttributeConstants.UNSPECIFIED_DATE);
                logger.logp(Level.SEVERE, this.getClass().getName(), "e2i", exc.getLocalizedMessage(), exc);
            }
            return ICICSAttributeConstants.UNSPECIFIED_DATE;
        }
        String errorMessage = NLS.bind((String)Messages.CICSDateAttribute_invalidDate, (Object[])new Object[]{stringValue, "yyyy-MM-dd'T'HH:mm:ss.SSSZ"});
        try {
            DateFormat dateFormat = threadLocalDateFormat.get();
            if (stringValue.length() < 23) {
                throw new IllegalCICSAttributeException(errorMessage, (ICICSAttribute)this, (Object)stringValue);
            }
            Date date = dateFormat.parse(stringValue.substring(0, 23));
            if (date != null) {
                return date;
            }
            IllegalCICSAttributeException exc = new IllegalCICSAttributeException(errorMessage, (ICICSAttribute)this, (Object)stringValue);
            throw exc;
        }
        catch (ParseException parseException) {
            IllegalCICSAttributeException exc2 = new IllegalCICSAttributeException(NLS.bind((String)Messages.CICSDateAttribute_invalidDate, (Object[])new Object[]{stringValue, "yyyy-MM-dd'T'HH:mm:ss.SSSZ"}), (ICICSAttribute)this, (Object)stringValue);
            throw exc2;
        }
    }
}

