/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.IConnectionState;
import com.ibm.cics.core.connections.internal.Messages;
import java.text.MessageFormat;
import org.eclipse.swt.graphics.Image;

public class NoConnection
implements IConnectionState {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String connectionCategoryID;
    private String name;

    public NoConnection(String connectionCategory) {
        this.connectionCategoryID = connectionCategory;
    }

    private void calculateName() {
        IConnectionCategory connectionCategory = ConnectionRegistry.getConnectionRegistry().findCategory(this.connectionCategoryID);
        String abbreviatedName = connectionCategory != null ? connectionCategory.getAbbreviatedName() : null;
        this.name = abbreviatedName != null ? MessageFormat.format(Messages.NoConnection_noConnection, abbreviatedName) : Messages.NoConnection_noSMConnection;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.calculateName();
        }
        return this.name;
    }

    @Override
    public String getMessage() {
        return this.getName();
    }

    @Override
    public Image getImage() {
        return ConnectionsImages.getImage("IN_ACTIVE_CONNECTION");
    }

    @Override
    public String getMenuMessage() {
        return this.getMessage();
    }

    public String toString() {
        return "NO_CONNECTION";
    }

    @Override
    public String getID() {
        return null;
    }

    @Override
    public ConnectionProfile getConnectionProfile() {
        return null;
    }

    @Override
    public Image getOverlayImage() {
        return ConnectionsImages.getImage("DISCONNECTED_OVERLAY");
    }
}

