/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.TransactionGroupReference;
import com.ibm.cics.core.model.TransactionGroupType;
import com.ibm.cics.core.model.internal.MutableCPSMDefinition;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSObjectSet;
import com.ibm.cics.model.ICPSMDefinition;
import com.ibm.cics.model.ITransactionGroup;
import com.ibm.cics.model.ITransactionGroupEntry;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableTransactionGroup;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableTransactionGroup
extends MutableCPSMDefinition
implements IMutableTransactionGroup {
    private ITransactionGroup delegate;
    private MutableSMRecord record;

    public MutableTransactionGroup(ICPSM cpsm, IContext context, ITransactionGroup cicsObject) {
        super(cpsm, context, (ICPSMDefinition)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("TRANGRP");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public ITransactionGroup.AffinityRelationValue getAffinityRelation() {
        String result = this.record.get("AFFINITY");
        if (result == null) {
            return this.delegate.getAffinityRelation();
        }
        return (ITransactionGroup.AffinityRelationValue)((CICSAttribute)TransactionGroupType.AFFINITY_RELATION).get(result, this.record.getNormalizers());
    }

    public ITransactionGroup.AffinityLifetimeValue getAffinityLifetime() {
        String result = this.record.get("AFFLIFE");
        if (result == null) {
            return this.delegate.getAffinityLifetime();
        }
        return (ITransactionGroup.AffinityLifetimeValue)((CICSAttribute)TransactionGroupType.AFFINITY_LIFETIME).get(result, this.record.getNormalizers());
    }

    public ITransactionGroup.MatchKeyValue getMatchKey() {
        String result = this.record.get("MATCH");
        if (result == null) {
            return this.delegate.getMatchKey();
        }
        return (ITransactionGroup.MatchKeyValue)((CICSAttribute)TransactionGroupType.MATCH_KEY).get(result, this.record.getNormalizers());
    }

    public ITransactionGroup.StatusValue getStatus() {
        String result = this.record.get("STATE");
        if (result == null) {
            return this.delegate.getStatus();
        }
        return (ITransactionGroup.StatusValue)((CICSAttribute)TransactionGroupType.STATUS).get(result, this.record.getNormalizers());
    }

    public String getDescription() {
        String result = this.record.get("DESC");
        if (result == null) {
            return this.delegate.getDescription();
        }
        return (String)((CICSAttribute)TransactionGroupType.DESCRIPTION).get(result, this.record.getNormalizers());
    }

    public String getRtaEvent() {
        String result = this.record.get("EVENTNAME");
        if (result == null) {
            return this.delegate.getRtaEvent();
        }
        return (String)((CICSAttribute)TransactionGroupType.RTA_EVENT).get(result, this.record.getNormalizers());
    }

    public Long getAbendProbability() {
        String result = this.record.get("ABENDCRIT");
        if (result == null) {
            return this.delegate.getAbendProbability();
        }
        return (Long)((CICSAttribute)TransactionGroupType.ABEND_PROBABILITY).get(result, this.record.getNormalizers());
    }

    public Long getAbendLoadLevel() {
        String result = this.record.get("ABENDTHRESH");
        if (result == null) {
            return this.delegate.getAbendLoadLevel();
        }
        return (Long)((CICSAttribute)TransactionGroupType.ABEND_LOAD_LEVEL).get(result, this.record.getNormalizers());
    }

    public ITransactionGroup.CreateAffinityValue getCreateAffinity() {
        String result = this.record.get("AFFAUTO");
        if (result == null) {
            return this.delegate.getCreateAffinity();
        }
        return (ITransactionGroup.CreateAffinityValue)((CICSAttribute)TransactionGroupType.CREATE_AFFINITY).get(result, this.record.getNormalizers());
    }

    public ITransactionGroup.AlgorithmTypeValue getAlgorithmType() {
        String result = this.record.get("ALGTYPE");
        if (result == null) {
            return this.delegate.getAlgorithmType();
        }
        return (ITransactionGroup.AlgorithmTypeValue)((CICSAttribute)TransactionGroupType.ALGORITHM_TYPE).get(result, this.record.getNormalizers());
    }

    public void setAffinityRelation(ITransactionGroup.AffinityRelationValue _affinityRelation) {
        if (_affinityRelation.equals((Object)this.delegate.getAffinityRelation())) {
            this.record.set("AFFINITY", null);
        } else {
            TransactionGroupType.AFFINITY_RELATION.validate((Object)_affinityRelation);
            String connectionSpecificExternalValue = ((CICSAttribute)TransactionGroupType.AFFINITY_RELATION).set(_affinityRelation, this.record.getNormalizers());
            this.record.set("AFFINITY", connectionSpecificExternalValue);
        }
    }

    public void setAffinityLifetime(ITransactionGroup.AffinityLifetimeValue _affinityLifetime) {
        if (_affinityLifetime.equals((Object)this.delegate.getAffinityLifetime())) {
            this.record.set("AFFLIFE", null);
        } else {
            TransactionGroupType.AFFINITY_LIFETIME.validate((Object)_affinityLifetime);
            String connectionSpecificExternalValue = ((CICSAttribute)TransactionGroupType.AFFINITY_LIFETIME).set(_affinityLifetime, this.record.getNormalizers());
            this.record.set("AFFLIFE", connectionSpecificExternalValue);
        }
    }

    public void setMatchKey(ITransactionGroup.MatchKeyValue _matchKey) {
        if (_matchKey.equals((Object)this.delegate.getMatchKey())) {
            this.record.set("MATCH", null);
        } else {
            TransactionGroupType.MATCH_KEY.validate((Object)_matchKey);
            String connectionSpecificExternalValue = ((CICSAttribute)TransactionGroupType.MATCH_KEY).set(_matchKey, this.record.getNormalizers());
            this.record.set("MATCH", connectionSpecificExternalValue);
        }
    }

    public void setStatus(ITransactionGroup.StatusValue _status) {
        if (_status.equals((Object)this.delegate.getStatus())) {
            this.record.set("STATE", null);
        } else {
            TransactionGroupType.STATUS.validate((Object)_status);
            String connectionSpecificExternalValue = ((CICSAttribute)TransactionGroupType.STATUS).set(_status, this.record.getNormalizers());
            this.record.set("STATE", connectionSpecificExternalValue);
        }
    }

    public void setDescription(String _description) {
        if (_description.equals(this.delegate.getDescription())) {
            this.record.set("DESC", null);
        } else {
            TransactionGroupType.DESCRIPTION.validate((Object)_description);
            String connectionSpecificExternalValue = ((CICSAttribute)TransactionGroupType.DESCRIPTION).set(_description, this.record.getNormalizers());
            this.record.set("DESC", connectionSpecificExternalValue);
        }
    }

    public void setRtaEvent(String _rtaEvent) {
        if (_rtaEvent.equals(this.delegate.getRtaEvent())) {
            this.record.set("EVENTNAME", null);
        } else {
            TransactionGroupType.RTA_EVENT.validate((Object)_rtaEvent);
            String connectionSpecificExternalValue = ((CICSAttribute)TransactionGroupType.RTA_EVENT).set(_rtaEvent, this.record.getNormalizers());
            this.record.set("EVENTNAME", connectionSpecificExternalValue);
        }
    }

    public void setAbendProbability(Long _abendProbability) {
        if (_abendProbability.equals(this.delegate.getAbendProbability())) {
            this.record.set("ABENDCRIT", null);
        } else {
            TransactionGroupType.ABEND_PROBABILITY.validate((Object)_abendProbability);
            String connectionSpecificExternalValue = ((CICSAttribute)TransactionGroupType.ABEND_PROBABILITY).set(_abendProbability, this.record.getNormalizers());
            this.record.set("ABENDCRIT", connectionSpecificExternalValue);
        }
    }

    public void setAbendLoadLevel(Long _abendLoadLevel) {
        if (_abendLoadLevel.equals(this.delegate.getAbendLoadLevel())) {
            this.record.set("ABENDTHRESH", null);
        } else {
            TransactionGroupType.ABEND_LOAD_LEVEL.validate((Object)_abendLoadLevel);
            String connectionSpecificExternalValue = ((CICSAttribute)TransactionGroupType.ABEND_LOAD_LEVEL).set(_abendLoadLevel, this.record.getNormalizers());
            this.record.set("ABENDTHRESH", connectionSpecificExternalValue);
        }
    }

    public void setCreateAffinity(ITransactionGroup.CreateAffinityValue _createAffinity) {
        if (_createAffinity.equals((Object)this.delegate.getCreateAffinity())) {
            this.record.set("AFFAUTO", null);
        } else {
            TransactionGroupType.CREATE_AFFINITY.validate((Object)_createAffinity);
            String connectionSpecificExternalValue = ((CICSAttribute)TransactionGroupType.CREATE_AFFINITY).set(_createAffinity, this.record.getNormalizers());
            this.record.set("AFFAUTO", connectionSpecificExternalValue);
        }
    }

    public void setAlgorithmType(ITransactionGroup.AlgorithmTypeValue _algorithmType) {
        if (_algorithmType.equals((Object)this.delegate.getAlgorithmType())) {
            this.record.set("ALGTYPE", null);
        } else {
            TransactionGroupType.ALGORITHM_TYPE.validate((Object)_algorithmType);
            String connectionSpecificExternalValue = ((CICSAttribute)TransactionGroupType.ALGORITHM_TYPE).set(_algorithmType, this.record.getNormalizers());
            this.record.set("ALGTYPE", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == TransactionGroupType.NAME) {
            return (V)this.getName();
        }
        if (attribute == TransactionGroupType.AFFINITY_RELATION) {
            return (V)this.getAffinityRelation();
        }
        if (attribute == TransactionGroupType.AFFINITY_LIFETIME) {
            return (V)this.getAffinityLifetime();
        }
        if (attribute == TransactionGroupType.MATCH_KEY) {
            return (V)this.getMatchKey();
        }
        if (attribute == TransactionGroupType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == TransactionGroupType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        if (attribute == TransactionGroupType.RTA_EVENT) {
            return (V)this.getRtaEvent();
        }
        if (attribute == TransactionGroupType.ABEND_PROBABILITY) {
            return (V)this.getAbendProbability();
        }
        if (attribute == TransactionGroupType.ABEND_LOAD_LEVEL) {
            return (V)this.getAbendLoadLevel();
        }
        if (attribute == TransactionGroupType.CREATE_AFFINITY) {
            return (V)this.getCreateAffinity();
        }
        if (attribute == TransactionGroupType.ALGORITHM_TYPE) {
            return (V)this.getAlgorithmType();
        }
        return super.getAttributeValue(attribute);
    }

    public TransactionGroupType getObjectType() {
        return TransactionGroupType.getInstance();
    }

    @Override
    public TransactionGroupReference getCICSObjectReference() {
        return new TransactionGroupReference(this.getCICSContainer(), this.getName());
    }

    public ICICSObjectSet<ITransactionGroupEntry> getTransactionsInGroup() {
        return TransactionGroupType.TRANSACTIONS_IN_GROUP.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }
}

