/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.WorkloadRouterStatusReference;
import com.ibm.cics.core.model.WorkloadRouterStatusType;
import com.ibm.cics.core.model.internal.CPSMManager;
import com.ibm.cics.model.IWorkloadRouterStatus;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public abstract class WorkloadRouterStatusGen
extends CPSMManager
implements IWorkloadRouterStatus {
    private String _workload;
    private String _tor;
    private IWorkloadRouterStatus.ContactStatusValue _con_status;
    private String _wrklowner;
    private String _torowner;
    private IWorkloadRouterStatus.OptimizationStatusValue _owstate;
    private Long _rtuowend;
    private String _mvssysname;
    private String _fmidseq;
    private String _strttime;
    private String _release;
    private IWorkloadRouterStatus.AbendCompensationStatusValue _abdcmpstate;
    private String _rptingcmas;

    public WorkloadRouterStatusGen(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("WORKLOAD");
        this._workload = (String)((CICSAttribute)WorkloadRouterStatusType.WORKLOAD).get(stringValue, normalizers);
        stringValue = record.get("TOR");
        this._tor = (String)((CICSAttribute)WorkloadRouterStatusType.ROUTING_REGION).get(stringValue, normalizers);
        stringValue = record.get("CON_STATUS");
        this._con_status = (IWorkloadRouterStatus.ContactStatusValue)((CICSAttribute)WorkloadRouterStatusType.CONTACT_STATUS).get(stringValue, normalizers);
        stringValue = record.get("WRKLOWNER");
        this._wrklowner = (String)((CICSAttribute)WorkloadRouterStatusType.WORKLOAD_OWNER).get(stringValue, normalizers);
        stringValue = record.get("TOROWNER");
        this._torowner = (String)((CICSAttribute)WorkloadRouterStatusType.TOR_OWNER).get(stringValue, normalizers);
        stringValue = record.get("OWSTATE");
        this._owstate = (IWorkloadRouterStatus.OptimizationStatusValue)((CICSAttribute)WorkloadRouterStatusType.OPTIMIZATION_STATUS).get(stringValue, normalizers);
        stringValue = record.get("RTUOWEND");
        this._rtuowend = (Long)((CICSAttribute)WorkloadRouterStatusType.UOW_COMPLETES).get(stringValue, normalizers);
        stringValue = record.get("MVSSYSNAME");
        this._mvssysname = (String)((CICSAttribute)WorkloadRouterStatusType.MVS_SYSTEM_NAME).get(stringValue, normalizers);
        stringValue = record.get("FMIDSEQ");
        this._fmidseq = (String)((CICSAttribute)WorkloadRouterStatusType.FMID_SEQUENCE).get(stringValue, normalizers);
        stringValue = record.get("STRTTIME");
        this._strttime = (String)((CICSAttribute)WorkloadRouterStatusType.START_TIME).get(stringValue, normalizers);
        stringValue = record.get("RELEASE");
        this._release = (String)((CICSAttribute)WorkloadRouterStatusType.RELEASE).get(stringValue, normalizers);
        stringValue = record.get("ABDCMPSTATE");
        this._abdcmpstate = (IWorkloadRouterStatus.AbendCompensationStatusValue)((CICSAttribute)WorkloadRouterStatusType.ABEND_COMPENSATION_STATUS).get(stringValue, normalizers);
        stringValue = record.get("RPTINGCMAS");
        this._rptingcmas = (String)((CICSAttribute)WorkloadRouterStatusType.REPORTING_CMAS).get(stringValue, normalizers);
    }

    public String getWorkload() {
        return this._workload;
    }

    public String getRoutingRegion() {
        return this._tor;
    }

    public IWorkloadRouterStatus.ContactStatusValue getContactStatus() {
        return this._con_status;
    }

    public String getWorkloadOwner() {
        return this._wrklowner;
    }

    public String getTorOwner() {
        return this._torowner;
    }

    public IWorkloadRouterStatus.OptimizationStatusValue getOptimizationStatus() {
        return this._owstate;
    }

    public Long getUowCompletes() {
        return this._rtuowend;
    }

    public String getMvsSystemName() {
        return this._mvssysname;
    }

    public String getFmidSequence() {
        return this._fmidseq;
    }

    public String getStartTime() {
        return this._strttime;
    }

    public String getRelease() {
        return this._release;
    }

    public IWorkloadRouterStatus.AbendCompensationStatusValue getAbendCompensationStatus() {
        return this._abdcmpstate;
    }

    public String getReportingCMAS() {
        return this._rptingcmas;
    }

    public WorkloadRouterStatusType getObjectType() {
        return WorkloadRouterStatusType.getInstance();
    }

    @Override
    public WorkloadRouterStatusReference getCICSObjectReference() {
        return new WorkloadRouterStatusReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == WorkloadRouterStatusType.WORKLOAD) {
            return (V)this.getWorkload();
        }
        if (attribute == WorkloadRouterStatusType.ROUTING_REGION) {
            return (V)this.getRoutingRegion();
        }
        if (attribute == WorkloadRouterStatusType.CONTACT_STATUS) {
            return (V)this.getContactStatus();
        }
        if (attribute == WorkloadRouterStatusType.WORKLOAD_OWNER) {
            return (V)this.getWorkloadOwner();
        }
        if (attribute == WorkloadRouterStatusType.TOR_OWNER) {
            return (V)this.getTorOwner();
        }
        if (attribute == WorkloadRouterStatusType.OPTIMIZATION_STATUS) {
            return (V)this.getOptimizationStatus();
        }
        if (attribute == WorkloadRouterStatusType.UOW_COMPLETES) {
            return (V)this.getUowCompletes();
        }
        if (attribute == WorkloadRouterStatusType.MVS_SYSTEM_NAME) {
            return (V)this.getMvsSystemName();
        }
        if (attribute == WorkloadRouterStatusType.FMID_SEQUENCE) {
            return (V)this.getFmidSequence();
        }
        if (attribute == WorkloadRouterStatusType.START_TIME) {
            return (V)this.getStartTime();
        }
        if (attribute == WorkloadRouterStatusType.RELEASE) {
            return (V)this.getRelease();
        }
        if (attribute == WorkloadRouterStatusType.ABEND_COMPENSATION_STATUS) {
            return (V)this.getAbendCompensationStatus();
        }
        if (attribute == WorkloadRouterStatusType.REPORTING_CMAS) {
            return (V)this.getReportingCMAS();
        }
        V value = super.getAttributeValue(attribute);
        if (value != null) {
            return value;
        }
        throw new IllegalArgumentException("Supplied attribute \"" + attribute + "\" was not a valid attribute for type " + WorkloadRouterStatusType.getInstance());
    }
}

