// <copyright
//     notice="cicscm-rm-source-program"
//     pids="CA0W"
//     years="2015"
//     crc="1935635519" >
//     Licensed Materials - Property of IBM
//     "Restricted Materials of IBM"
//     CA0W
//     (C) Copyright IBM Corp. 2015
//     US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
// </copyright>

package com.ibm.cics.cm.ucd.steps;

import com.ibm.cics.cm.ucd.JuliToLog4jHandler;

import static com.ibm.cics.cm.ucd.StepLogHelper.printStepLog

import com.urbancode.air.AirPluginTool;
import com.ibm.cics.cm.model.runtime.CMServerException
import com.ibm.cics.core.comm.ConnectionException

import java.util.List;
import java.util.Map;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.Handler;
import java.util.logging.Level;

import com.google.gson.Gson;

abstract class Step {
	//  <copyright
	//      notice="cicscm-rm-object-program"
	//      pids="CA0W"
	//      years="2015"
	//      crc="1935635519" >
	//      Licensed Materials - Property of IBM
	//      "Restricted Materials of IBM"
	//      CA0W
	//      (C) Copyright IBM Corp. 2015
	//      US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
	//  </copyright>
	
	protected AirPluginTool apTool;
	protected List<Map<String,Object>> errorList;
	
	// Hold the Logger to avoid garbage-collection
	private Logger comIbmCicsLogger;
	private Handler activeHandler;
	private static final String stepEntry = "STEP ENTRY >"; //$NON-NLS-1$
	private static final String stepExit = "STEP EXIT <"; //$NON-NLS-1$

	public Step(String inputPropertyFile, String outputPropertyFile) {
		apTool = new AirPluginTool(inputPropertyFile, outputPropertyFile);
	}

	/*
	 * Constructor for unit testing
	 */
	Step(AirPluginTool apTool) {
		this.apTool = apTool;
	}

	public void log(String msg) {
		printStepLog(msg);
	}
	
	public void logTrace(Level level, String sourceClass, String sourceMethod, String msg) {
		comIbmCicsLogger.logp(level, sourceClass, sourceMethod, msg)
	}
	public void logTrace(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
		comIbmCicsLogger.logp(level, sourceClass, sourceMethod, msg, param1)
	}
	
	public void logTrace(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
		comIbmCicsLogger.logp(level, sourceClass, sourceMethod, msg, params)
	}
	public void before() {
		errorList = new ArrayList<Map<String,Object>>();
		
		Logger rootLogger = LogManager.getLogManager().getLogger("");
		// Remove any old handlers
		for (Handler handler : rootLogger.getHandlers()) {
			rootLogger.removeHandler(handler);
		}
		
		// Create our own logger
		comIbmCicsLogger = Logger.getLogger("com.ibm.cics");
		comIbmCicsLogger.setUseParentHandlers(false);
		
		// Pass all events on
		Level handlerLevel = Level.ALL;
		Level rootLevel = Level.ALL;
		
		// Add our own handler to JUL
		activeHandler = new JuliToLog4jHandler();
		activeHandler.setLevel(handlerLevel);
		comIbmCicsLogger.addHandler(activeHandler);
		rootLogger.setLevel(rootLevel);
	}

	public void after() {
		comIbmCicsLogger.removeHandler(activeHandler)
		
		Gson errorJSON = new Gson();
		apTool.setOutputProperty("cics.response.errors",errorJSON.toJson(errorList));
		apTool.storeOutputProperties();
	}
	
	protected abstract void runStep() throws ConnectionException, CMServerException;
	
	public void run() throws Exception {
		try {
			before();
			logTrace(Level.INFO, this.class.getName(), "run", stepEntry)
			
			runStep();
			
			logTrace(Level.INFO, this.class.getName(), "run", stepExit)
		} finally {
			after();
		}
	}

}
