//**************************************************************************************************************************************//
//                                                                                                                                      //
// <copyright                                                                                                                           //
//     notice="cicscm-rm-source-program"                                                                                                //
//     pids="CA0W"                                                                                                                      //
//     years="2015"                                                                                                                     //
//     crc="2480307173" >                                                                                                               //
//     Licensed Materials - Property of IBM                                                                                             //
//     "Restricted Materials of IBM"                                                                                                    //
//     CA0W                                                                                                                             //
//     (C) Copyright IBM Corp. 2015                                                                                                     //
//     US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.    //
// </copyright>                                                                                                                         //
//                                                                                                                                      //
//**************************************************************************************************************************************//
package com.ibm.cics.cm.ucd.steps

import java.text.MessageFormat
import java.util.List;

import com.ibm.cics.cm.model.runtime.CMConnection
import com.ibm.cics.cm.model.runtime.CMServerException
import com.ibm.cics.cm.model.runtime.SelectionCriteria
import com.ibm.cics.cm.model.runtime.ProcessParms
import com.ibm.cics.cm.model.runtime.LocationCriteria
import com.ibm.cics.cm.model.runtime.ObjectCriteria
import com.ibm.cics.cm.model.runtime.ObjectCriteriaList
import com.ibm.cics.cm.model.runtime.MessageResponse
import com.ibm.cics.cm.ucd.properties.BooleanProperty
import com.ibm.cics.cm.ucd.properties.CommonCICSNameProperty
import com.ibm.cics.cm.ucd.properties.CSDConnectionProperty
import com.ibm.cics.cm.ucd.msg.CICSUCDMessage
import com.ibm.cics.cm.ucd.steplabel.CICSUCDStepLabel
import com.urbancode.air.AirPluginTool

import static com.ibm.cics.cm.ucd.StepLogHelper.printStepLog

class InstallChangePackageStep extends CICSStep {
	//  <copyright
	//      notice="cicscm-rm-object-program"
	//      pids="CA0W"
	//      years="2015"
	//      crc="2480307173" >
	//      Licensed Materials - Property of IBM
	//      "Restricted Materials of IBM"
	//      CA0W
	//      (C) Copyright IBM Corp. 2015
	//      US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
	//  </copyright>
	
	public InstallChangePackageStep(String inputPropertyFile, String outputPropertyFile) {
		super(inputPropertyFile, outputPropertyFile)
	}

	public InstallChangePackageStep(AirPluginTool apTool) {
		super(apTool)
	}

	@Override
	protected void runCICSStep(CMConnection conn) throws CMServerException {
		
		def props = apTool.getStepProperties()
		def changePackage = new CommonCICSNameProperty(CICSUCDStepLabel.CHANGE_PACKAGE, true).parse(props['changePackage']).getValue()
		def targetConfig = new CommonCICSNameProperty(CICSUCDStepLabel.TARGET_CONFIG, true).parse(props['targetConfig']).getValue()
		def csdConnection = new CSDConnectionProperty(CICSUCDStepLabel.CSD_CONNECTION, true).parse(props['csdConnection']).getValue()
		def quiesce = new BooleanProperty(CICSUCDStepLabel.QUIESCE, false).parse(props['quiesce']).getValue()
		def discard = new BooleanProperty(CICSUCDStepLabel.DISCARD, false).parse(props['discard']).getValue()
		
		def quiesceValue = quiesce ? "YES" : "NO"
		def discardValue = discard ? "YES" : "NO"
		
		Set<Map<String, String>> resources = getChangePackageResources(conn, changePackage)
		
		try {
			printStepLog(MessageFormat.format(CICSUCDMessage.installResources, changePackage, csdConnection))
			resources.each {
				installResource(conn, targetConfig, quiesceValue, discardValue, csdConnection, it)
			}
			printStepLog(MessageFormat.format(CICSUCDMessage.installPackageSuccessful, changePackage, csdConnection))
		} catch(CMServerException e) {
			printStepLog(MessageFormat.format(CICSUCDMessage.installPackageFailed, changePackage, csdConnection))
			throw e
		}
		
	}
	
	private void installResource(CMConnection conn, String targetConfig, String quiesceValue, String discardValue, String csdConnection, 
		Map<String, String> resources) throws CMServerException {
		
		LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(targetConfig)
		
		def resourceName = resources.get("NAME")
		ObjectCriteriaList objectCriteriaList = new ObjectCriteriaList()
		objectCriteriaList.addListElement(resources.get("GROUP"), resources.get("TYPE"), resourceName)
		
		ProcessParms processParms = ProcessParms.getInstallForCSD(quiesceValue, discardValue, csdConnection)
		
		try {
			conn.install(locationCriteria, objectCriteriaList, processParms)
			printStepLog(MessageFormat.format(CICSUCDMessage.installResourceSuccessful, resourceName))
		} catch(CMServerException e) {
			printStepLog(MessageFormat.format(CICSUCDMessage.installResourceFailed, resourceName, e.getMessage()))
			throw e
		}

	}
	
	Set<Map<String, String>> getChangePackageResources(CMConnection conn, String changePackage) throws CMServerException {
		
		LocationCriteria locationCriteria = LocationCriteria.newRepositoryLocationCriteria()
		ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForChangePackageList(changePackage)
		
		def serverResponse = null
		try {
			serverResponse = conn.listResources(locationCriteria, objectCriteria, null)
			printStepLog(MessageFormat.format(CICSUCDMessage.packageDataRetrievalSuccessful, changePackage, serverResponse.getReturnResponse()))
		} catch (CMServerException e) {
			printStepLog(MessageFormat.format(CICSUCDMessage.packageDataRetrievalFailed, changePackage, e.getMessage()))
			throw e
		}
		
		Set<Map<String, String>> resources = new HashSet<Map<String, String>>()
		
		if(serverResponse != null) {
			Iterator<Map<String, String>> iterator = serverResponse.getObjects()
			while(iterator.hasNext()){
				Map<String, String> attributes = iterator.next()
				Map<String, String> data = new HashMap<String, String>()
				data.put("NAME", attributes.get("SEL_OBJNAME"))
				data.put("GROUP", attributes.get("SEL_GROUP"))
				data.put("TYPE", attributes.get("SEL_OBJTYPE"))
				resources.add(data)
			}
		}
		
		return resources
	}

}
