//**************************************************************************************************************************************//
//                                                                                                                                      //
// <copyright                                                                                                                           //
//     notice="cicscm-rm-source-program"                                                                                                //
//     pids="CA0W"                                                                                                                      //
//     years="2015"                                                                                                                     //
//     crc="852785946" >                                                                                                                //
//     Licensed Materials - Property of IBM                                                                                             //
//     "Restricted Materials of IBM"                                                                                                    //
//     CA0W                                                                                                                             //
//     (C) Copyright IBM Corp. 2015                                                                                                     //
//     US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.    //
// </copyright>                                                                                                                         //
//                                                                                                                                      //
//**************************************************************************************************************************************//
package com.ibm.cics.cm.ucd.steps

import java.text.MessageFormat
import java.util.List

import com.ibm.cics.cm.model.runtime.CMConnection
import com.ibm.cics.cm.model.runtime.CMServerException
import com.ibm.cics.cm.model.runtime.LocationCriteria
import com.ibm.cics.cm.model.runtime.ObjectCriteria
import com.ibm.cics.cm.model.runtime.ListMessageResponse
import com.ibm.cics.cm.ucd.msg.CICSUCDMessage
import com.ibm.cics.cm.ucd.properties.CommonCICSNameProperty
import com.ibm.cics.cm.ucd.steplabel.CICSUCDStepLabel
import com.urbancode.air.AirPluginTool

import static com.ibm.cics.cm.ucd.StepLogHelper.printStepLog

class QueryChangePackageStep extends CICSStep {
	//  <copyright
	//      notice="cicscm-rm-object-program"
	//      pids="CA0W"
	//      years="2015"
	//      crc="852785946" >
	//      Licensed Materials - Property of IBM
	//      "Restricted Materials of IBM"
	//      CA0W
	//      (C) Copyright IBM Corp. 2015
	//      US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
	//  </copyright>
	
	public QueryChangePackageStep(String inputPropertyFile, String outputPropertyFile) {
		super(inputPropertyFile, outputPropertyFile)
	}

	public QueryChangePackageStep(AirPluginTool apTool) {
		super(apTool)
	}

	@Override
	protected void runCICSStep(CMConnection conn) throws CMServerException {
		
		def props = apTool.getStepProperties()
		def changePackage = new CommonCICSNameProperty(CICSUCDStepLabel.CHANGE_PACKAGE, true).parse(props['changePackage']).getValue()
		
		LocationCriteria locationCriteria = LocationCriteria.newRepositoryLocationCriteria()
		ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForChangePackageList(changePackage)
		
		def serverResponse = null
		try {
			serverResponse = conn.listResources(locationCriteria, objectCriteria, null)
			printStepLog(MessageFormat.format(CICSUCDMessage.querySuccessful, changePackage, serverResponse.getReturnResponse()))
		} catch (CMServerException e) {
			printStepLog(MessageFormat.format(CICSUCDMessage.queryFailed, changePackage, e.getMessage()))
			throw e
		}
		
		List<String> resources = new ArrayList<String>()
		Set<String> names = new HashSet<String>()
		Set<String> groups = new HashSet<String>()
		Set<String> types = new HashSet<String>()
		
		if(serverResponse != null) {
			Iterator<Map<String, String>> iterator = serverResponse.getObjects()
			while(iterator.hasNext()) {
				Map<String, String> attributes = iterator.next()
				names.add(attributes.get("SEL_OBJNAME"))
				groups.add(attributes.get("SEL_GROUP"))
				types.add(attributes.get("SEL_OBJTYPE"))
			}
			resources.add(createString(names))
			resources.add(createString(groups))
			resources.add(createString(types))
		}
		
		// set output properties
		setOutputProperties(resources)
	}
	
	private void setOutputProperties(List<String> changePackageData) {
		
		if (!changePackageData.empty) {
			apTool.setOutputProperty("resourceNames", changePackageData.get(0))
			apTool.setOutputProperty("resourceGroups", changePackageData.get(1))
			apTool.setOutputProperty("resourceTypes", changePackageData.get(2))
			apTool.storeOutputProperties()
		}
	}
	
	String createString(Set<String> data) {
		
		int length = 0
		data.each {
			length += it.length() + 2
		}
		
		StringBuilder buffer = new StringBuilder(length);
		String delimiter = ", "
		data.each {
			buffer.append(it).append(delimiter)
		}
		return buffer.substring(0, length-2)
	}

}
