//**************************************************************************************************************************************//
//                                                                                                                                      //
// <copyright                                                                                                                           //
//     notice="cicscm-rm-source-program"                                                                                                //
//     pids="CA0W"                                                                                                                      //
//     years="2015"                                                                                                                     //
//     crc="611957479" >                                                                                                                //
//     Licensed Materials - Property of IBM                                                                                             //
//     "Restricted Materials of IBM"                                                                                                    //
//     CA0W                                                                                                                             //
//     (C) Copyright IBM Corp. 2015                                                                                                     //
//     US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.    //
// </copyright>                                                                                                                         //
//                                                                                                                                      //
//**************************************************************************************************************************************//
package com.ibm.cics.cm.ucd

import java.text.MessageFormat

import com.ibm.cics.cm.model.runtime.CMConnection
import com.ibm.cics.core.comm.ConnectionConfiguration
import com.ibm.cics.core.comm.ConnectionException
import com.ibm.cics.cm.ucd.properties.HostProperty
import com.ibm.cics.cm.ucd.properties.PortProperty
import com.ibm.cics.cm.ucd.properties.PropertyException
import com.ibm.cics.cm.ucd.properties.StringProperty
import com.ibm.cics.cm.ucd.properties.BooleanProperty
import com.ibm.cics.cm.ucd.steplabel.CICSUCDStepLabel
import com.ibm.cics.cm.ucd.msg.CICSUCDMessage

import static com.ibm.cics.cm.ucd.StepLogHelper.printStepLog

class CreateConnection {
	//  <copyright
	//      notice="cicscm-rm-object-program"
	//      pids="CA0W"
	//      years="2015"
	//      crc="611957479" >
	//      Licensed Materials - Property of IBM
	//      "Restricted Materials of IBM"
	//      CA0W
	//      (C) Copyright IBM Corp. 2015
	//      US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
	//  </copyright>
	
	private final def hostname
	private final def port
	private final def username
	private final def password
	private final def ssl
	
	static def HOSTNAME_PROPERTY = 'hostname'
	static def PORT_PROPERTY = 'port'
	static def USERNAME_PROPERTY = 'username'
	static def PASSWORD_PROPERTY = 'password'
	static def SSL_PROPERTY = 'ssl'
	
	public CreateConnection(Properties props) throws PropertyException {

		hostname = new HostProperty(CICSUCDStepLabel.HOSTNAME, true).parse(props[HOSTNAME_PROPERTY]).getValue()
		port = new PortProperty(CICSUCDStepLabel.PORT, true).parse(props[PORT_PROPERTY]).getValue()
		username = new StringProperty(CICSUCDStepLabel.USERNAME, false).parse(props[USERNAME_PROPERTY]).getValue()
		password = new StringProperty(CICSUCDStepLabel.PASSWORD, false).parse(props[PASSWORD_PROPERTY]).getValue()
//		ssl = new BooleanProperty(CICSUCDStepLabel.SSL, false).parse(props[SSL_PROPERTY]).getValue()
	}
	
	protected void establishConnection(CMConnection conn) throws ConnectionException {
		
		// set connection properties - ssl automatically set to false
		ConnectionConfiguration config = new ConnectionConfiguration("conn-conf-id", "conn-conf-name", hostname, port, "cred-id", false)
		config.setUserID(username ? username : null)
		config.setPassword(password ? password : null)
		
		conn.setUrbanCodeOnlyConnection(config)
		
		try {
			conn.connect()
			printStepLog(MessageFormat.format(CICSUCDMessage.connectionEstablished, hostname + ":" + port))
		} catch (ConnectionException e) {
			printStepLog(createConnectionErrorMessage(e))
			throw e
		}
	}

	String createConnectionErrorMessage(ConnectionException e) {
		if (e.getCause() instanceof UnknownHostException) {
			return MessageFormat.format(CICSUCDMessage.unknownHost, hostname, e.getMessage())
		}
		return MessageFormat.format(CICSUCDMessage.connectionFailedWithError, hostname + ":" + port, e.getMessage())
	}

}
