//**************************************************************************************************************************************//
//                                                                                                                                      //
// <copyright                                                                                                                           //
//     notice="cicscm-rm-source-program"                                                                                                //
//     pids="CA0W"                                                                                                                      //
//     years="2015"                                                                                                                     //
//     crc="3128955604" >                                                                                                               //
//     Licensed Materials - Property of IBM                                                                                             //
//     "Restricted Materials of IBM"                                                                                                    //
//     CA0W                                                                                                                             //
//     (C) Copyright IBM Corp. 2015                                                                                                     //
//     US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.    //
// </copyright>                                                                                                                         //
//                                                                                                                                      //
//**************************************************************************************************************************************//
package com.ibm.cics.cm.ucd.steps

import com.ibm.cics.cm.ucd.CreateConnection
import com.ibm.cics.cm.ucd.properties.PropertyException
import com.ibm.cics.cm.model.runtime.CMServerException
import com.ibm.cics.cm.model.runtime.CMConnection
import com.ibm.cics.core.comm.ConnectionException
import com.ibm.cics.core.model.ICPSM
import com.urbancode.air.AirPluginTool

abstract class CICSStep extends Step {
	//  <copyright
	//      notice="cicscm-rm-object-program"
	//      pids="CA0W"
	//      years="2015"
	//      crc="3128955604" >
	//      Licensed Materials - Property of IBM
	//      "Restricted Materials of IBM"
	//      CA0W
	//      (C) Copyright IBM Corp. 2015
	//      US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
	//  </copyright>

	public CICSStep(String inputPropertyFile, String outputPropertyFile) {
		super(inputPropertyFile, outputPropertyFile)
	}
	
	public CICSStep(AirPluginTool apTool) {
		super(apTool)
	}
		
	@Override
	protected void runStep() throws ConnectionException, CMServerException {
		CreateConnection createConn = setUpConnection()
		CMConnection conn = new CMConnection();
		
		createConn.establishConnection(conn)
		runCICSStep(conn);
	}
		
	protected CreateConnection setUpConnection() throws PropertyException {
		return new CreateConnection(apTool.getStepProperties())
	}
	
	protected abstract void runCICSStep(CMConnection conn) throws CMServerException;
	
}
