//**************************************************************************************************************************************//
//                                                                                                                                      //
// <copyright                                                                                                                           //
//     notice="cicscm-rm-source-program"                                                                                                //
//     pids="CA0W"                                                                                                                      //
//     years="2015"                                                                                                                     //
//     crc="2184833197" >                                                                                                               //
//     Licensed Materials - Property of IBM                                                                                             //
//     "Restricted Materials of IBM"                                                                                                    //
//     CA0W                                                                                                                             //
//     (C) Copyright IBM Corp. 2015                                                                                                     //
//     US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.    //
// </copyright>                                                                                                                         //
//                                                                                                                                      //
//**************************************************************************************************************************************//
package com.ibm.cics.cm.ucd.steps

import java.text.MessageFormat
import java.util.List

import com.ibm.cics.cm.model.runtime.CMConnection
import com.ibm.cics.cm.model.runtime.CMServerException
import com.ibm.cics.cm.model.runtime.SelectionCriteria
import com.ibm.cics.cm.ucd.msg.CICSUCDMessage
import com.ibm.cics.cm.ucd.properties.CommonCICSNameProperty
import com.ibm.cics.cm.ucd.steplabel.CICSUCDStepLabel
import com.urbancode.air.AirPluginTool

import static com.ibm.cics.cm.ucd.StepLogHelper.printStepLog


class MigrateChangePackageStep extends CICSStep {
	//  <copyright
	//      notice="cicscm-rm-object-program"
	//      pids="CA0W"
	//      years="2015"
	//      crc="2184833197" >
	//      Licensed Materials - Property of IBM
	//      "Restricted Materials of IBM"
	//      CA0W
	//      (C) Copyright IBM Corp. 2015
	//      US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
	//  </copyright>
	
	public MigrateChangePackageStep(String inputPropertyFile, String outputPropertyFile) {
		super(inputPropertyFile, outputPropertyFile)
	}

	public MigrateChangePackageStep(AirPluginTool apTool) {
		super(apTool)
	}
	
	protected void runCICSStep(CMConnection conn) throws CMServerException {
		
		def props = apTool.getStepProperties()
		def changePackage = new CommonCICSNameProperty(CICSUCDStepLabel.CHANGE_PACKAGE, true).parse(props['changePackage']).getValue()
		def migrationScheme = new CommonCICSNameProperty(CICSUCDStepLabel.MIGRATION_SCHEME, true).parse(props['migrationScheme']).getValue()
		
		try {
			def serverResponse = conn.migrate(SelectionCriteria.newSelectionCriteriaForChangePackage(changePackage, migrationScheme))
			// migration of change package successful
			printStepLog(MessageFormat.format(CICSUCDMessage.migrationSuccessful, changePackage, migrationScheme, serverResponse.getReturnResponse()))
		} catch(CMServerException e) {
			printStepLog(MessageFormat.format(CICSUCDMessage.migrationFailed, changePackage, migrationScheme, e.getMessage()))
			throw e
		}
	}
	
}
