/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm;

import com.ibm.cics.sm.comm.FilterLogicMultipleOperands;
import com.ibm.cics.sm.comm.FilterLogicSingleOperand;
import com.ibm.cics.sm.comm.IComplexFilterExpression;
import com.ibm.cics.sm.comm.InvalidFilterException;
import java.util.ArrayList;
import java.util.List;

public abstract class FilterLogic
implements IComplexFilterExpression {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final LogicOperator type;
    protected List<IComplexFilterExpression> expressions = new ArrayList<IComplexFilterExpression>();

    protected FilterLogic(LogicOperator type) {
        this.type = type;
    }

    public LogicOperator getType() {
        return this.type;
    }

    public static FilterLogic createFilterLogic(LogicOperator type, List<IComplexFilterExpression> expressions) throws InvalidFilterException {
        switch (type) {
            case AND: 
            case OR: {
                return new FilterLogicMultipleOperands(type, expressions);
            }
            case IS: 
            case NOT: {
                if (expressions.size() != 1) {
                    throw new InvalidFilterException("Too many filter expressions for expression type: " + (Object)((Object)type));
                }
                return FilterLogic.createFilterLogic(type, expressions.get(0));
            }
        }
        throw new RuntimeException("Invalid filter expression type: " + (Object)((Object)type));
    }

    public static FilterLogic createFilterLogic(LogicOperator type, IComplexFilterExpression expression) throws InvalidFilterException {
        switch (type) {
            case AND: 
            case OR: {
                throw new InvalidFilterException("Too many filter expressions for expression type: " + (Object)((Object)type));
            }
            case IS: 
            case NOT: {
                return new FilterLogicSingleOperand(type, expression);
            }
        }
        throw new RuntimeException("Invalid filter expression type: " + (Object)((Object)type));
    }

    public static enum LogicOperator {
        AND,
        OR,
        IS,
        NOT;

    }
}

