/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.common.util;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Debug {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Level NORMAL_LEVEL = Level.FINER;
    public static final Level DETAIL_LEVEL = Level.FINEST;
    private final String className;
    private final Logger logger;
    private final Level level;

    protected Debug() {
        this(Debug.class, NORMAL_LEVEL);
    }

    public Debug(Class clazz) {
        this(clazz, NORMAL_LEVEL);
    }

    public Debug(Class clazz, Level level) {
        this.className = clazz.getName();
        this.logger = Logger.getLogger(clazz.getPackage().getName());
        this.level = level;
    }

    public final void enter(String sourceMethod) {
        this.logger.logp(this.level, this.className, sourceMethod, ">");
    }

    public final void enter(String sourceMethod, Object param1) {
        this.logger.logp(this.level, this.className, sourceMethod, ">", param1);
    }

    public final void enter(String sourceMethod, Object[] params) {
        this.logger.logp(this.level, this.className, sourceMethod, ">", params);
    }

    public final void enter(String sourceMethod, Object param1, Object param2) {
        this.logger.logp(this.level, this.className, sourceMethod, ">", new Object[]{param1, param2});
    }

    public final void enter(String sourceMethod, Object param1, Object param2, Object param3) {
        this.logger.logp(this.level, this.className, sourceMethod, ">", new Object[]{param1, param2, param3});
    }

    public final void enter(String sourceMethod, Object param1, Object param2, Object param3, Object param4) {
        this.logger.logp(this.level, this.className, sourceMethod, ">", new Object[]{param1, param2, param3, param4});
    }

    public final void enter(String sourceMethod, Object param1, Object param2, Object param3, Object param4, Object param5) {
        this.logger.logp(this.level, this.className, sourceMethod, ">", new Object[]{param1, param2, param3, param4, param5});
    }

    public final void event(String sourceMethod, String message) {
        this.logger.logp(this.level, this.className, sourceMethod, message);
    }

    public final void event(String sourceMethod, Object param) {
        Debug.event(this.logger, this.className, sourceMethod, new Object[]{param});
    }

    public final void event(String sourceMethod, Object[] params) {
        Debug.event(this.logger, this.className, sourceMethod, params);
    }

    public final void event(String sourceMethod, Object param1, Object param2) {
        Debug.event(this.logger, this.className, sourceMethod, new Object[]{param1, param2});
    }

    public final void event(String sourceMethod, Object param1, Object param2, Object param3) {
        Debug.event(this.logger, this.className, sourceMethod, new Object[]{param1, param2, param3});
    }

    public final void event(String sourceMethod, Throwable th, Map<String, String> attributes) {
        Debug.event(this.logger, this.className, sourceMethod, th, attributes);
    }

    public final void info(String sourceMethod, String message, Throwable thrown) {
        this.logger.log(Level.INFO, message, thrown);
    }

    public final void info(String sourceMethod, Object param) {
        Debug.info(this.logger, this.className, sourceMethod, param);
    }

    public final void info(String sourceMethod, Object ... params) {
        Debug.info(this.logger, this.className, sourceMethod, Arrays.asList(params));
    }

    public static final void info(Logger logger, String className, String sourceMethod, Object param1) {
        logger.logp(Level.INFO, className, sourceMethod, "?", param1);
    }

    public final void warning(String sourceMethod, String message, Throwable thrown) {
        this.logger.log(Level.WARNING, message, thrown);
    }

    public final void warning(String sourceMethod, Throwable th, Map<String, String> attributes) {
        Debug.warning(this.logger, this.className, sourceMethod, th, attributes);
    }

    public final void warning(String sourceMethod, Object param) {
        Debug.warning(this.logger, this.className, sourceMethod, param);
    }

    public final void warning(String sourceMethod, Object param1, Object param2) {
        Debug.warning(this.logger, this.className, sourceMethod, new Object[]{param1, param2});
    }

    public final void error(String sourceMethod, String message, Throwable th) {
        this.logger.logp(Level.SEVERE, this.className, sourceMethod, message, th);
    }

    public final void error(String sourceMethod, Throwable th) {
        this.logger.logp(Level.SEVERE, this.className, sourceMethod, th.toString(), th);
    }

    public final void error(String sourceMethod, String message) {
        this.logger.logp(Level.SEVERE, this.className, sourceMethod, message);
    }

    public final void exit(String sourceMethod) {
        this.logger.logp(this.level, this.className, sourceMethod, "<");
    }

    public final void exit(String sourceMethod, Object param) {
        this.logger.logp(this.level, this.className, sourceMethod, "<", param);
    }

    public static final void enter(Logger logger, String className, String sourceMethod) {
        logger.logp(Level.FINER, className, sourceMethod, ">");
    }

    public static final void enter(Logger logger, String className, String sourceMethod, Object[] params) {
        logger.logp(Level.FINER, className, sourceMethod, ">", params);
    }

    public static final void enter(Logger logger, String className, String sourceMethod, Object param) {
        Debug.enter(logger, className, sourceMethod, new Object[]{param});
    }

    public static final void enter(Logger logger, String className, String sourceMethod, Object param1, Object param2) {
        Debug.enter(logger, className, sourceMethod, new Object[]{param1, param2});
    }

    public static final void enter(Logger logger, String className, String sourceMethod, Object param1, Object param2, Object param3) {
        Debug.enter(logger, className, sourceMethod, new Object[]{param1, param2, param3});
    }

    public static final void enter(Logger logger, String className, String sourceMethod, Object param1, Object param2, Object param3, Object param4) {
        Debug.enter(logger, className, sourceMethod, new Object[]{param1, param2, param3, param4});
    }

    public static final void enter(Logger logger, String className, String sourceMethod, Object param1, Object param2, Object param3, Object param4, Object param5) {
        Debug.enter(logger, className, sourceMethod, new Object[]{param1, param2, param3, param4, param5});
    }

    public static final void exit(Logger logger, String className, String sourceMethod) {
        logger.logp(Level.FINER, className, sourceMethod, "<");
    }

    public static final void exit(Logger logger, String className, String sourceMethod, Object param) {
        logger.logp(Level.FINER, className, sourceMethod, "<", param);
    }

    public static final void event(Logger logger, String className, String sourceMethod) {
        logger.logp(Level.FINER, className, sourceMethod, "-");
    }

    public static final void event(Logger logger, String className, String sourceMethod, Object param) {
        Debug.event(logger, className, sourceMethod, new Object[]{param});
    }

    public static final void event(Logger logger, Level level, String className, String sourceMethod, Object param) {
        Debug.event(logger, level, className, sourceMethod, new Object[]{param});
    }

    public static final void event(Logger logger, String className, String sourceMethod, Object param1, Object param2) {
        Debug.event(logger, className, sourceMethod, new Object[]{param1, param2});
    }

    public static final void event(Logger logger, String className, String sourceMethod, Object param1, Object param2, Object param3) {
        Debug.event(logger, className, sourceMethod, new Object[]{param1, param2, param3});
    }

    public static final void event(Logger logger, String className, String sourceMethod, Object[] params) {
        logger.logp(Level.FINER, className, sourceMethod, "-", params);
    }

    public static final void event(Logger logger, String className, String sourceMethod, Throwable th, Map<String, String> attributes) {
        Object[] array = attributes.entrySet().toArray();
        logger.logp(Level.FINER, className, sourceMethod, th.toString(), array);
    }

    public static final void event(Logger logger, Level level, String className, String sourceMethod, Object[] params) {
        logger.logp(level, className, sourceMethod, "-", params);
    }

    public static final void warning(Logger logger, String className, String sourceMethod, Object[] params) {
        logger.logp(Level.WARNING, className, sourceMethod, "?", params);
    }

    public static final void error(Logger logger, String className, String sourceMethod, Throwable th) {
        logger.logp(Level.SEVERE, className, sourceMethod, th.toString(), th);
    }

    public static final void warning(Logger logger, String className, String sourceMethod, Object param1) {
        logger.logp(Level.WARNING, className, sourceMethod, "?", param1);
    }

    public static final void warning(Logger logger, String className, String sourceMethod, Object param1, Object param2) {
        logger.logp(Level.WARNING, className, sourceMethod, "?", new Object[]{param1, param2});
    }

    public static final void warning(Logger logger, String className, String sourceMethod, Object param1, Object param2, Object param3) {
        logger.logp(Level.WARNING, className, sourceMethod, "?", new Object[]{param1, param2, param3});
    }

    public static final void warning(Logger logger, String className, String sourceMethod, Throwable th, Map<String, String> attributes) {
        Object[] array = attributes.entrySet().toArray();
        logger.logp(Level.WARNING, className, sourceMethod, th.toString(), array);
    }

    public static final void warning(Logger logger, String className, String sourceMethod, String message, Throwable th) {
        logger.logp(Level.WARNING, className, sourceMethod, message, th);
    }

    public static Object formatObj(Object obj) {
        if (obj == null || obj instanceof String || obj instanceof Number || obj instanceof Boolean || obj instanceof Exception || obj instanceof Character || obj instanceof Class || obj instanceof File || obj instanceof StringBuffer || obj instanceof URL) {
            return obj;
        }
        try {
            return String.valueOf(obj.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(obj));
        }
        catch (Exception exception) {
            return String.valueOf(obj.getClass().getName()) + "@FFFFFFFF";
        }
    }
}

