/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.model.CombinedSITParametersType;
import com.ibm.cics.core.model.SystemParameterValue;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICombinedSITParameters;
import com.ibm.cics.model.meta.IAttribute;
import java.util.HashMap;
import java.util.Map;

public class CombinedSITParameters
implements ICombinedSITParameters {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<IAttribute, SystemParameterValue> attributeValues = new HashMap<IAttribute, SystemParameterValue>();

    public CombinedSITParameters() {
        ICICSAttribute<SystemParameterValue>[] iCICSAttributeArray = this.getObjectType().attributes();
        int n = iCICSAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICICSAttribute<SystemParameterValue> attribute = iCICSAttributeArray[n2];
            this.attributeValues.put((IAttribute)attribute, (SystemParameterValue)attribute.getUnsupportedValue());
            ++n2;
        }
    }

    public void setAttributeValue(IAttribute attribute, SystemParameterValue systemParameter) {
        if (!this.isValidAttribute(attribute)) {
            throw new InvalidAttributeException(attribute);
        }
        this.attributeValues.put(attribute, systemParameter);
    }

    public SystemParameterValue getAttributeValue(IAttribute attribute) {
        if (this.isValidAttribute(attribute)) {
            return this.attributeValues.get(attribute);
        }
        throw new InvalidAttributeException(attribute);
    }

    private boolean isValidAttribute(IAttribute attribute) {
        return this.attributeValues.containsKey(attribute);
    }

    public CombinedSITParametersType getObjectType() {
        return CombinedSITParametersType.getInstance();
    }

    private class InvalidAttributeException
    extends IllegalArgumentException {
        public InvalidAttributeException(IAttribute attribute) {
            super(String.valueOf(attribute.getPropertyId()) + " is not valid for type " + ((Object)((Object)CombinedSITParameters.this.getObjectType())).getClass().getName());
        }
    }
}

