/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.EventProcessingReference;
import com.ibm.cics.core.model.EventProcessingType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IEventProcessing;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableEventProcessing;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableEventProcessing
extends MutableCICSResource
implements IMutableEventProcessing {
    private IEventProcessing delegate;
    private MutableSMRecord record;

    public MutableEventProcessing(ICPSM cpsm, IContext context, IEventProcessing cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("EVNTGBL");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public IEventProcessing.EventProcessingStatusValue getEventProcessingStatus() {
        String result = this.record.get("EPSTATUS");
        if (result == null) {
            return this.delegate.getEventProcessingStatus();
        }
        return (IEventProcessing.EventProcessingStatusValue)((CICSAttribute)EventProcessingType.EVENT_PROCESSING_STATUS).get(result, this.record.getNormalizers());
    }

    public Long getEvntfiltops() {
        return this.delegate.getEvntfiltops();
    }

    public Long getEvntfiltcap() {
        return this.delegate.getEvntfiltcap();
    }

    public Long getEvntdisable() {
        return this.delegate.getEvntdisable();
    }

    public Long getPutEvents() {
        return this.delegate.getPutEvents();
    }

    public Long getEvntcommit() {
        return this.delegate.getEvntcommit();
    }

    public Long getEvntbackout() {
        return this.delegate.getEvntbackout();
    }

    public Long getCurrentEventCaptureQueue() {
        return this.delegate.getCurrentEventCaptureQueue();
    }

    public Long getEvntpeakevq() {
        return this.delegate.getEvntpeakevq();
    }

    public Long getCurrentTransactionalQueue() {
        return this.delegate.getCurrentTransactionalQueue();
    }

    public Long getEvntpeaktrq() {
        return this.delegate.getEvntpeaktrq();
    }

    public Long getEvntnorm() {
        return this.delegate.getEvntnorm();
    }

    public Long getEvntprio() {
        return this.delegate.getEvntprio();
    }

    public Long getEvnttran() {
        return this.delegate.getEvnttran();
    }

    public Long getEvnttrandis() {
        return this.delegate.getEvnttrandis();
    }

    public Long getEvnttranatt() {
        return this.delegate.getEvnttranatt();
    }

    public Long getEvntcurrdsp() {
        return this.delegate.getEvntcurrdsp();
    }

    public Long getEvntpeakdsp() {
        return this.delegate.getEvntpeakdsp();
    }

    public Long getEvntmqadapt() {
        return this.delegate.getEvntmqadapt();
    }

    public Long getEvnttsqstat() {
        return this.delegate.getEvnttsqstat();
    }

    public Long getEvnttransad() {
        return this.delegate.getEvnttransad();
    }

    public Long getEvntcustad() {
        return this.delegate.getEvntcustad();
    }

    public Long getEvntdomstid() {
        return this.delegate.getEvntdomstid();
    }

    public Long getEvntfiltopsf() {
        return this.delegate.getEvntfiltopsf();
    }

    public Long getEvntcapopsf() {
        return this.delegate.getEvntcapopsf();
    }

    public Long getEvntlostco() {
        return this.delegate.getEvntlostco();
    }

    public Long getEvntlostot() {
        return this.delegate.getEvntlostot();
    }

    public Long getEvntdspfailc() {
        return this.delegate.getEvntdspfailc();
    }

    public Long getEvntdspfailo() {
        return this.delegate.getEvntdspfailo();
    }

    public Long getEvntsynccap() {
        return this.delegate.getEvntsynccap();
    }

    public Long getEvntsyncfail() {
        return this.delegate.getEvntsyncfail();
    }

    public Long getEvnthttpcnt() {
        return this.delegate.getEvnthttpcnt();
    }

    public String getSchemalevel() {
        return this.delegate.getSchemalevel();
    }

    public Long getEvntlostau() {
        return this.delegate.getEvntlostau();
    }

    public Long getEvntsyscap() {
        return this.delegate.getEvntsyscap();
    }

    public void setEventProcessingStatus(IEventProcessing.EventProcessingStatusValue _eventProcessingStatus) {
        if (_eventProcessingStatus.equals((Object)this.delegate.getEventProcessingStatus())) {
            this.record.set("EPSTATUS", null);
        } else {
            EventProcessingType.EVENT_PROCESSING_STATUS.validate((Object)_eventProcessingStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)EventProcessingType.EVENT_PROCESSING_STATUS).set(_eventProcessingStatus, this.record.getNormalizers());
            this.record.set("EPSTATUS", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == EventProcessingType.EVENT_PROCESSING_STATUS) {
            return (V)this.getEventProcessingStatus();
        }
        if (attribute == EventProcessingType.EVNTFILTOPS) {
            return (V)this.getEvntfiltops();
        }
        if (attribute == EventProcessingType.EVNTFILTCAP) {
            return (V)this.getEvntfiltcap();
        }
        if (attribute == EventProcessingType.EVNTDISABLE) {
            return (V)this.getEvntdisable();
        }
        if (attribute == EventProcessingType.PUT_EVENTS) {
            return (V)this.getPutEvents();
        }
        if (attribute == EventProcessingType.EVNTCOMMIT) {
            return (V)this.getEvntcommit();
        }
        if (attribute == EventProcessingType.EVNTBACKOUT) {
            return (V)this.getEvntbackout();
        }
        if (attribute == EventProcessingType.CURRENT_EVENT_CAPTURE_QUEUE) {
            return (V)this.getCurrentEventCaptureQueue();
        }
        if (attribute == EventProcessingType.EVNTPEAKEVQ) {
            return (V)this.getEvntpeakevq();
        }
        if (attribute == EventProcessingType.CURRENT_TRANSACTIONAL_QUEUE) {
            return (V)this.getCurrentTransactionalQueue();
        }
        if (attribute == EventProcessingType.EVNTPEAKTRQ) {
            return (V)this.getEvntpeaktrq();
        }
        if (attribute == EventProcessingType.EVNTNORM) {
            return (V)this.getEvntnorm();
        }
        if (attribute == EventProcessingType.EVNTPRIO) {
            return (V)this.getEvntprio();
        }
        if (attribute == EventProcessingType.EVNTTRAN) {
            return (V)this.getEvnttran();
        }
        if (attribute == EventProcessingType.EVNTTRANDIS) {
            return (V)this.getEvnttrandis();
        }
        if (attribute == EventProcessingType.EVNTTRANATT) {
            return (V)this.getEvnttranatt();
        }
        if (attribute == EventProcessingType.EVNTCURRDSP) {
            return (V)this.getEvntcurrdsp();
        }
        if (attribute == EventProcessingType.EVNTPEAKDSP) {
            return (V)this.getEvntpeakdsp();
        }
        if (attribute == EventProcessingType.EVNTMQADAPT) {
            return (V)this.getEvntmqadapt();
        }
        if (attribute == EventProcessingType.EVNTTSQSTAT) {
            return (V)this.getEvnttsqstat();
        }
        if (attribute == EventProcessingType.EVNTTRANSAD) {
            return (V)this.getEvnttransad();
        }
        if (attribute == EventProcessingType.EVNTCUSTAD) {
            return (V)this.getEvntcustad();
        }
        if (attribute == EventProcessingType.EVNTDOMSTID) {
            return (V)this.getEvntdomstid();
        }
        if (attribute == EventProcessingType.EVNTFILTOPSF) {
            return (V)this.getEvntfiltopsf();
        }
        if (attribute == EventProcessingType.EVNTCAPOPSF) {
            return (V)this.getEvntcapopsf();
        }
        if (attribute == EventProcessingType.EVNTLOSTCO) {
            return (V)this.getEvntlostco();
        }
        if (attribute == EventProcessingType.EVNTLOSTOT) {
            return (V)this.getEvntlostot();
        }
        if (attribute == EventProcessingType.EVNTDSPFAILC) {
            return (V)this.getEvntdspfailc();
        }
        if (attribute == EventProcessingType.EVNTDSPFAILO) {
            return (V)this.getEvntdspfailo();
        }
        if (attribute == EventProcessingType.EVNTSYNCCAP) {
            return (V)this.getEvntsynccap();
        }
        if (attribute == EventProcessingType.EVNTSYNCFAIL) {
            return (V)this.getEvntsyncfail();
        }
        if (attribute == EventProcessingType.EVNTHTTPCNT) {
            return (V)this.getEvnthttpcnt();
        }
        if (attribute == EventProcessingType.SCHEMALEVEL) {
            return (V)this.getSchemalevel();
        }
        if (attribute == EventProcessingType.EVNTLOSTAU) {
            return (V)this.getEvntlostau();
        }
        if (attribute == EventProcessingType.EVNTSYSCAP) {
            return (V)this.getEvntsyscap();
        }
        return super.getAttributeValue(attribute);
    }

    public EventProcessingType getObjectType() {
        return EventProcessingType.getInstance();
    }

    @Override
    public EventProcessingReference getCICSObjectReference() {
        return new EventProcessingReference(this.getCICSContainer());
    }
}

