/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.PipelineReference;
import com.ibm.cics.core.model.PipelineType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSEnums;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IPipeline;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutablePipeline;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutablePipeline
extends MutableCICSResource
implements IMutablePipeline {
    private IPipeline delegate;
    private MutableSMRecord record;

    public MutablePipeline(ICPSM cpsm, IContext context, IPipeline cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("PIPELINE");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public IPipeline.StatusValue getStatus() {
        String result = this.record.get("ENABLESTATUS");
        if (result == null) {
            return this.delegate.getStatus();
        }
        return (IPipeline.StatusValue)((CICSAttribute)PipelineType.STATUS).get(result, this.record.getNormalizers());
    }

    public Long getUseCount() {
        return this.delegate.getUseCount();
    }

    public String getConfigurationFile() {
        return this.delegate.getConfigurationFile();
    }

    public String getShelf() {
        return this.delegate.getShelf();
    }

    public String getWSDirectory() {
        return this.delegate.getWSDirectory();
    }

    public IPipeline.OperationModeValue getOperationMode() {
        return this.delegate.getOperationMode();
    }

    public Long getResponseWaitTime() {
        String result = this.record.get("RESPWAIT");
        if (result == null) {
            return this.delegate.getResponseWaitTime();
        }
        return (Long)((CICSAttribute)PipelineType.RESPONSE_WAIT_TIME).get(result, this.record.getNormalizers());
    }

    public Long getSOAPVersion() {
        return this.delegate.getSOAPVersion();
    }

    public Long getSOAPRelease() {
        return this.delegate.getSOAPRelease();
    }

    public String getSOAPLevel() {
        return this.delegate.getSOAPLevel();
    }

    public String getContentIDDomain() {
        return this.delegate.getContentIDDomain();
    }

    public IPipeline.MTOMStatusValue getMTOMStatus() {
        return this.delegate.getMTOMStatus();
    }

    public IPipeline.SendMTOMStatusValue getSendMTOMStatus() {
        return this.delegate.getSendMTOMStatus();
    }

    public ICICSEnums.YesNoValue getMTOMNoXOPStatus() {
        return this.delegate.getMTOMNoXOPStatus();
    }

    public IPipeline.XOPSupportStatusValue getXOPSupportStatus() {
        return this.delegate.getXOPSupportStatus();
    }

    public IPipeline.XOPDirectStatusValue getXOPDirectStatus() {
        return this.delegate.getXOPDirectStatus();
    }

    public String getChangeUserID() {
        return this.delegate.getChangeUserID();
    }

    public IPipeline.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getChangeAgentRelease() {
        return this.delegate.getChangeAgentRelease();
    }

    public IPipeline.InstallAgentValue getInstallAgent() {
        return this.delegate.getInstallAgent();
    }

    public Date getChangeTime() {
        return this.delegate.getChangeTime();
    }

    public String getDefineSource() {
        return this.delegate.getDefineSource();
    }

    public Date getDefineTime() {
        return this.delegate.getDefineTime();
    }

    public String getInstallUserID() {
        return this.delegate.getInstallUserID();
    }

    public Date getInstallTime() {
        return this.delegate.getInstallTime();
    }

    public Long getBasdefinever() {
        return this.delegate.getBasdefinever();
    }

    public String getMessageFormat() {
        return this.delegate.getMessageFormat();
    }

    public void setStatus(IPipeline.StatusValue _status) {
        if (_status.equals((Object)this.delegate.getStatus())) {
            this.record.set("ENABLESTATUS", null);
        } else {
            PipelineType.STATUS.validate((Object)_status);
            String connectionSpecificExternalValue = ((CICSAttribute)PipelineType.STATUS).set(_status, this.record.getNormalizers());
            this.record.set("ENABLESTATUS", connectionSpecificExternalValue);
        }
    }

    public void setResponseWaitTime(Long _responseWaitTime) {
        if (_responseWaitTime.equals(this.delegate.getResponseWaitTime())) {
            this.record.set("RESPWAIT", null);
        } else {
            PipelineType.RESPONSE_WAIT_TIME.validate((Object)_responseWaitTime);
            String connectionSpecificExternalValue = ((CICSAttribute)PipelineType.RESPONSE_WAIT_TIME).set(_responseWaitTime, this.record.getNormalizers());
            this.record.set("RESPWAIT", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == PipelineType.NAME) {
            return (V)this.getName();
        }
        if (attribute == PipelineType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == PipelineType.USE_COUNT) {
            return (V)this.getUseCount();
        }
        if (attribute == PipelineType.CONFIGURATION_FILE) {
            return (V)this.getConfigurationFile();
        }
        if (attribute == PipelineType.SHELF) {
            return (V)this.getShelf();
        }
        if (attribute == PipelineType.WS_DIRECTORY) {
            return (V)this.getWSDirectory();
        }
        if (attribute == PipelineType.OPERATION_MODE) {
            return (V)this.getOperationMode();
        }
        if (attribute == PipelineType.RESPONSE_WAIT_TIME) {
            return (V)this.getResponseWaitTime();
        }
        if (attribute == PipelineType.SOAP_VERSION) {
            return (V)this.getSOAPVersion();
        }
        if (attribute == PipelineType.SOAP_RELEASE) {
            return (V)this.getSOAPRelease();
        }
        if (attribute == PipelineType.SOAP_LEVEL) {
            return (V)this.getSOAPLevel();
        }
        if (attribute == PipelineType.CONTENT_ID_DOMAIN) {
            return (V)this.getContentIDDomain();
        }
        if (attribute == PipelineType.MTOM_STATUS) {
            return (V)this.getMTOMStatus();
        }
        if (attribute == PipelineType.SEND_MTOM_STATUS) {
            return (V)this.getSendMTOMStatus();
        }
        if (attribute == PipelineType.MTOM_NO_XOP_STATUS) {
            return (V)this.getMTOMNoXOPStatus();
        }
        if (attribute == PipelineType.XOP_SUPPORT_STATUS) {
            return (V)this.getXOPSupportStatus();
        }
        if (attribute == PipelineType.XOP_DIRECT_STATUS) {
            return (V)this.getXOPDirectStatus();
        }
        if (attribute == PipelineType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == PipelineType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == PipelineType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == PipelineType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == PipelineType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == PipelineType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == PipelineType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == PipelineType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == PipelineType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == PipelineType.BASDEFINEVER) {
            return (V)this.getBasdefinever();
        }
        if (attribute == PipelineType.MESSAGE_FORMAT) {
            return (V)this.getMessageFormat();
        }
        return super.getAttributeValue(attribute);
    }

    public PipelineType getObjectType() {
        return PipelineType.getInstance();
    }

    @Override
    public PipelineReference getCICSObjectReference() {
        return new PipelineReference(this.getCICSContainer(), this.getName());
    }
}

