/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.GenericContainer;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionResponse;
import java.util.ArrayList;
import java.util.List;

class ObjectGetter<T extends ICICSObject> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ICPSM cpsm;
    private final IContext context;
    private final ICICSType<T> type;
    private String stub;

    public ObjectGetter(ICPSM cpsm, ICICSType<T> type, IContext context) {
        this.cpsm = cpsm;
        this.type = type;
        this.context = context;
    }

    public ICICSType<T> getCICSType() {
        return this.type;
    }

    public int get() throws CICSActionException {
        SMConnectionResponse response = this.cpsm.get(this.type.getResourceTableName(), this.context);
        this.stub = response.getStub();
        return response.getRecordTotal();
    }

    public List<T> fetch(int start, int count) throws CICSActionException {
        if (this.stub == null) {
            throw new IllegalStateException("'get()' must be invoked before results can be fetched");
        }
        SMConnectionResponse response = this.cpsm.fetch(this.stub, start + 1, count);
        ArrayList<T> resources = new ArrayList<T>();
        int i = 0;
        while (i < response.getRecordCount()) {
            T resource = GenericContainer.createResource(this.cpsm, response.getRecord(i), this.type);
            resources.add(resource);
            ++i;
        }
        return resources;
    }

    public void discard() throws CICSActionException {
        if (this.stub == null) {
            throw new IllegalStateException("'get()' must be invoked before discard");
        }
        this.cpsm.discard2(this.stub);
        this.stub = null;
    }
}

