/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.WorkloadRouterReference;
import com.ibm.cics.core.model.WorkloadRouterType;
import com.ibm.cics.core.model.internal.CPSMManager;
import com.ibm.cics.model.IWorkloadRouter;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public abstract class WorkloadRouterGen
extends CPSMManager
implements IWorkloadRouter {
    private String _workload;
    private String _tor;
    private IWorkloadRouter.ContactStatusValue _con_status;
    private String _wrklowner;
    private String _torowner;
    private IWorkloadRouter.OptimizationStatusValue _owstate;

    public WorkloadRouterGen(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("WORKLOAD");
        this._workload = (String)((CICSAttribute)WorkloadRouterType.WORKLOAD).get(stringValue, normalizers);
        stringValue = record.get("TOR");
        this._tor = (String)((CICSAttribute)WorkloadRouterType.ROUTING_REGION).get(stringValue, normalizers);
        stringValue = record.get("CON_STATUS");
        this._con_status = (IWorkloadRouter.ContactStatusValue)((CICSAttribute)WorkloadRouterType.CONTACT_STATUS).get(stringValue, normalizers);
        stringValue = record.get("WRKLOWNER");
        this._wrklowner = (String)((CICSAttribute)WorkloadRouterType.WORKLOAD_OWNER).get(stringValue, normalizers);
        stringValue = record.get("TOROWNER");
        this._torowner = (String)((CICSAttribute)WorkloadRouterType.CMAS_OWNER).get(stringValue, normalizers);
        stringValue = record.get("OWSTATE");
        this._owstate = (IWorkloadRouter.OptimizationStatusValue)((CICSAttribute)WorkloadRouterType.OPTIMIZATION_STATUS).get(stringValue, normalizers);
    }

    public String getWorkload() {
        return this._workload;
    }

    public String getRoutingRegion() {
        return this._tor;
    }

    public IWorkloadRouter.ContactStatusValue getContactStatus() {
        return this._con_status;
    }

    public String getWorkloadOwner() {
        return this._wrklowner;
    }

    public String getCmasOwner() {
        return this._torowner;
    }

    public IWorkloadRouter.OptimizationStatusValue getOptimizationStatus() {
        return this._owstate;
    }

    public WorkloadRouterType getObjectType() {
        return WorkloadRouterType.getInstance();
    }

    @Override
    public WorkloadRouterReference getCICSObjectReference() {
        return new WorkloadRouterReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == WorkloadRouterType.WORKLOAD) {
            return (V)this.getWorkload();
        }
        if (attribute == WorkloadRouterType.ROUTING_REGION) {
            return (V)this.getRoutingRegion();
        }
        if (attribute == WorkloadRouterType.CONTACT_STATUS) {
            return (V)this.getContactStatus();
        }
        if (attribute == WorkloadRouterType.WORKLOAD_OWNER) {
            return (V)this.getWorkloadOwner();
        }
        if (attribute == WorkloadRouterType.CMAS_OWNER) {
            return (V)this.getCmasOwner();
        }
        if (attribute == WorkloadRouterType.OPTIMIZATION_STATUS) {
            return (V)this.getOptimizationStatus();
        }
        V value = super.getAttributeValue(attribute);
        if (value != null) {
            return value;
        }
        throw new IllegalArgumentException("Supplied attribute \"" + attribute + "\" was not a valid attribute for type " + WorkloadRouterType.getInstance());
    }
}

