/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.EventManager;
import com.ibm.cics.common.util.IStaleableEventListener;
import com.ibm.cics.core.connections.ConnectionManagerListener;
import com.ibm.cics.core.connections.ConnectionProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class HydratedConfigurationCache {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final EventManager<ConnectionManagerListener.ConnectionManagerEvent> eventManager = new EventManager();
    private Map<String, ConnectionProfile> cache = new HashMap<String, ConnectionProfile>();

    void remove(String configurationId) {
        ConnectionProfile oldConfiguration = this.cache.remove(configurationId);
        if (oldConfiguration != null) {
            this.eventManager.notifyListeners((Object)new ConnectionManagerListener.ConnectionProfileRemovedEvent(oldConfiguration));
        }
    }

    void update(ConnectionProfile configuration) {
        ConnectionProfile oldConfiguration = this.cache.put(configuration.getId(), configuration);
        if (oldConfiguration != null) {
            this.eventManager.notifyListeners((Object)new ConnectionManagerListener.ConnectionProfileUpdatedEvent(oldConfiguration, configuration));
        } else {
            this.eventManager.notifyListeners((Object)new ConnectionManagerListener.ConnectionProfileAddedEvent(configuration));
        }
    }

    public List<ConnectionProfile> getConfigurations() {
        return new ArrayList<ConnectionProfile>(this.cache.values());
    }

    public ConnectionProfile getConfiguration(String configurationId) {
        return this.cache.get(configurationId);
    }

    public void addListener(ConnectionManagerListener listener) {
        this.eventManager.addListener((IStaleableEventListener)listener);
    }
}

