/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui;

import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.ui.CICSTypePropertySource;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.properties.IAttributePropertyDescriptor;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.ContextHelper;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.IResourceErrorCode;
import com.ibm.cics.sm.comm.IResourceErrors;
import com.ibm.cics.sm.comm.ISMUpdateException;
import com.ibm.cics.sm.comm.IScopedContext;
import com.ibm.cics.sm.comm.SMUpdateConflictException;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import com.ibm.cics.sm.comm.TypeNotFoundException;
import com.ibm.cics.sm.comm.context.IGroupContext;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ExceptionMessageHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ExceptionMessageHelper.class.getPackage().getName());

    public static IStatus getStatus(CICSActionException ex, ICICSType<?> cicsType, int severity) {
        IStatus result = null;
        if (ex.getCause() instanceof SystemManagerConnectionException) {
            SystemManagerConnectionException connectionException = (SystemManagerConnectionException)ex.getCause();
            result = ExceptionMessageHelper.getStatus(connectionException, cicsType, severity);
        } else if (ex.getCause() instanceof ISMUpdateException) {
            ISMUpdateException updateException = (ISMUpdateException)ex.getCause();
            result = ExceptionMessageHelper.getStatus(updateException, cicsType, severity);
        }
        if (result == null) {
            logger.logp(Level.WARNING, ExceptionMessageHelper.class.getName(), "getStatus()", "Could not diagnose the supplied exception", (Throwable)ex);
            result = ExceptionMessageHelper.getUnknownStatus(ex, severity);
        }
        return result;
    }

    @Deprecated
    public static IStatus getStatus(CICSSystemManagerException ex, ICICSType<?> cicsType) {
        return ExceptionMessageHelper.getStatus((CICSActionException)ex, cicsType, 2);
    }

    public static IStatus getStatus(SystemManagerConnectionException ex, ICICSType<?> cicsType, int severity) {
        String message;
        int responseCode = ex.getResponseCode();
        IResourceErrorCode errorCode = ex.getFeedbackErrorCode();
        int resp1 = ex.getResp1();
        String function = ex.getFunction();
        if (responseCode != 200) {
            message = ExceptionMessageHelper.getHTTPErrorMessage(ex.getMessage(), responseCode, ex.getURL());
        } else if (resp1 != 0) {
            message = ExceptionMessageHelper.getPerformErrorMessage(function, ex.getResp1Name(), ex.getResp2());
        } else if (errorCode != null && errorCode.getErrorCode() != 0) {
            String attributeName = ex.getAttribute();
            ICICSAttribute attribute = null;
            if (attributeName != null && (attribute = cicsType.findAttributeByCicsName(attributeName)) == null) {
                logger.logp(Level.WARNING, ExceptionMessageHelper.class.getName(), "getStatus()", "Unknown attribute \"" + attributeName + "\" requested for CICS type \"" + cicsType.getResourceTableName() + "\"");
            }
            String errorLabel = errorCode instanceof IResourceErrors.UnknownError ? String.valueOf(errorCode.getErrorCode()) : errorCode.getLabel();
            message = ExceptionMessageHelper.getAttributeErrorMessage(cicsType, attribute, errorLabel);
        } else {
            message = ex instanceof TypeNotFoundException ? ex.getMessage() : (ex.getResponse() != 1024 ? ExceptionMessageHelper.getCPSMErrorMessage(ex) : (ex.getCause() instanceof CoreException && ((CoreException)ex.getCause()).getStatus() instanceof IResourceStatus ? (((CoreException)ex.getCause()).getStatus().getCode() == 275 ? ex.getCause().getMessage() : ExceptionMessageHelper.getUnknownErrorString(ex)) : ExceptionMessageHelper.getUnknownErrorString(ex)));
        }
        return new Status(severity, "com.ibm.cics.core.ui", message);
    }

    @Deprecated
    public static IStatus getStatus(SystemManagerConnectionException ex, ICICSType<?> cicsType) {
        return ExceptionMessageHelper.getStatus(ex, cicsType, 2);
    }

    public static String getAttributeWithReasonErrorMessage(ICICSType<?> cicsType, ICICSAttribute<?> attribute, String errorLabel, String resp, int resp2) {
        String attributeExplorerName = "";
        String attributeCICSName = "";
        if (attribute != null) {
            CICSTypePropertySource propertySource = new CICSTypePropertySource(cicsType);
            IAttributePropertyDescriptor propertyDescriptor = propertySource.getPropertyDescriptor(attribute.getPropertyId());
            attributeExplorerName = propertyDescriptor.getDisplayName();
            attributeCICSName = attribute.getCicsName();
        }
        String message = null;
        if (resp != null) {
            String resp2Message = ExceptionMessageHelper.getResp2Message(resp2);
            Object[] inserts = new Object[]{attributeExplorerName, attributeCICSName, errorLabel, resp, resp2Message};
            message = Messages.getString("error.attribute.reason", inserts);
        } else {
            Object[] inserts = new Object[]{attributeExplorerName, attributeCICSName, errorLabel};
            message = Messages.getString("error.attribute", inserts);
        }
        return message;
    }

    private static String getResp2Message(int resp2) {
        if (resp2 > 65535) {
            int first = (resp2 & 0x7FFF0000) >> 16;
            int second = resp2 & 0xFFFF;
            return String.valueOf(first) + ", " + second;
        }
        return "" + resp2;
    }

    public static String getAttributeErrorMessage(ICICSType<?> cicsType, ICICSAttribute<?> attribute, String errorLabel) {
        return ExceptionMessageHelper.getAttributeWithReasonErrorMessage(cicsType, attribute, errorLabel, null, -1);
    }

    public static String getCPSMErrorMessage(String response, String reason) {
        Object[] inserts = new Object[]{response, reason};
        return Messages.getString("error.cpsm", inserts);
    }

    public static String getCPSMErrorMessage(SystemManagerConnectionException ex) {
        if (ex.getReason() == 0) {
            return Messages.getString("error.cpsm.noreason", ex.getResponseName());
        }
        Object[] inserts = new Object[]{ex.getResponseName(), ex.getReasonName()};
        return Messages.getString("error.cpsm", inserts);
    }

    public static String getHTTPErrorMessage(String httpError, int httpErrorCode, URL url) {
        return Messages.getString("error.http", new Object[]{httpError, String.valueOf(httpErrorCode), url});
    }

    public static String getPerformErrorMessage(String eibfn, String resp, int resp2) {
        return Messages.getString("error.perform", new Object[]{eibfn, resp, ExceptionMessageHelper.getResp2Message(resp2)});
    }

    public static IStatus getUnknownStatus(Object o, int severity) {
        return new Status(severity, "com.ibm.cics.core.ui", 0, ExceptionMessageHelper.getUnknownErrorString(o), null);
    }

    private static String getUnknownErrorString(Object o) {
        return Messages.getString("error.unknown", o instanceof Throwable ? ((Throwable)o).getMessage() : o.toString());
    }

    @Deprecated
    public static IStatus getStatus(ISMUpdateException updateException, ICICSType<?> cicsType) {
        return ExceptionMessageHelper.getStatus(updateException, cicsType, 2);
    }

    public static IStatus getStatus(ISMUpdateException updateException, ICICSType<?> cicsType, int severity) {
        if (updateException.hasErrors()) {
            ISMUpdateException.IError error = (ISMUpdateException.IError)updateException.getErrors().get(0);
            String attributeName = (String)error.getAttributeNames().get(0);
            ICICSAttribute attribute = cicsType.findAttributeByCicsName(attributeName);
            String message = ExceptionMessageHelper.getAttributeWithReasonErrorMessage(cicsType, attribute, attributeName, updateException.getRESP(), updateException.getRESP2());
            return new Status(severity, "com.ibm.cics.core.ui", message);
        }
        if (updateException instanceof SMUpdateConflictException) {
            return new Status(severity, "com.ibm.cics.core.ui", Messages.getString("ExceptionMessageHelper.updateConflict"));
        }
        return ExceptionMessageHelper.getUnknownStatus(updateException, severity);
    }

    public static String getContextOrScopeNameFor(ICoreObject coreObject) {
        IPrimaryKey primaryKey = (IPrimaryKey)coreObject.getAdapter(IPrimaryKey.class);
        IContext parentContext = primaryKey.getParentContext();
        if (parentContext instanceof IGroupContext) {
            parentContext = ((IGroupContext)parentContext).getParentContext();
        }
        return ExceptionMessageHelper.getContextOrScopeNameFor(parentContext);
    }

    public static String getContextOrScopeNameFor(IContext context) {
        IScopedContext scopedContext = (IScopedContext)ContextHelper.getContextFrom((IContext)context, IScopedContext.class);
        if (scopedContext != null && !StringUtil.isEmpty((String)scopedContext.getScope())) {
            return scopedContext.getScope();
        }
        if (context != null) {
            return context.getContext();
        }
        return null;
    }

    public static String getObjectTypeDescription(ICICSObject cicsObject) {
        return ExceptionMessageHelper.getTypeDescription(cicsObject.getCICSType());
    }

    public static String getTypeDescription(ICICSType<?> cicsType) {
        return Messages.getTableDescription(cicsType.getResourceTableName());
    }
}

