/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.adapters;

import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.adapters.InstallTargetWorkbenchAdapter;
import com.ibm.cics.model.IRepository;
import com.ibm.cics.model.InstallTarget;
import com.ibm.cics.sm.comm.CSDRepository;
import com.ibm.cics.sm.comm.DREPRepository;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class RepositoryWorkbenchAdapter
implements IDeferredWorkbenchAdapter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IRepository repository;
    private ICPSM cpsm;

    public RepositoryWorkbenchAdapter(ICPSM cpsm, IRepository repo) {
        this.cpsm = cpsm;
        this.repository = repo;
    }

    public Object[] getChildren(Object object) {
        ArrayList<InstallTargetWorkbenchAdapter> targetAdapters = new ArrayList<InstallTargetWorkbenchAdapter>();
        for (InstallTarget target : this.repository.getInstallTargets()) {
            targetAdapters.add(new InstallTargetWorkbenchAdapter(this.repository, target));
        }
        return targetAdapters.toArray();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        ImageDescriptor descriptor = null;
        if (this.repository instanceof CSDRepository) {
            descriptor = UIPlugin.IMGD_CSD_REP;
        } else if (this.repository instanceof DREPRepository) {
            descriptor = UIPlugin.IMGD_DREP_REP;
        }
        return descriptor;
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        String message = Messages.getString("WorkbenchAdapterFactory.fetchDeferredChildren", object.toString());
        monitor.beginTask(message, -1);
        collector.add(this.getChildren(object), monitor);
        monitor.done();
    }

    public String getLabel(Object o) {
        return this.repository.getName();
    }

    public Object getParent(Object o) {
        return this.cpsm;
    }

    public boolean isContainer() {
        return true;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public IRepository getRepository() {
        return this.repository;
    }
}

