/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.internal.cloud.CloudMessages;
import com.ibm.cics.core.ui.internal.cloud.HierarchyStyle;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.osgi.service.prefs.BackingStoreException;

public class HierarchyDropDownAction
extends Action
implements IMenuCreator {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Menu menu;
    private HierarchyAction[] hierarchyActions = new HierarchyAction[2];
    private static Debug DEBUG = new Debug(HierarchyDropDownAction.class);

    public HierarchyDropDownAction() {
        super(NLS.bind((String)CloudMessages.HierarchyDropDownAction_switchHierarchyText, (Object)4, null));
        this.hierarchyActions[0] = new HierarchyAction(NLS.bind((String)CloudMessages.HierarchyDropDownAction_platformText, null), HierarchyStyle.PLATFORM);
        this.hierarchyActions[1] = new HierarchyAction(NLS.bind((String)CloudMessages.HierarchyDropDownAction_applicationText, null), HierarchyStyle.APPLICATION);
        HierarchyStyle hierarchyStyle = HierarchyStyle.getPreferenceHierarchyStyle(true);
        this.setImageDescriptor(hierarchyStyle.getImageDescriptor());
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
        }
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            return this.menu;
        }
        MenuManager manager = new MenuManager();
        HierarchyAction[] hierarchyActionArray = this.hierarchyActions;
        int n = this.hierarchyActions.length;
        int n2 = 0;
        while (n2 < n) {
            HierarchyAction action = hierarchyActionArray[n2];
            manager.add((IAction)action);
            ++n2;
        }
        this.menu = manager.createContextMenu(parent);
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void run() {
        DEBUG.enter("run");
        int i = 0;
        while (i < this.hierarchyActions.length) {
            HierarchyAction action = this.hierarchyActions[i];
            if (action.isChecked()) {
                try {
                    new ActionHandler((IAction)this.hierarchyActions[(i + 1) % this.hierarchyActions.length]).execute(new ExecutionEvent());
                    int j = 0;
                    while (j < this.hierarchyActions.length) {
                        this.hierarchyActions[j].setChecked((i + 1) % this.hierarchyActions.length == j);
                        ++j;
                    }
                    this.notifyResult(true);
                }
                catch (ExecutionException e) {
                    DEBUG.error("run", (Throwable)e);
                    this.notifyResult(false);
                }
                break;
            }
            ++i;
        }
        DEBUG.exit("run");
    }

    public class HierarchyAction
    extends Action {
        private final HierarchyStyle style;

        public HierarchyAction(String text, HierarchyStyle style) {
            super(text, 8);
            this.style = style;
            this.setImageDescriptor(style.getImageDescriptor());
            HierarchyStyle prefHierarchyStyle = HierarchyStyle.getPreferenceHierarchyStyle(true);
            this.setChecked(prefHierarchyStyle == this.style);
        }

        public void run() {
            IEclipsePreferences prefs;
            DEBUG.enter("run");
            if (this.isChecked() && (prefs = UIPlugin.getPluginInstancePreferences()) != null) {
                prefs.put("cloudExplorerHierarchy", this.style.name());
                try {
                    prefs.flush();
                }
                catch (BackingStoreException e) {
                    DEBUG.error("run", "Unable flush preferences", (Throwable)e);
                }
            }
            DEBUG.exit("run");
        }
    }
}

