/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.viewers;

import com.ibm.cics.core.ui.breadcrumb.CICSObjectBreadcrumbNodeAdapter;
import com.ibm.cics.core.ui.breadcrumb.IBreadcrumbNode;
import com.ibm.cics.core.ui.breadcrumb.ManagedRegionNode;
import com.ibm.cics.core.ui.viewers.AbstractTreeContentProvider;
import com.ibm.cics.core.ui.viewers.GroupNode;
import com.ibm.cics.model.ICICSObject;

public class CICSObjectTreeContentProvider
extends AbstractTreeContentProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean groupTypes;

    public CICSObjectTreeContentProvider() {
        this(true);
    }

    public CICSObjectTreeContentProvider(boolean groupTypes) {
        this.groupTypes = groupTypes;
    }

    public void setGroupTypes(boolean groupTypes) {
        this.groupTypes = groupTypes;
        this.clear();
    }

    public Object getParent(Object element) {
        if (element instanceof ICICSObject) {
            ICICSObject cicsObject = (ICICSObject)element;
            IBreadcrumbNode parent = new CICSObjectBreadcrumbNodeAdapter((ICICSObject)element).getParent();
            if (this.groupTypes) {
                return new GroupNode(cicsObject.getObjectType().getResourceTableName(), parent);
            }
            return parent;
        }
        if (element instanceof GroupNode) {
            return ((GroupNode)element).getParent();
        }
        if (element instanceof ManagedRegionNode) {
            return ((ManagedRegionNode)element).getCICSplexNode();
        }
        return null;
    }
}

