/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.views.ElementTypeServiceImpl;
import com.ibm.cics.core.ui.views.IDefaultColumnsProvider;
import com.ibm.cics.core.ui.views.IElementTypeService;
import com.ibm.cics.core.ui.views.ResourcesTable;
import com.ibm.cics.core.ui.views.ResourcesView;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class MultiTypeResourcesView
extends ResourcesView {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final com.ibm.cics.common.util.Debug DEBUG = new com.ibm.cics.common.util.Debug(MultiTypeResourcesView.class);
    private static final String RESOURCE_TYPE_SUFFIX = "_resourceType";
    private final Map<ICICSType<?>, List<ICICSAttribute<?>>> availableTypesAndDefaultColumns;
    private List<IAction> actions = new ArrayList<IAction>();
    private MultiTypeElementTypeService ets;

    private MultiTypeResourcesView(MultiTypeElementTypeService ets, Map<ICICSType<?>, List<ICICSAttribute<?>>> availableTypesAndDefaultColumns) {
        super(ets);
        this.ets = ets;
        this.availableTypesAndDefaultColumns = availableTypesAndDefaultColumns;
    }

    private MultiTypeResourcesView(Map<ICICSType<?>, List<ICICSAttribute<?>>> availableTypesAndDefaultColumns, String partId) {
        this(new MultiTypeElementTypeService(UIPlugin.getDefault().getPreferenceStore(), String.valueOf(partId) + RESOURCE_TYPE_SUFFIX, availableTypesAndDefaultColumns.keySet()), availableTypesAndDefaultColumns);
    }

    public MultiTypeResourcesView(String partId, TypeDefinition typeDefinition, TypeDefinition ... additionalTypes) {
        this(MultiTypeResourcesView.createTypesMap(typeDefinition, additionalTypes), partId);
    }

    protected static Map<ICICSType<?>, List<ICICSAttribute<?>>> createTypesMap(TypeDefinition firstType, TypeDefinition ... additionalTypes) {
        LinkedHashMap map = new LinkedHashMap();
        map.put(firstType.getType(), firstType.getDefaultColumns());
        TypeDefinition[] typeDefinitionArray = additionalTypes;
        int n = additionalTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDefinition typeDefinition = typeDefinitionArray[n2];
            map.put(typeDefinition.getType(), typeDefinition.getDefaultColumns());
            ++n2;
        }
        return map;
    }

    protected static TypeDefinition type(ICICSType<?> type, ICICSAttribute<?> ... defaultColumns) {
        return new TypeDefinition(type, Arrays.asList(defaultColumns));
    }

    @Override
    protected List<ICICSAttribute<?>> getDefaultColumns() {
        ICICSType<?> currentType = this.resourcesTable.getElementTypeService().getElementType();
        List<ICICSAttribute<?>> attributes = this.availableTypesAndDefaultColumns.get(currentType);
        if (attributes == null) {
            throw new RuntimeException(String.valueOf(((Object)((Object)this)).getClass().getName()) + ": No columns found for element type " + currentType);
        }
        return attributes;
    }

    private String getResourceTypePreference() {
        IWorkbenchPartSite site = this.getSite();
        if (site == null) {
            return null;
        }
        return String.valueOf(site.getId()) + RESOURCE_TYPE_SUFFIX;
    }

    void setResourceType(ICICSType<?> type) {
        UIPlugin.getDefault().getPreferenceStore().setValue(this.getResourceTypePreference(), type.getResourceTableName());
        this.ets.setElementType(type);
    }

    Set<ICICSType<?>> getAvailableTypes() {
        return new HashSet(this.availableTypesAndDefaultColumns.keySet());
    }

    @Override
    protected ResourcesTable createResourcesTable(IElementTypeService elementTypeService, IDefaultColumnsProvider defaultColumnsProvider, String connectionCategoryId, boolean multiSelect) {
        return new MultiTypeResourcesTable(elementTypeService, defaultColumnsProvider, connectionCategoryId, multiSelect);
    }

    static class MultiTypeElementTypeService
    extends ElementTypeServiceImpl {
        private static final com.ibm.cics.common.util.Debug DEBUG = new com.ibm.cics.common.util.Debug(MultiTypeElementTypeService.class);

        public MultiTypeElementTypeService(IPreferenceStore store, String preferenceName, Set<ICICSType<?>> candidates) {
            super(MultiTypeElementTypeService.getInitialType(store, preferenceName, candidates));
        }

        public static ICICSType<?> getInitialType(IPreferenceStore store, String preferenceName, Set<ICICSType<?>> candidates) {
            if (preferenceName == null) {
                return candidates.iterator().next();
            }
            String typeName = store.getString(preferenceName);
            if (Debug.DEBUG_PREFERENCES) {
                DEBUG.event("getInitialType", "typeName=" + typeName);
            }
            ICICSType<?> resourceType = null;
            if (typeName != null && !"".equals(typeName)) {
                for (ICICSType<?> type : candidates) {
                    if (!type.getResourceTableName().equals(typeName)) continue;
                    resourceType = type;
                    break;
                }
            }
            if (resourceType == null) {
                store.setToDefault(preferenceName);
                resourceType = candidates.iterator().next();
            }
            return resourceType;
        }
    }

    private final class MultiTypeResourcesTable
    extends ResourcesTable {
        private MultiTypeResourcesTable(IElementTypeService elementTypeService, IDefaultColumnsProvider defaultColumnsProvider, String connectionCategoryId, boolean multiSelect) {
            super(elementTypeService, defaultColumnsProvider, connectionCategoryId, multiSelect);
        }

        @Override
        protected void makeActions() {
            super.makeActions();
            ICICSType<?> currentType = MultiTypeResourcesView.this.resourcesTable.getElementTypeService().getElementType();
            for (ICICSType type : MultiTypeResourcesView.this.availableTypesAndDefaultColumns.keySet()) {
                ResourceSelectionAction action = new ResourceSelectionAction(type);
                if (currentType == type) {
                    action.setChecked(true);
                }
                MultiTypeResourcesView.this.actions.add(action);
            }
        }

        @Override
        protected void fillToolBar(IToolBarManager toolBar) {
            super.fillToolBar(toolBar);
            toolBar.appendToGroup("additions", (IContributionItem)new GroupMarker("resourceNames"));
            for (IAction action : MultiTypeResourcesView.this.actions) {
                toolBar.appendToGroup("resourceNames", action);
            }
        }
    }

    private class ResourceSelectionAction
    extends Action {
        private String resourceName;
        private ICICSType<?> resourceType;

        public ResourceSelectionAction(ICICSType<?> resourceType) {
            super(null, 8);
            this.resourceName = resourceType.getResourceTableName();
            this.resourceType = resourceType;
            this.setImageDescriptor(UIPlugin.getImageDescriptor("icons/" + this.resourceName + ".GIF"));
            this.setToolTipText(Messages.getPluralTableDescription(this.resourceName));
        }

        public ICICSType<?> getResourceType() {
            return this.resourceType;
        }

        public void run() {
            if (this.isChecked()) {
                this.resourceType = this.getResourceType();
                DEBUG.event("run", this.resourceType);
                MultiTypeResourcesView.this.setResourceType(this.resourceType);
            }
        }
    }

    static class TypeDefinition {
        private final ICICSType<?> type;
        private final List<ICICSAttribute<?>> defaultColumns;

        private TypeDefinition(ICICSType<?> type, List<ICICSAttribute<?>> defaultColumns) {
            this.type = type;
            this.defaultColumns = defaultColumns;
        }

        public ICICSType<?> getType() {
            return this.type;
        }

        public List<ICICSAttribute<?>> getDefaultColumns() {
            return this.defaultColumns;
        }
    }
}

