/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.model.CSDListDefinitionType;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.core.model.ResourceDescriptionDefinitionType;
import com.ibm.cics.core.model.ScopedContext;
import com.ibm.cics.core.ui.views.CSDAwareResourcesView;
import com.ibm.cics.core.ui.views.IDefaultColumnsProvider;
import com.ibm.cics.core.ui.views.IElementTypeService;
import com.ibm.cics.core.ui.views.ResourcesTable;
import com.ibm.cics.core.ui.views.SelectionContextProvider;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IScopedContext;
import com.ibm.cics.sm.comm.context.IAssociationContext;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.internal.PluginActionContributionItem;

public class ResourceDescriptionDefinitionsView
extends CSDAwareResourcesView {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String EDITORS_NEW_RESDESC_ACTION = "com.ibm.cics.core.ui.editors.action.new.definition.cpsm.resourceDescriptionDefinition";
    public static final String ID = "com.ibm.cics.sm.ui.views.resourceDescriptionDefinitions";

    public ResourceDescriptionDefinitionsView() {
        super((ICICSType<?>)ResourceDescriptionDefinitionType.getInstance(), (ICICSType<?>)CSDListDefinitionType.getInstance());
    }

    @Override
    protected String getHelpContextId() {
        return "com.ibm.cics.core.ui.view_resourceDescriptionDefinitions";
    }

    @Override
    protected List<ICICSAttribute<?>> getDefaultColumns() {
        if (this.resourcesTable.getElementTypeService().getElementType() == ResourceDescriptionDefinitionType.getInstance()) {
            return Arrays.asList(ResourceDescriptionDefinitionType.NAME, ResourceDescriptionDefinitionType.DESCRIPTION, ResourceDescriptionDefinitionType.CHANGE_TIME, ResourceDescriptionDefinitionType.CHANGE_USER_ID);
        }
        return Arrays.asList(CSDListDefinitionType.NAME, CSDListDefinitionType.CICS_SYSTEM);
    }

    @Override
    protected SelectionContextProvider.IContextProviderAdapter getContextProviderAdapter() {
        final SelectionContextProvider.IContextProviderAdapter delegate = super.getContextProviderAdapter();
        return new SelectionContextProvider.IContextProviderAdapter(){

            @Override
            public IContext getContextFor(Object selectedObject) {
                IContext context = delegate.getContextFor(selectedObject);
                if (context instanceof IAssociationContext) {
                    if (context instanceof IScopedContext) {
                        IScopedContext scopedContext = (IScopedContext)context;
                        return new ScopedContext(scopedContext);
                    }
                    return new Context(context.getContext());
                }
                return context;
            }
        };
    }

    @Override
    protected ResourcesTable createResourcesTable(IElementTypeService elementTypeService, IDefaultColumnsProvider defaultColumnsProvider, String connectionCategoryId, boolean multiSelect) {
        return new ResourceDescriptionDefinitionsTable(elementTypeService, defaultColumnsProvider, connectionCategoryId, multiSelect);
    }

    private final class ResourceDescriptionDefinitionsTable
    extends ResourcesTable {
        private ResourceDescriptionDefinitionsTable(IElementTypeService elementTypeService, IDefaultColumnsProvider defaultColumnsProvider, String connectionCategoryId, boolean multiSelect) {
            super(elementTypeService, defaultColumnsProvider, connectionCategoryId, multiSelect);
        }

        @Override
        protected void menuAboutToUpdate(IMenuManager menuManager) {
            IContributionItem[] items;
            IContributionItem[] iContributionItemArray = items = menuManager.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                String itemId = item.getId();
                if (ResourceDescriptionDefinitionsView.EDITORS_NEW_RESDESC_ACTION.equals(itemId)) {
                    boolean canCreate = ResourceDescriptionDefinitionsView.this.canCreate();
                    if (item instanceof PluginActionContributionItem) {
                        PluginActionContributionItem pitem = (PluginActionContributionItem)item;
                        pitem.getAction().setEnabled(canCreate);
                        item.setVisible(canCreate);
                    }
                }
                ++n2;
            }
            super.menuAboutToUpdate(menuManager);
        }
    }
}

