/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CSDGroupDefinitionType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ResourceGroupDefinitionType;
import com.ibm.cics.core.model.context.IAssociationContextProvider;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.actions.NewDefinitionWizardDropdownAction;
import com.ibm.cics.core.ui.actions.RemoveGroupFromListAction;
import com.ibm.cics.core.ui.views.CSDAwareResourcesView;
import com.ibm.cics.core.ui.views.DefaultSelectionContextAdapter;
import com.ibm.cics.core.ui.views.IDefaultColumnsProvider;
import com.ibm.cics.core.ui.views.IElementTypeService;
import com.ibm.cics.core.ui.views.ResourcesTable;
import com.ibm.cics.core.ui.views.ResourcesView;
import com.ibm.cics.core.ui.views.SelectionContextProvider;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.context.IAssociationContext;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ResourceGroupDefinitionsView
extends CSDAwareResourcesView {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String NEW_RESGROUP_WIZARD_ID = "com.ibm.cics.core.ui.editors.wizard.create.definition.cpsm.resourceGroup";
    static final Debug debug = new Debug(ResourcesView.class);
    public static final String ID = "com.ibm.cics.sm.ui.views.resourceGroupDefinitions";

    public ResourceGroupDefinitionsView() {
        super((ICICSType<?>)ResourceGroupDefinitionType.getInstance(), (ICICSType<?>)CSDGroupDefinitionType.getInstance());
    }

    @Override
    protected List<ICICSAttribute<?>> getDefaultColumns() {
        if (this.resourcesTable.getElementTypeService().getElementType() == ResourceGroupDefinitionType.getInstance()) {
            return Arrays.asList(ResourceGroupDefinitionType.NAME, ResourceGroupDefinitionType.DESCRIPTION, ResourceGroupDefinitionType.CHANGE_TIME, ResourceGroupDefinitionType.CHANGE_USER_ID);
        }
        return Arrays.asList(CSDGroupDefinitionType.NAME, CSDGroupDefinitionType.CICS_SYSTEM);
    }

    @Override
    protected SelectionContextProvider.IContextProviderAdapter getContextProviderAdapter() {
        return new DefaultSelectionContextAdapter(this.resourcesTable.getElementTypeService()){

            @Override
            public IContext getContextFor(Object element) {
                debug.enter("getContextFor", (Object)this, element);
                Object context = null;
                String adapterTypeName = IAssociationContextProvider.class.getName();
                IAssociationContextProvider adapter = (IAssociationContextProvider)Platform.getAdapterManager().loadAdapter(element, adapterTypeName);
                context = adapter != null ? adapter.getContext((ICICSObject)element) : super.getContextFor(element);
                debug.exit("getContextFor", context);
                return context;
            }
        };
    }

    @Override
    protected ResourcesTable createResourcesTable(IElementTypeService elementTypeService, IDefaultColumnsProvider defaultColumnsProvider, String connectionCategoryId, boolean multiSelect) {
        return new ResourceGroupDefinitionsTable(elementTypeService, defaultColumnsProvider, connectionCategoryId, multiSelect);
    }

    @Override
    protected String getHelpContextId() {
        return "com.ibm.cics.core.ui.view_resourceGroupDefinitions";
    }

    private final class ResourceGroupDefinitionsTable
    extends ResourcesTable {
        private ResourceGroupDefinitionsTable(IElementTypeService elementTypeService, IDefaultColumnsProvider defaultColumnsProvider, String connectionCategoryId, boolean multiSelect) {
            super(elementTypeService, defaultColumnsProvider, connectionCategoryId, multiSelect);
        }

        @Override
        protected void menuAboutToShow(IMenuManager aMenuManager) {
            super.menuAboutToShow(aMenuManager);
            NewDefinitionWizardDropdownAction action = ResourceGroupDefinitionsView.this.canCreate() ? new NewDefinitionWizardDropdownAction(ResourceGroupDefinitionsView.NEW_RESGROUP_WIZARD_ID) : new NewDefinitionWizardDropdownAction(null);
            boolean enabled = UIPlugin.getDefault().getConnectionContextManager().canCreateCICSDefinition();
            action.setEnabled(enabled);
            aMenuManager.appendToGroup("new", (IAction)action);
            IStructuredSelection selection = (IStructuredSelection)ResourceGroupDefinitionsView.this.resourcesTable.getTableViewer().getSelection();
            if (ResourceGroupDefinitionsView.this.resourcesTable.getBaseContextProvider().getContext() instanceof IAssociationContext && !selection.isEmpty()) {
                IAssociationContext associationContext = (IAssociationContext)ResourceGroupDefinitionsView.this.resourcesTable.getBaseContextProvider().getContext();
                RemoveGroupFromListAction removeAction = new RemoveGroupFromListAction((ICPSM)ResourceGroupDefinitionsView.this.resourcesTable.getCPSM(), associationContext, selection);
                aMenuManager.appendToGroup("commonActions", (IAction)removeAction);
            }
        }
    }
}

