/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.adapters.ActionFilterAdapterFactory;
import com.ibm.cics.core.ui.properties.AttributePropertyHelper;
import com.ibm.cics.core.ui.properties.ICICSObjectPropertyDescriptor;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import java.util.Set;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class ResourcesLabelProvider
extends ColumnLabelProvider {
    private ICICSObjectPropertyDescriptor descriptor = null;

    public ResourcesLabelProvider(ICICSObjectPropertyDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Image getImage(Object element) {
        if (element != null) {
            ICICSObject object = (ICICSObject)element;
            if (this.descriptor != null) {
                if (this.descriptor.getAttribute().equals(ResourcesLabelProvider.getFirstKeyAttribute(object.getObjectType())) && ActionFilterAdapterFactory.isInstalledByBundle(object)) {
                    return UIPlugin.getImage(UIPlugin.BUNDLE);
                }
                return this.descriptor.getLabelProvider().getImage(ResourcesLabelProvider.getPropertyValue(object, this.descriptor));
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (element != null && element instanceof ICICSObject) {
            ICICSObject object = (ICICSObject)element;
            if (this.descriptor != null) {
                Object value = ResourcesLabelProvider.getPropertyValue(object, this.descriptor);
                ILabelProvider attributeLabelProvider = this.descriptor.getLabelProvider();
                return attributeLabelProvider.getText(value);
            }
        }
        return null;
    }

    private static Object getPropertyValue(ICICSObject object, IPropertyDescriptor descriptor) {
        return AttributePropertyHelper.getPropertyValue(object, (String)descriptor.getId());
    }

    public Color getForeground(Object element) {
        if (!this.isSupported(element)) {
            return UIPlugin.COLOR_UNSUPPORTED_ATTRIBUTE;
        }
        return null;
    }

    public String getToolTipText(Object element) {
        if (element != null && !this.isSupported(element)) {
            return Messages.getString("ResourcesTableViewer.unsupported.tooltip", new Object[0]);
        }
        if (element instanceof ICICSObject && ActionFilterAdapterFactory.isInstalledByBundle((ICICSObject)element)) {
            return Messages.getString("ResourcesLabelProvider.actionsUnavailableBecauseBundleInstalled", new Object[0]);
        }
        return null;
    }

    public boolean useNativeToolTip(Object object) {
        return true;
    }

    private boolean isSupported(Object element) {
        ICICSObject object = (ICICSObject)element;
        Object value = ResourcesLabelProvider.getPropertyValue(object, this.descriptor);
        return this.descriptor.getAttribute().getUnsupportedValue() != value;
    }

    public static ICICSAttribute<?> getFirstKeyAttribute(ICICSType<?> type) {
        Set keyAttributes = type.getKeyAttributes();
        if (keyAttributes != null && !keyAttributes.isEmpty()) {
            return keyAttributes.toArray(new ICICSAttribute[0])[0];
        }
        return null;
    }
}

