/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.comm;

import com.ibm.cics.common.util.IDFactory;
import com.ibm.cics.common.util.StringUtil;

public class CredentialsConfiguration {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2010, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String id;
    private String name;
    private String userid;
    private String password;
    private boolean savePassword;

    public static CredentialsConfiguration createCredentialsConfigurationWithNewId(String name, String userID, String password, boolean savePwd) {
        return new CredentialsConfiguration(IDFactory.createNewId(), name, userID, password, savePwd);
    }

    public CredentialsConfiguration(String id, String name, String userid, String password, boolean savePasswd) {
        this.id = id;
        this.name = name;
        this.userid = userid;
        this.password = password;
        this.savePassword = savePasswd;
    }

    public CredentialsConfiguration(CredentialsConfiguration other) {
        this.id = other.id;
        this.name = other.name;
        this.userid = other.userid;
        this.password = other.password;
        this.savePassword = other.savePassword;
    }

    public String getName() {
        return this.name;
    }

    public String getUserID() {
        return this.userid;
    }

    public String getPassword() {
        return this.password;
    }

    public String getID() {
        return this.id;
    }

    public void setPassword(String newPassword) {
        this.password = newPassword;
    }

    public void setUserID(String newUserID) {
        this.userid = newUserID;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.savePassword ? 1231 : 1237);
        result = 31 * result + (this.userid == null ? 0 : this.userid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CredentialsConfiguration other = (CredentialsConfiguration)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.savePassword != other.savePassword) {
            return false;
        }
        return !(this.userid == null ? other.userid != null : !this.userid.equals(other.userid));
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[id=" + this.id + ", name=" + this.name + ", userid=" + this.userid + ", password-is-empty=" + StringUtil.isEmpty((String)this.password) + ", savePassword=" + this.savePassword + "]";
    }

    public void setID(String anID) {
        this.id = anID;
    }

    public void setName(String credentialsName) {
        this.name = credentialsName;
    }
}

