/* <copyright                                       */
/* notice="cics-lm-source-program"                  */
/* pids="CA0U"                                      */
/* years="2014,2015"                                */
/* crc="2599301157" >                               */
/* 	Licensed Materials - Property of IBM            */
/* 	CA0U                                            */
/* 	(C) Copyright IBM Corp. 2014, 2015 All Rights Reserved. */
/* 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/* </copyright>                                     */
package com.ibm.cics.ucd;


import org.apache.log4j.Priority;
import org.apache.log4j.Logger;

import java.text.MessageFormat;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class JuliToLog4jHandler extends Handler {
	
	// <copyright 
	// notice="cics-lm-java-class" 
	// pids="CA0U" 
	// years="2014,2015" 
	// crc="2599301157" > 
	static final String COPYRIGHT = "Licensed Materials - Property of IBM CA0U (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp."; //$NON-NLS-1$
	// </copyright> 
	static final String WE_ACTIVITY_ID = "WE_ACTIVITY_ID"; //$NON-NLS-1$
	
	static String var_WE_ACTIVITY_ID = System.getenv().get(WE_ACTIVITY_ID);
 
	public JuliToLog4jHandler() {
		setFormatter(new Log4jLoggerFormatter());
	}
	
    public void publish(LogRecord record) {
        org.apache.log4j.Logger log4j = getTargetLogger(record.getLoggerName());
        org.apache.log4j.Level level = convertLevelToLog4j(record.getLevel());
        log4j.log(level, createLog4jMessage(record), record.getThrown());
    }
 
    static Logger getTargetLogger(String loggerName) {
        return Logger.getLogger(loggerName);
    }
 
    public static Logger getTargetLogger(Class<?> clazz) {
        return getTargetLogger(clazz.getName());
    }
     
    private String createLog4jMessage(LogRecord record) {
    	return var_WE_ACTIVITY_ID + " " + getFormatter().format(record);
    }
 
    private org.apache.log4j.Level convertLevelToLog4j(Level level) {
        if (Level.SEVERE == level) {
            return org.apache.log4j.Level.ERROR;
        } else if (Level.WARNING == level) {
            return org.apache.log4j.Level.WARN;
        } else if (Level.INFO == level) {
            return org.apache.log4j.Level.INFO;
        } else if (Level.CONFIG == level) {
            return org.apache.log4j.Level.DEBUG;
        } else if (Level.FINE == level) {
            return org.apache.log4j.Level.DEBUG;
        } else if (Level.FINER == level) {
            return org.apache.log4j.Level.TRACE;
        } else if (Level.FINEST == level) {
            return org.apache.log4j.Level.TRACE;
        } else if (Level.OFF == level) {
            return org.apache.log4j.Level.OFF;
        } else if (Level.ALL == level) {
            return org.apache.log4j.Level.ALL;
        }
        return org.apache.log4j.Level.OFF;
    }
 
    @Override
    public void flush() {}
 
    @Override
    public void close() {}
}
