/* <copyright                                       */
/* notice="cics-lm-source-program"                  */
/* pids="CA0U"                                      */
/* years="2014,2015"                                */
/* crc="3514276934" >                               */
/* 	Licensed Materials - Property of IBM            */
/* 	CA0U                                            */
/* 	(C) Copyright IBM Corp. 2014, 2015 All Rights Reserved. */
/* 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/* </copyright>                                     */
package com.ibm.cics.ucd.steps

import com.ibm.cics.core.model.CICSCore
import com.ibm.cics.core.model.CICSSystemManagerException
import com.ibm.cics.core.model.FilteredContext
import com.ibm.cics.core.model.GenTypeClasses
import com.ibm.cics.core.model.ICPSM
import com.ibm.cics.core.model.LocalFileType
import com.ibm.cics.core.model.DataTableType
import com.ibm.cics.core.model.DB2EntryType
import com.ibm.cics.model.ICICSAttribute
import com.ibm.cics.model.ICICSObject
import com.ibm.cics.model.ICICSType
import com.ibm.cics.sm.comm.ICICSAction
import com.ibm.cics.sm.comm.IContext
import com.ibm.cics.sm.comm.SystemManagerActions
import com.ibm.cics.ucd.CPSMHelper
import com.ibm.cics.ucd.properties.IntegerProperty
import com.ibm.cics.ucd.properties.ResourceNameListProperty
import com.ibm.cics.ucd.properties.ResourceNameListPropertySupportWildCard
import com.urbancode.air.AirPluginTool
import com.ibm.cics.ucd.exceptions.StepFailedException
import com.ibm.cics.ucd.msg.CICSUCDMessage
import com.ibm.cics.ucd.steplabel.CICSUCDStepLabel

import java.text.MessageFormat
import java.util.Properties

import com.ibm.cics.core.model.CICSObjectPrimaryKey

class DisableResourceStep extends AbstractPerformActionStep {
	// <copyright 
	// notice="cics-lm-java-class" 
	// pids="CA0U" 
	// years="2014,2015" 
	// crc="3514276934" > 
	static final String COPYRIGHT = "Licensed Materials - Property of IBM CA0U (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp."; //$NON-NLS-1$
	// </copyright> 
	
	public static final noWaitDisableType = [LocalFileType.getInstance().getResourceTableName(), DB2EntryType.getInstance().getResourceTableName(),
		DataTableType.getInstance().getResourceTableName()]
	
	public DisableResourceStep(String inputPropertyFile, String outputPropertyFile) {
		this(inputPropertyFile, outputPropertyFile, CICSCore.getCPSM())
	}

	public DisableResourceStep(AirPluginTool apTool) {
		this(apTool, CICSCore.getCPSM())
	}

	/**
	 * Primarily to support unit testing
	 */
	DisableResourceStep(String inputPropertyFile, String outputPropertyFile, ICPSM cpsm) {
		super(inputPropertyFile, outputPropertyFile)
		this.cpsm = cpsm
	}

	DisableResourceStep(AirPluginTool apTool, ICPSM cpsm) {
		super(apTool)
		this.cpsm = cpsm
	}
	
	@Override
	protected ICICSAction getCicsAction(Properties props) {
		//For 'File' 'Data Table' and 'DB2Entry' resource, the Disable action is set NoWait as default
		if (noWaitDisableType.contains(props[RESOURCE_TYPE])){
			return SystemManagerActions.DisableNoWait
		}	
		return SystemManagerActions.Disable
	}


}
