/* <copyright                                       */
/* notice="cics-lm-source-program"                  */
/* pids="CA0U"                                      */
/* years="2014,2015"                                */
/* crc="4158950393" >                               */
/* 	Licensed Materials - Property of IBM            */
/* 	CA0U                                            */
/* 	(C) Copyright IBM Corp. 2014, 2015 All Rights Reserved. */
/* 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/* </copyright>                                     */
package com.ibm.cics.ucd.steps

import com.ibm.cics.core.model.CICSSystemManagerException
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.CICSCore;
import com.ibm.cics.core.model.FilteredContext
import com.ibm.cics.core.model.GenTypeClasses
import com.ibm.cics.model.ICICSObject
import com.ibm.cics.model.ICICSType
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.ucd.CPSMHelper
import com.ibm.cics.ucd.exceptions.StepFailedException
import com.ibm.cics.ucd.properties.ResourceNameListProperty
import com.ibm.cics.ucd.steplabel.CICSUCDStepLabel
import com.ibm.cics.ucd.msg.CICSUCDMessage
import com.urbancode.air.AirPluginTool;

import java.text.MessageFormat

class InstallResourceGroupFromDREPStep extends AbstractInstallResourceDescOrGroupFromDREPStep {
	// <copyright 
	// notice="cics-lm-java-class" 
	// pids="CA0U" 
	// years="2014,2015" 
	// crc="4158950393" > 
	static final String COPYRIGHT = "Licensed Materials - Property of IBM CA0U (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp."; //$NON-NLS-1$
	// </copyright> 
	
	public InstallResourceGroupFromDREPStep(String inputPropertyFile, String outputPropertyFile) {
		this(inputPropertyFile, outputPropertyFile, CICSCore.getCPSM());
	}

	public InstallResourceGroupFromDREPStep(AirPluginTool apTool) {
		this(apTool, CICSCore.getCPSM());
	}
	
	/**
	 * Primarily to support unit testing
	 * @param cpsm
	 */
	InstallResourceGroupFromDREPStep(String inputPropertyFile, String outputPropertyFile, ICPSM cpsm) {
		super(inputPropertyFile, outputPropertyFile)
		this.cpsm = cpsm
		this.resourceType = "RESGROUP";
		this.propertyName = "resourceGroupNameList";
	}

	InstallResourceGroupFromDREPStep(AirPluginTool apTool, ICPSM cpsm) {
		super(apTool)
		this.cpsm = cpsm
		this.resourceType = "RESGROUP";
		this.propertyName = "resourceGroupNameList";
	}


	@Override
	protected boolean performInstall(CPSMHelper cpsmHelper, ICPSM cpsm, ICICSType<? extends ICICSObject> type, IContext context, String itemToInstall) {
		return cpsmHelper.installDREPResourceGroup(cpsm, type, context, itemToInstall);
	}

}
