/* <copyright                                       */
/* notice="cics-lm-source-program"                  */
/* pids="CA0U"                                      */
/* years="2014,2015"                                */
/* crc="1962844266" >                               */
/* 	Licensed Materials - Property of IBM            */
/* 	CA0U                                            */
/* 	(C) Copyright IBM Corp. 2014, 2015 All Rights Reserved. */
/* 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/* </copyright>                                     */
package com.ibm.cics.ucd.steps

import com.ibm.cics.core.model.CICSCore;
import com.ibm.cics.core.model.CICSSystemManagerException
import com.ibm.cics.core.model.FilteredContext
import com.ibm.cics.core.model.GenTypeClasses
import com.ibm.cics.core.model.ICPSM
import com.ibm.cics.core.model.ProgramType
import com.ibm.cics.model.ICICSObject
import com.ibm.cics.model.ICICSType
import com.ibm.cics.sm.comm.ICICSAction;
import com.ibm.cics.sm.comm.IContext
import com.ibm.cics.sm.comm.SystemManagerActions
import com.ibm.cics.ucd.CPSMHelper
import com.ibm.cics.ucd.properties.IntegerProperty
import com.ibm.cics.ucd.properties.ResourceNameListPropertySupportWildCard
import com.ibm.cics.ucd.steplabel.CICSUCDStepLabel
import com.urbancode.air.AirPluginTool;
import com.ibm.cics.ucd.exceptions.StepFailedException
import com.ibm.cics.ucd.msg.CICSUCDMessage

import java.text.MessageFormat
import java.util.List;
import java.util.Properties;

class NewcopyProgramStep extends AbstractPerformActionStep {
	// <copyright 
	// notice="cics-lm-java-class" 
	// pids="CA0U" 
	// years="2014,2015" 
	// crc="1962844266" > 
	static final String COPYRIGHT = "Licensed Materials - Property of IBM CA0U (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp."; //$NON-NLS-1$
	// </copyright> 

	public NewcopyProgramStep(String inputPropertyFile, String outputPropertyFile) {
		this(inputPropertyFile, outputPropertyFile, CICSCore.getCPSM())
	}

	public NewcopyProgramStep(AirPluginTool apTool) {
		this(apTool, CICSCore.getCPSM())
	}

	/**
	 * Primarily to support unit testing
	 * @param cpsm
	 */
	NewcopyProgramStep(String inputPropertyFile, String outputPropertyFile, ICPSM cpsm) {
		super(inputPropertyFile, outputPropertyFile)
		this.cpsm = cpsm
	}

	NewcopyProgramStep(AirPluginTool apTool, ICPSM cpsm) {
		super(apTool)
		this.cpsm = cpsm
	}

	@Override
	protected void runCICSStep(ICPSM cpsm, IContext context) {

		def cpsmHelper = new CPSMHelper()

		def props = apTool.getStepProperties()
		def resourceType = getResourceType(props)
		def maxRetryTimes = new IntegerProperty("Max Retry Times", true).parse(props['maxRetryTimes']).getValue()
		def retryInterval = new IntegerProperty("Retry Interval", true).parse(props['retryInterval']).getValue()
		def resourceNameList = getResourceNameList(cpsmHelper, props, resourceType)
		cicsAction = getCicsAction(props)
		
		Class<? extends ICICSType<ICICSObject>> typeClass = GenTypeClasses.getCICSTypeClassForResourceTableName(resourceType)
		ICICSType<?> type = typeClass.invokeMethod("getInstance", null)

		//For step execution status use
		boolean stepFail = false
		int successCount = 0
		int failCount = 0

		log(MessageFormat.format(CICSUCDMessage.PERFORM, cicsAction.getActionName()))

		//Iterate to discard each resource
		for(int i=0; i < resourceNameList.size(); i++) {
			//Set a filter for the context
			FilteredContext filteredContext = new FilteredContext(context)
			filteredContext.setAttributeValue(type.NAME, resourceNameList.get(i))

			//Perform action on the resource
			boolean performSuccess = cpsmHelper.performActionWithRetry(cpsm, type, filteredContext, cicsAction, resourceNameList.get(i), maxRetryTimes, retryInterval)
			if(performSuccess) {
				successCount++
			} else {
				failCount++
				stepFail = true
			}
		}

		log(MessageFormat.format(CICSUCDMessage.resultSummary, cicsAction.getActionName(), Integer.toString(successCount), Integer.toString(failCount)))

		if (stepFail) {
			throw new StepFailedException("Step failed.");
		}
	}
	
	@Override
	protected ICICSAction getCicsAction(Properties props) {
		return SystemManagerActions.NewCopy;
	}
	@Override
	protected List<String> getResourceNameList(CPSMHelper cpsmHelper, Properties props, String resourceType) {
		return new ResourceNameListPropertySupportWildCard(CICSUCDStepLabel.RESOURCE_NAME_LIST, resourceType, cpsmHelper.isNameCaseSensitive(resourceType), true).parse(props['resourceNameList']).getValue()
		
	}

}
