/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.internal.InternalConnectionsPlugin;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.eclipse.common.Activator;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AcceptCertificateDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2008, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(AcceptCertificateDialog.class);
    private X509Certificate[] chain;
    private String alias;
    private String host;

    private String getAlias() {
        return this.alias;
    }

    private AcceptCertificateDialog(Shell parentShell, X509Certificate[] chain, String name, String host) {
        super(parentShell);
        this.alias = name;
        this.host = host;
        this.setBlockOnOpen(true);
        this.chain = chain;
        this.setTitleImage(ConnectionsImages.getImage("CERTIFICATE_IMPORT_WIZ_BAN"));
        this.create();
        this.setTitle(Messages.AcceptCertificateDialog_title);
        this.setMessage(Messages.AcceptCertificateDialog_message);
    }

    protected Control createDialogArea(Composite parent) {
        debug.enter("createDialogArea");
        String supplemental = this.getEmphasise();
        this.getShell().setText(Messages.AcceptCertificateDialog_shell_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.explorer.connection_accept_certificate_dialog");
        Control composite = super.createDialogArea(parent);
        if (StringUtil.hasContent((String)supplemental)) {
            Composite top = new Composite((Composite)composite, 0);
            GridLayout topLayout = new GridLayout(2, false);
            topLayout.marginWidth = 15;
            topLayout.marginHeight = 5;
            top.setLayout((Layout)topLayout);
            Label supMsg = new Label(top, 0);
            supMsg.setImage(Activator.getImage((String)"IMG_WARNING"));
            supMsg = new Label(top, 0);
            supMsg.setText(supplemental);
            supMsg.setForeground(Display.getDefault().getSystemColor(3));
        }
        Composite upperArea = new Composite((Composite)composite, 0);
        GridLayout upperLayout = new GridLayout();
        upperLayout.marginWidth = 5;
        upperLayout.marginHeight = 5;
        upperArea.setLayout((Layout)upperLayout);
        upperArea.setLayoutData((Object)new GridData(768));
        Group uppergroup = new Group(upperArea, 0);
        GridLayout uppergroupLayout = new GridLayout();
        uppergroupLayout.marginWidth = 5;
        uppergroupLayout.marginHeight = 5;
        uppergroup.setLayout((Layout)uppergroupLayout);
        uppergroup.setLayoutData((Object)new GridData(768));
        uppergroup.setText(Messages.AcceptCertificateDialog_detail);
        if (this.chain != null) {
            new Label((Composite)uppergroup, 0).setText(MessageFormat.format(Messages.AcceptCertificateDialog_subject, this.chain[0].getSubjectX500Principal().toString()));
            new Label((Composite)uppergroup, 0).setText(MessageFormat.format(Messages.AcceptCertificateDialog_issuer, this.chain[0].getIssuerX500Principal().toString()));
            new Label((Composite)uppergroup, 0).setText(MessageFormat.format(Messages.AcceptCertificateDialog_cert, this.chain[0].getType()));
            new Label((Composite)uppergroup, 0).setText(MessageFormat.format(Messages.AcceptCertificateDialog_signature, this.chain[0].getSigAlgName()));
            new Label((Composite)uppergroup, 0).setText(MessageFormat.format(Messages.AcceptCertificateDialog_valid, DateFormat.getInstance().format(this.chain[0].getNotBefore()), DateFormat.getInstance().format(this.chain[0].getNotAfter())));
            Composite lowerArea = new Composite((Composite)composite, 0);
            Group lowergroup = new Group(lowerArea, 0);
            lowergroup.setText(Messages.AcceptCertificateDialog_alias);
            GridLayout lowerLayout = new GridLayout(1, false);
            GridLayout lowerGroupLayout = new GridLayout(2, false);
            lowerLayout.marginWidth = 5;
            lowerLayout.marginHeight = 5;
            lowerArea.setLayout((Layout)lowerLayout);
            lowerArea.setLayoutData((Object)new GridData(768));
            lowergroup.setLayout((Layout)lowerGroupLayout);
            lowergroup.setLayoutData((Object)new GridData(768));
            Label spanning = new Label((Composite)lowergroup, 0);
            spanning.setText(Messages.AcceptCertificateDialog_alias_desc);
            GridData data = new GridData();
            data.horizontalSpan = 2;
            spanning.setLayoutData((Object)data);
            Label l = new Label((Composite)lowergroup, 0);
            l.setText(Messages.AcceptCertificateDialog_alias_label);
            final Text alias = new Text((Composite)lowergroup, 2048);
            TextInput.setAccessibleLabel((Text)alias, (Label)l);
            GridData aliasLayoutData = new GridData();
            aliasLayoutData.widthHint = 180;
            alias.setLayoutData((Object)aliasLayoutData);
            alias.setText(this.alias);
            alias.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AcceptCertificateDialog.this.alias = alias.getText();
                }
            });
        } else {
            new Label(upperArea, 0).setText(Messages.AcceptCertificateDialog_cant_manage);
            new Label(upperArea, 0).setText(Messages.AcceptCertificateDialog_pref_page);
        }
        debug.exit("createDialogArea");
        return composite;
    }

    private String getEmphasise() {
        debug.enter("getEmphasise");
        String message = "";
        if (this.host != null) {
            Object common_name = null;
            try {
                List<Rdn> rdnList = new LdapName(this.chain[0].getSubjectX500Principal().getName()).getRdns();
                for (Rdn rdn : rdnList) {
                    if (!rdn.getType().equalsIgnoreCase("cn")) continue;
                    common_name = rdn.getValue();
                }
            }
            catch (InvalidNameException e) {
                debug.error("createDialogArea", (Throwable)e);
            }
            if (!this.host.equals(common_name)) {
                message = MessageFormat.format(Messages.AcceptCertificateDialog_unexpected, this.host, common_name.toString());
            }
        }
        debug.exit("getEmphasise", (Object)message);
        return message;
    }

    public static boolean acceptCertificate(final X509Certificate[] chain, final String alias, final String host) {
        if (AcceptCertificateDialog.allowCertificateImport()) {
            final boolean[] rc = new boolean[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    if (chain.length > 0) {
                        String alias2;
                        AcceptCertificateDialog certDialog = new AcceptCertificateDialog(shell, chain, alias, host, null);
                        rc[0] = certDialog.open() == 0;
                        String string = alias2 = certDialog.getAlias() != null ? certDialog.getAlias() : chain[0].getSubjectX500Principal().toString();
                        if (rc[0]) {
                            AcceptCertificateDialog.importCertificates(chain, alias2);
                        }
                    } else {
                        debug.error("showTrustCertificateDialog", "Potential SSL certificate error. Empty chain");
                    }
                }
            });
            return rc[0];
        }
        return false;
    }

    public static boolean importCertificates(X509Certificate[] chain, String alias) {
        debug.enter("importCertificates");
        boolean result = false;
        String fileString = AcceptCertificateDialog.getCurrentTrustStore();
        String dbType = Platform.getPreferencesService().getString("com.ibm.cics.core.comm", "com.ibm.cics.core.comm.truststore.dbType", "", null);
        try {
            File f;
            KeyStore ks = KeyStore.getInstance(dbType);
            ks.load(new FileInputStream(fileString), AcceptCertificateDialog.getCurrentTrustStorePassphrase().toCharArray());
            TrustManagerFactory defaultTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            defaultTrustManagerFactory.init(ks);
            if (ks.getCertificateAlias(chain[0]) == null) {
                ks.setCertificateEntry(alias, chain[0]);
            }
            if (!(f = new File(fileString)).canWrite()) {
                f.setWritable(true);
                ks.store(new FileOutputStream(fileString), AcceptCertificateDialog.getCurrentTrustStorePassphrase().toCharArray());
                f.setWritable(false);
            } else {
                ks.store(new FileOutputStream(fileString), AcceptCertificateDialog.getCurrentTrustStorePassphrase().toCharArray());
            }
            result = true;
        }
        catch (NoSuchAlgorithmException e) {
            debug.error("importCertificates", (Throwable)e);
        }
        catch (CertificateException e) {
            debug.error("importCertificates", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            debug.error("importCertificates", (Throwable)e);
        }
        catch (IOException e) {
            debug.error("importCertificates", (Throwable)e);
        }
        catch (KeyStoreException e) {
            debug.error("importCertificates", (Throwable)e);
        }
        debug.exit("importCertificates", (Object)result);
        return result;
    }

    static String getCurrentTrustStore() {
        return Platform.getPreferencesService().getString("com.ibm.cics.core.comm", "javax.net.ssl.trustStore", "", null);
    }

    public static String getCurrentTrustStorePassphrase() {
        return InternalConnectionsPlugin.getDefault().getPassphraseManager().getTrustStorePassphrase();
    }

    public static String getCurrentKeyStore() {
        return Platform.getPreferencesService().getString("com.ibm.cics.core.comm", "javax.net.ssl.keyStore", "", null);
    }

    public static String getCurrentKeyStorePassphrase() {
        return InternalConnectionsPlugin.getDefault().getPassphraseManager().getKeyStorePassphrase();
    }

    public static boolean allowCertificateImport() {
        return !Platform.getPreferencesService().getBoolean("com.ibm.cics.core.comm", "com.ibm.cics.core.comm.restrictCertificateImport", false, null);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button ok = this.getButton(0);
        ok.setText(Messages.AcceptCertificateDialog_accept_label);
        this.setButtonLayoutData(ok);
        Button cancel = this.getButton(1);
        cancel.setText(Messages.AcceptCertificateDialog_decline_label);
        this.setButtonLayoutData(cancel);
    }

    /* synthetic */ AcceptCertificateDialog(Shell shell, X509Certificate[] x509CertificateArray, String string, String string2, AcceptCertificateDialog acceptCertificateDialog) {
        this(shell, x509CertificateArray, string, string2);
    }
}

