/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.comm.IConnectionCategory;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart3;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.services.ISourceProviderService;

public class ConnectionTrimWidgetCategorySource
extends AbstractSourceProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2013, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String RDZ_EST_PERSPECTIVE_ID = "com.ibm.etools.est.ui.perspective.EstPerspective";
    public static final String TRIM_CONNECTION_CATEGORY = "com.ibm.cics.core.connections.trimConnectionCategory";
    private static Map<String, IConfigurationElement> definedPerspectives;
    private static Map<String, String> perspectiveIDsShowingExplorerTrim;
    private Object activeConnectionCategory;
    private IPartListener2 partListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
            ConnectionTrimWidgetCategorySource.this.updateActiveCategory();
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            ConnectionTrimWidgetCategorySource.this.updateActiveCategory();
        }
    };
    private IPerspectiveListener perspectiveListener = new IPerspectiveListener(){

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            ConnectionTrimWidgetCategorySource.this.updateActiveCategory();
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        }
    };

    public ConnectionTrimWidgetCategorySource() {
        WorkbenchJob job = new WorkbenchJob("initialise source"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener(ConnectionTrimWidgetCategorySource.this.partListener);
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener(ConnectionTrimWidgetCategorySource.this.perspectiveListener);
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionTrimWidgetCategorySource.this.updateActiveCategory();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void dispose() {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null) {
            activeWindow.getPartService().removePartListener(this.partListener);
            activeWindow.removePerspectiveListener(this.perspectiveListener);
        }
    }

    private void updateActiveCategory() {
        Object newActiveConnectionCategory = ConnectionTrimWidgetCategorySource.calculateActiveCategory();
        if (this.categoryHasChanged(newActiveConnectionCategory)) {
            this.activeConnectionCategory = newActiveConnectionCategory;
            this.fireSourceChanged(0, TRIM_CONNECTION_CATEGORY, newActiveConnectionCategory);
        }
    }

    private boolean categoryHasChanged(Object newActiveConnectionCategory) {
        return newActiveConnectionCategory == null ? this.activeConnectionCategory != null : !newActiveConnectionCategory.equals(this.activeConnectionCategory);
    }

    public String[] getProvidedSourceNames() {
        return new String[]{TRIM_CONNECTION_CATEGORY};
    }

    public Map getCurrentState() {
        HashMap<String, Object> currentState = new HashMap<String, Object>(1);
        currentState.put(TRIM_CONNECTION_CATEGORY, this.activeConnectionCategory);
        return currentState;
    }

    public static String getActiveConnectionCategory() {
        ISourceProviderService sourceProviderService = (ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class);
        ISourceProvider sourceProvider = sourceProviderService.getSourceProvider(TRIM_CONNECTION_CATEGORY);
        return (String)sourceProvider.getCurrentState().get(TRIM_CONNECTION_CATEGORY);
    }

    private static Object calculateActiveCategory() {
        String connectionCategoryForPerspective;
        String connectionCategoryForView;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof IWorkbenchPart3 && (connectionCategoryForView = ((IWorkbenchPart3)activePart).getPartProperty(IConnectionCategory.class.getName())) != null) {
            return connectionCategoryForView;
        }
        IPerspectiveDescriptor aPerspective = page.getPerspective();
        if (aPerspective != null && (connectionCategoryForPerspective = ConnectionTrimWidgetCategorySource.getConnectionCategoryForPerspective(aPerspective)) != null) {
            return connectionCategoryForPerspective;
        }
        return new Object();
    }

    private static Map<String, String> getPerspectivesShowingExplorerTrim() {
        if (perspectiveIDsShowingExplorerTrim == null) {
            perspectiveIDsShowingExplorerTrim = new HashMap<String, String>();
            perspectiveIDsShowingExplorerTrim.put(RDZ_EST_PERSPECTIVE_ID, "com.ibm.cics.sm.connection");
            Map<String, IConfigurationElement> definedPerspectives = ConnectionTrimWidgetCategorySource.getDefinedPerspectives();
            for (IConfigurationElement configurationElement : definedPerspectives.values()) {
                String connectionCategory = configurationElement.getAttribute("cicsExplorerConnectionCategory");
                if (connectionCategory == null) continue;
                perspectiveIDsShowingExplorerTrim.put(configurationElement.getAttribute("id"), connectionCategory);
            }
        }
        return perspectiveIDsShowingExplorerTrim;
    }

    private static Map<String, IConfigurationElement> getDefinedPerspectives() {
        if (definedPerspectives == null) {
            IConfigurationElement[] perspectiveConfigurations;
            definedPerspectives = new HashMap<String, IConfigurationElement>();
            IConfigurationElement[] iConfigurationElementArray = perspectiveConfigurations = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.perspectives");
            int n = perspectiveConfigurations.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                String perspectiveId = configurationElement.getAttribute("id");
                definedPerspectives.put(perspectiveId, configurationElement);
                ++n2;
            }
        }
        return definedPerspectives;
    }

    private static String getConnectionCategoryForPerspective(IPerspectiveDescriptor aPerspectiveDescriptor) {
        block3: {
            PerspectiveDescriptor perspectiveDescriptor;
            String originalId;
            block2: {
                if (!ConnectionTrimWidgetCategorySource.getDefinedPerspectives().keySet().contains(aPerspectiveDescriptor.getId())) break block2;
                for (Map.Entry<String, String> perspectiveID : ConnectionTrimWidgetCategorySource.getPerspectivesShowingExplorerTrim().entrySet()) {
                    if (!aPerspectiveDescriptor.getId().equals(perspectiveID.getKey())) continue;
                    return perspectiveID.getValue();
                }
                break block3;
            }
            if (!(aPerspectiveDescriptor instanceof PerspectiveDescriptor) || (originalId = (perspectiveDescriptor = (PerspectiveDescriptor)aPerspectiveDescriptor).getOriginalId()) == aPerspectiveDescriptor.getId()) break block3;
            for (Map.Entry<String, String> perspectiveID : ConnectionTrimWidgetCategorySource.getPerspectivesShowingExplorerTrim().entrySet()) {
                if (!originalId.equals(perspectiveID.getKey())) continue;
                return perspectiveID.getValue();
            }
        }
        return null;
    }
}

