/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.common.CICSRelease;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.AuthenticationException;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.model.IRepository;
import com.ibm.cics.sm.comm.AbstractCICSAction;
import com.ibm.cics.sm.comm.AbstractFilteredContext;
import com.ibm.cics.sm.comm.AbstractSystemManagerConnection;
import com.ibm.cics.sm.comm.ContextHelper;
import com.ibm.cics.sm.comm.ErrorCodes;
import com.ibm.cics.sm.comm.ICICSAction;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IComplexFilteredContext;
import com.ibm.cics.sm.comm.ICompoundFilteredContext;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IDefinitionContext;
import com.ibm.cics.sm.comm.IFilteredContext;
import com.ibm.cics.sm.comm.IMutableSMConnectionRecord;
import com.ibm.cics.sm.comm.IOrderedContext;
import com.ibm.cics.sm.comm.IParameterisedContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.IResourceTables;
import com.ibm.cics.sm.comm.IScopedContext;
import com.ibm.cics.sm.comm.ISystemManagerConnection;
import com.ibm.cics.sm.comm.ISystemManagerConnection2;
import com.ibm.cics.sm.comm.ISystemManagerResponseValues;
import com.ibm.cics.sm.comm.InstallException;
import com.ibm.cics.sm.comm.InvalidFilterException;
import com.ibm.cics.sm.comm.RepositoryDiscoverer;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import com.ibm.cics.sm.comm.SMConnectionResponse;
import com.ibm.cics.sm.comm.SortOrder;
import com.ibm.cics.sm.comm.SystemManagerActions;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import com.ibm.cics.sm.comm.TypeNotFoundException;
import com.ibm.cics.sm.comm.actions.InstallAction;
import com.ibm.cics.sm.comm.context.IAssociationContext;
import com.ibm.cics.sm.comm.context.IGroupContext;
import com.ibm.cics.sm.comm.context.ISystemParameterContext;
import com.ibm.cics.sm.comm.context.IWorkloadContext;
import com.ibm.cics.sm.comm.sm.DebugOptions;
import com.ibm.cics.sm.comm.sm.IModelNames;
import com.ibm.cics.sm.comm.sm.SMConnectionCreateException;
import com.ibm.cics.sm.comm.sm.SMConnectionException;
import com.ibm.cics.sm.comm.sm.SMResponse;
import com.ibm.cics.sm.comm.sm.internal.ComplexFilterOperatorRule;
import com.ibm.cics.sm.comm.sm.internal.DebugInputStream;
import com.ibm.cics.sm.comm.sm.internal.GetCapableRule;
import com.ibm.cics.sm.comm.sm.internal.IOperationRule;
import com.ibm.cics.sm.comm.sm.internal.Messages;
import com.ibm.cics.sm.comm.sm.internal.OrderedGetRule;
import com.ibm.cics.sm.comm.sm.internal.ResourceAvailableRule;
import com.ibm.cics.sm.comm.sm.internal.SMResponseHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SMCPSMConnection
extends AbstractSystemManagerConnection
implements ISystemManagerConnection2,
IModelNames,
IResourceTables,
ISystemManagerResponseValues {
    private static final String CRITERIA_AND = "%20AND%20";
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String USER_AGENT_PROPERTY = "User-Agent";
    private static final String USER_AGENT;
    private static final String CMAS_ATTRIBUTE_SYSID = "SYSID";
    private static final String CMAS_ATTRIBUTE_CPSMVER = "CPSMVER";
    public static final String FILE = "/CICSSystemManagement/";
    public static final String DATA_ENCODING_CHARSET = "UTF-8";
    public static final String URLENCODING_CHARSET = "UTF-8";
    public static final String PROPERTY_DEFAULTWARNCNT = "com.ibm.cics.sm.comm.DEFAULTWARNINGCOUNT";
    public static final String DEFAULT_WARNINGCOUNT = "700";
    private static final String CICS_RESOURCE_SCHEMA_PATTERN_TEMPLATE = "http://[^/]*/CICSSystemManagement/schema/(CICS[A-Za-z0-9]+)\\.xsd";
    private static final String CICS_SECURE_RESOURCE_SCHEMA_PATTERN_TEMPLATE = "https://[^/]*/CICSSystemManagement/schema/(CICS[A-Za-z0-9]+)\\.xsd";
    private static final String SCHEMA_LOCATION = "schemaLocation";
    private static final String XSD_INCLUDE = "xsd:include";
    boolean connected;
    protected Map<String, SMConnectionResponse> stubs;
    private String cmasName;
    private String version;
    protected int readTimeout = 120000;
    private static final Debug debug;
    private static final String PARAM_ORDERBY = "ORDERBY";
    private final List<String> supportedResources = new ArrayList<String>(0);
    private String lastUrl;
    private final ComplexFilterOperatorRule complexFilterOperatorRule = new ComplexFilterOperatorRule();

    static {
        debug = new Debug(SMCPSMConnection.class);
        String version = System.getProperty("com.ibm.cics.sm.comm.sm.version", "Unknown");
        String osName = System.getProperty("os.name");
        USER_AGENT = "IBM_CICS_Explorer/" + version + " (" + osName + ")";
    }

    public SMCPSMConnection() {
        super(true);
        debug.event("<init>", (Object)this);
        this.stubs = new HashMap<String, SMConnectionResponse>();
    }

    public void setConfiguration(ConnectionConfiguration connectionConfiguration) {
        super.setConfiguration(connectionConfiguration);
        if (connectionConfiguration != null) {
            String readTimeoutStr = connectionConfiguration.getExtendedAttribute("READ_TIMEOUT");
            try {
                this.readTimeout = Integer.parseInt(readTimeoutStr);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        debug.event("setConfiguration", (Object)this, (Object)connectionConfiguration);
    }

    protected HttpURLConnection openConnection(URL url) throws IOException {
        HttpURLConnection connection = super.openConnection(url);
        connection.setReadTimeout(this.readTimeout);
        connection.setConnectTimeout(this.readTimeout);
        return connection;
    }

    public String getActions(String resourceType, IContext context) {
        debug.enter("getActions", (Object)this, (Object)resourceType, (Object)context);
        String actions = String.valueOf(super.getActions(resourceType, context)) + "," + "update";
        if (IResourceTables.Helper.isCICSDefinition((String)resourceType) || IResourceTables.Helper.isCICSResource((String)resourceType)) {
            actions = String.valueOf(actions) + ",delete,perform";
        }
        if (IResourceTables.Helper.isCPSMManager((String)resourceType)) {
            actions = String.valueOf(actions) + ",delete,perform";
        } else if (IResourceTables.Helper.isCPSMDefinition((String)resourceType)) {
            actions = String.valueOf(actions) + ",create,install,delete";
        } else if (resourceType.equals("CSDGROUP") || resourceType.equals("CSDLIST")) {
            actions = String.valueOf(actions) + ",install,perform";
        }
        if (resourceType.equals("CSDGROUP")) {
            actions = String.valueOf(actions) + ",delete";
        }
        if (IResourceTables.Helper.isCICSDefinition((String)resourceType)) {
            actions = String.valueOf(actions) + ",create,remove,install";
        }
        if (resourceType.equalsIgnoreCase("MAS")) {
            actions = String.valueOf(actions) + ",EventProcessing";
        }
        if (resourceType.equals("CSDGROUP") || resourceType.equals("RESGROUP")) {
            actions = String.valueOf(actions) + ",remove,perform";
        }
        if (resourceType.equals("CPLEXDEF")) {
            actions = String.valueOf(actions) + ",delete,create";
        }
        if (resourceType.equals("CMTCMDEF")) {
            actions = String.valueOf(actions) + ",delete,create";
        }
        if (resourceType.equals("CSYSDEF") || resourceType.equals("CSYSGRP")) {
            actions = String.valueOf(actions) + ",perform";
        }
        debug.exit("getActions", (Object)actions);
        return actions;
    }

    protected boolean checkRules(String resourceType, IContext context, ICICSOperation operation, IOperationRule ... rules) {
        IOperationRule[] iOperationRuleArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            IOperationRule rule = iOperationRuleArray[n2];
            if (rule.matches(resourceType, context, operation) && !rule.passes(resourceType, context, operation)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean checkOperation(String resourceType, IContext context, ICICSOperation operation) {
        boolean supported;
        debug.enter("checkOperation", (Object)this, (Object)resourceType, (Object)context, (Object)operation);
        String actions = this.getActions(resourceType, context);
        switch (operation.getOperationType()) {
            case CREATE: {
                boolean bl = supported = actions.indexOf("create") != -1;
                if (!supported || !IResourceTables.Helper.isCPSMDefinition((String)resourceType)) break;
                supported = !this.isScopedContext(context);
                break;
            }
            case GET: {
                supported = this.checkRules(resourceType, context, operation, new GetCapableRule(actions), new OrderedGetRule(this.getCPSMRelease()), new ResourceAvailableRule(this.supportedResources), this.complexFilterOperatorRule);
                break;
            }
            case UPDATE: {
                supported = actions.indexOf("update") != -1;
                break;
            }
            case DELETE: {
                supported = actions.indexOf("delete") != -1;
                break;
            }
            case PERFORM: {
                if (operation instanceof ICICSAction) {
                    ICICSAction action = (ICICSAction)operation;
                    if (action.getActionName().equals("INSTALL")) {
                        IScopedContext target;
                        boolean bl = supported = actions.indexOf("install") != -1;
                        if (!supported || !(operation instanceof InstallAction) || (!(supported = (target = ((InstallAction)operation).getTarget()).getContext().equals(context.getContext())) || !IResourceTables.Helper.isCICSDefinition((String)resourceType)) && !IResourceTables.Helper.isCSDDefinition((String)resourceType) || !this.isScopedContext(context)) break;
                        String scope = this.getScopeFor(context);
                        supported = target.getScope().equals(scope);
                        break;
                    }
                    if (action.getActionName().equals("REMOVE")) {
                        if (actions.indexOf("remove") != -1) {
                            if (IResourceTables.Helper.isCICSDefinition((String)resourceType)) {
                                supported = !this.isScopedContext(context);
                                break;
                            }
                            if ("RESGROUP".equals(resourceType) && context instanceof IAssociationContext) {
                                supported = "RESDESC".equals(((IAssociationContext)context).getResourceType());
                                break;
                            }
                            if ("CSDGROUP".equals(resourceType) && context instanceof IAssociationContext) {
                                supported = "CSDLIST".equals(((IAssociationContext)context).getResourceType());
                                break;
                            }
                            supported = false;
                            break;
                        }
                        supported = false;
                        break;
                    }
                    if (action.getActionName().equals("EVENT_PROCESSING")) {
                        supported = actions.indexOf("EventProcessing") != -1;
                        break;
                    }
                    if (action.getActionName().equals("CSDCOPY")) {
                        supported = actions.indexOf("perform") != -1 && this.isScopedContext(context);
                        break;
                    }
                    if (action.getActionName().equals("CSDADD")) {
                        supported = actions.indexOf("perform") != -1 && this.isScopedContext(context) && resourceType.equals("CSDGROUP");
                        break;
                    }
                    if (action instanceof SystemManagerActions.AddToResourceDescriptionAction) {
                        supported = actions.indexOf("perform") != -1 && resourceType.equals("RESGROUP");
                        break;
                    }
                    if (action instanceof SystemManagerActions.CSDAddAction) {
                        supported = actions.indexOf("perform") != -1 && resourceType.equals("CSDGROUP");
                        break;
                    }
                    boolean bl = supported = actions.indexOf("perform") != -1;
                    if (!supported || !IResourceTables.Helper.isCICSDefinition((String)resourceType)) break;
                    supported = !this.isScopedContext(context);
                    break;
                }
                supported = actions.indexOf("perform") != -1;
                break;
            }
            default: {
                supported = false;
            }
        }
        debug.exit("checkOperation", (Object)supported);
        return supported;
    }

    protected final boolean isScopedContext(IContext context) {
        return this.getScopeFor(context) != null;
    }

    protected final String getScopeFor(IContext context) {
        String scope;
        if (context instanceof IScopedContext) {
            IScopedContext scopedContext = (IScopedContext)context;
            scope = scopedContext.getScope();
        } else {
            scope = null;
        }
        return scope;
    }

    protected CICSRelease getCPSMRelease() {
        return CICSRelease.fromVersion((String)this.getVersion());
    }

    public void connect() throws ConnectionException {
        debug.enter("connect", (Object)this, (Object)this.getConfiguration().getHost(), (Object)this.getConfiguration().getPort(), (Object)this.getConfiguration().getUserID());
        SMConnectionRecord cmasRecord = this.getCMASRecord();
        this.cmasName = cmasRecord.get(CMAS_ATTRIBUTE_SYSID);
        String cpsmver = cmasRecord.get(CMAS_ATTRIBUTE_CPSMVER);
        this.version = SMCPSMConnection.formatVersionAsCICSTSLevel((String)cpsmver);
        this.connected = true;
        this.checkVersion();
        this.getSupportedResources();
        debug.exit("connect", (Object)("connected=" + Boolean.toString(this.connected) + " version=" + this.version));
    }

    protected void checkVersion() throws ConnectionException {
        CICSRelease release = CICSRelease.fromVersion((String)this.getVersion());
        if (!this.isCICSVersionSupported(release)) {
            this.disconnect();
            throw new SystemManagerConnectionException(Messages.SMConnection_unsupportedCICSRelease);
        }
    }

    protected void getSupportedResources() throws ConnectionException {
        if (DebugOptions.DEBUG_SCHEMA) {
            debug.enter("getSupportedTables", (Object)this);
        }
        this.clearSupportedResources();
        HttpURLConnection connection = null;
        try {
            try {
                URL url = this.createURL("/CICSSystemManagement/schema/CICSSystemManagement.xsd");
                this.lastUrl = url.toString();
                if (DebugOptions.DEBUG_SCHEMA) {
                    debug.event("get", (Object)url);
                }
                connection = this.openConnection(url);
                this.setAuthorization(connection);
                connection.setDoOutput(true);
                connection.setDoInput(true);
                connection.setRequestMethod("GET");
                int responseCode = connection.getResponseCode();
                debug.event("get", (Object)connection.getResponseCode(), (Object)connection.getResponseMessage(), (Object)connection.getContentType());
                if (responseCode == 200) {
                    String contentType = connection.getContentType();
                    if (contentType.startsWith("text/html")) {
                        throw new SystemManagerConnectionException(contentType);
                    }
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    InputStream stream = connection.getInputStream();
                    Document document = documentBuilder.parse(stream);
                    NodeList childNodes = document.getDocumentElement().getChildNodes();
                    String patternTemplate = this.isSecure() ? CICS_SECURE_RESOURCE_SCHEMA_PATTERN_TEMPLATE : CICS_RESOURCE_SCHEMA_PATTERN_TEMPLATE;
                    String myPattern = String.format(patternTemplate, this.getConfiguration().getHost(), this.getConfiguration().getPort());
                    Pattern p = Pattern.compile(myPattern);
                    int i = 0;
                    while (i < childNodes.getLength()) {
                        String schemaLocation;
                        Matcher m;
                        Element element;
                        Node n = childNodes.item(i);
                        if (n.getNodeType() == 1 && (element = (Element)n).getTagName().equals(XSD_INCLUDE) && (m = p.matcher(schemaLocation = element.getAttribute(SCHEMA_LOCATION))).matches()) {
                            String resource = m.group(1);
                            if (DebugOptions.DEBUG_SCHEMA) {
                                debug.event("Found supported resource", resource);
                            }
                            this.addSupportedResource(resource);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception ex) {
                debug.event("getSupportedResources exception", (Object)ex);
                if (connection != null) {
                    connection.disconnect();
                }
                if (DebugOptions.DEBUG_SCHEMA) {
                    debug.exit("getSupportedTables");
                }
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
            if (DebugOptions.DEBUG_SCHEMA) {
                debug.exit("getSupportedTables");
            }
        }
    }

    private SMConnectionRecord getCMASRecord() throws SystemManagerConnectionException, AuthenticationException {
        SMConnectionResponse response = this.getResources("CMAS", IContext.NULL_CONTEXT);
        if (response.getRecordCount() > 0) {
            return response.getRecord(0);
        }
        throw new SystemManagerConnectionException("Missing CMAS Record ");
    }

    public void disconnect() throws ConnectionException {
        debug.enter("disconnect", (Object)this);
        this.discardAll();
        this.connected = false;
        debug.exit("disconnect", (Object)Boolean.toString(this.connected));
    }

    public boolean isConnected() {
        return this.connected;
    }

    private void discardAll() {
        debug.enter("discardAll", (Object)this, this.stubs);
        Iterator<String> iterator = new ArrayList<String>(this.stubs.keySet()).iterator();
        while (iterator.hasNext()) {
            String string;
            String stub = string = iterator.next();
            try {
                this.discard(stub);
            }
            catch (ConnectionException ex) {
                debug.warning("discardAll", stub, (Throwable)ex);
            }
        }
        debug.exit("discardAll");
    }

    public String getServerApplID() {
        return this.cmasName;
    }

    public String getVersion() {
        return this.version;
    }

    public SMConnectionResponse create(String resourceType, IContext context, SMConnectionRecord record) throws ConnectionException {
        SMConnectionResponse smResponse;
        block9: {
            debug.enter("create", (Object)this, (Object)resourceType, (Object)context, (Object)record);
            HttpURLConnection connection = null;
            String modelName = IModelNames.ModelNamesHelper.getModelName(resourceType);
            try {
                try {
                    String request = this.buildCREATERequest(context);
                    URL url = this.createURL(FILE + modelName + request);
                    debug.event("create", (Object)url);
                    connection = this.openConnection(url);
                    this.setAuthorization(connection);
                    connection.setDoOutput(true);
                    connection.setDoInput(true);
                    connection.setRequestMethod("POST");
                    String payload = this.buildCreatePayload(resourceType, context, (IMutableSMConnectionRecord)record);
                    debug.event("create", payload);
                    OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
                    writer.write(payload);
                    writer.flush();
                    writer.close();
                    int responseCode = connection.getResponseCode();
                    debug.event("create", new Object[]{String.valueOf(connection.getResponseCode()), connection.getResponseMessage()});
                    if (responseCode == 200) {
                        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                        SMResponseHandler handler = new SMResponseHandler(resourceType, modelName, context, connection.getInputStream(), connection.getURL());
                        parser.parse(handler.getInputStream(), (DefaultHandler)handler);
                        smResponse = handler.getResponse();
                        break block9;
                    }
                    throw new SMConnectionException(url, connection.getResponseCode(), connection.getResponseMessage());
                }
                catch (IOException ex) {
                    debug.warning("create", (Object)ex);
                    throw new SMConnectionException(ex);
                }
                catch (ParserConfigurationException ex) {
                    debug.warning("create", (Object)ex);
                    throw new SMConnectionException(ex);
                }
                catch (SAXException ex) {
                    debug.warning("create", (Object)ex);
                    throw new SMConnectionException(ex);
                }
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        debug.exit("create", (Object)smResponse);
        return smResponse;
    }

    private String buildCREATERequest(IContext context) throws UnsupportedEncodingException {
        IContext parentContext;
        String request = "/" + URLEncoder.encode(context.getContext(), "UTF-8");
        if (context instanceof IGroupContext && (parentContext = ((IGroupContext)context).getParentContext()) instanceof IScopedContext) {
            request = String.valueOf(request) + "/" + URLEncoder.encode(((IScopedContext)parentContext).getScope(), "UTF-8");
        }
        return request;
    }

    private String escapeXmlPayload(String xmlPayload) {
        return xmlPayload.replace("\"", "&quot;");
    }

    private String buildCreatePayload(String resourceType, IContext context, IMutableSMConnectionRecord mutableRecord) throws SystemManagerConnectionException, AuthenticationException {
        IDefinitionContext definitionContext;
        String resourceGroup;
        String payload = "<request><create>";
        String csdGroupName = null;
        if (IResourceTables.Helper.isCICSDefinition((String)resourceType) && context instanceof IDefinitionContext && (resourceGroup = (definitionContext = (IDefinitionContext)context).getResourceGroup()) != null && resourceGroup.trim().length() > 0) {
            if (definitionContext instanceof IGroupContext && ((IGroupContext)definitionContext).getParentContext() instanceof IScopedContext) {
                csdGroupName = resourceGroup;
                payload = String.valueOf(payload) + "<parameter name=\"CSD\"/>";
            } else {
                payload = String.valueOf(payload) + "<parameter name=\"RESGROUP\" value=\"" + this.escapeXmlPayload(definitionContext.getResourceGroup()) + "\"/>";
            }
        }
        if (context instanceof IParameterisedContext) {
            payload = this.appendParameters((IParameterisedContext)context, payload);
        }
        payload = String.valueOf(payload) + "<attributes";
        for (String name : mutableRecord) {
            String value = mutableRecord.get(name);
            if ("DEFVER".equals(name) && "0".equals(value)) {
                if (csdGroupName != null) continue;
                value = this.getNextAvailableVersion(resourceType, context, mutableRecord.get("NAME"));
            }
            payload = String.valueOf(payload) + " " + this.escapeXmlPayload(name) + "=" + "\"" + this.escapeXmlPayload(value) + "\"";
        }
        if (csdGroupName != null) {
            payload = String.valueOf(payload) + " csdgroup=\"" + this.escapeXmlPayload(csdGroupName) + "\"";
        }
        payload = String.valueOf(payload) + "/></create></request>";
        return payload;
    }

    private String appendParameters(IParameterisedContext parameterisedContext, String payload) {
        for (String name : parameterisedContext.getParameterNames()) {
            String value = parameterisedContext.getParameterValue(name);
            payload = String.valueOf(payload) + "<parameter name=\"" + this.escapeXmlPayload(name) + "\" ";
            if (value != null) {
                payload = String.valueOf(payload) + "value=\"" + this.escapeXmlPayload(value) + "\"";
            }
            payload = String.valueOf(payload) + "/>";
        }
        return payload;
    }

    private void setAuthorization(HttpURLConnection connection) {
        String base64String;
        byte[] credentialsBytes;
        String property = String.valueOf(this.getConfiguration().getUserID()) + ":" + this.getConfiguration().getPassword();
        try {
            credentialsBytes = property.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            String defaultEncoding = System.getProperty("file.encoding");
            debug.warning("setAuthorization", "Couldn't decode header as ISO-8859-1, attempting to use default encoding: " + defaultEncoding, (Throwable)ex);
            credentialsBytes = property.getBytes();
        }
        byte[] base64Bytes = Base64.encodeBase64((byte[])credentialsBytes, (boolean)false);
        try {
            base64String = new String(base64Bytes, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            String defaultEncoding = System.getProperty("file.encoding");
            debug.warning("setAuthorization", "Couldn't encode header as ISO-8859-1, attempting to use default encoding: " + defaultEncoding, (Throwable)ex);
            base64String = new String(base64Bytes);
        }
        debug.event("setAuthorization", (Object)this, (Object)"Authorization", (Object)this.getConfiguration().getUserID());
        connection.setRequestProperty("Authorization", "Basic " + base64String);
        Authenticator.setDefault(null);
        connection.setRequestProperty(USER_AGENT_PROPERTY, USER_AGENT);
    }

    private String getNextAvailableVersion(String resourceType, final IContext context, String name) throws SystemManagerConnectionException, AuthenticationException {
        debug.enter("getNextAvailableVersion", (Object)this, (Object)resourceType, (Object)context, (Object)name);
        String version = null;
        final HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("NAME", name);
        IFilteredContext filteredContext = new IFilteredContext(){

            public String getContext() {
                return this.getParentContext().getContext();
            }

            public String getScope() {
                return null;
            }

            public IContext getParentContext() {
                return new IContext(){

                    public String getContext() {
                        return context.getContext();
                    }
                };
            }

            public String getAttributeValue(String attributeName) {
                return (String)attributes.get(attributeName);
            }

            public Set getAttributeNames() {
                return attributes.keySet();
            }

            public String toString() {
                return String.valueOf(this.getClass().getName()) + "[" + this.getContext() + "/" + attributes + "]";
            }
        };
        debug.event("getNextAvailableVersion", (Object)filteredContext);
        SMConnectionResponse response = this.getResources(resourceType, (IContext)filteredContext);
        int index = 0;
        if (response.getRecordCount() < 15) {
            int i = 1;
            while (i <= 15 && version == null) {
                if (index < response.getRecordTotal()) {
                    SMConnectionRecord record = response.getRecord(index);
                    int usedVersion = Integer.valueOf(record.get("DEFVER"));
                    if (usedVersion != i) {
                        version = String.valueOf(i);
                    } else {
                        ++index;
                    }
                } else {
                    version = String.valueOf(i);
                }
                ++i;
            }
        } else {
            throw new SMConnectionCreateException("NAME");
        }
        debug.exit("getNextAvailableVersion", version);
        return version;
    }

    public String getLastUrl() {
        return this.lastUrl;
    }

    public SMConnectionResponse get(String resourceType, IContext context) throws SystemManagerConnectionException, AuthenticationException {
        SMConnectionResponse smResponse;
        block19: {
            debug.enter("get", (Object)this, (Object)resourceType, (Object)context);
            smResponse = null;
            HttpURLConnection connection = null;
            String modelName = IModelNames.ModelNamesHelper.getModelName(resourceType);
            try {
                try {
                    String request;
                    try {
                        request = this.buildGETRequest(resourceType, context);
                    }
                    catch (InvalidFilterException e) {
                        debug.warning("buildGETRequest", (Object)context, (Object)e);
                        throw new SMConnectionException((Exception)((Object)e));
                    }
                    URL url = this.createURL(FILE + modelName + request);
                    this.lastUrl = url.toString();
                    debug.event("get", (Object)url);
                    connection = this.openConnection(url);
                    this.setAuthorization(connection);
                    connection.setDoOutput(true);
                    connection.setDoInput(true);
                    connection.setRequestMethod("GET");
                    int responseCode = connection.getResponseCode();
                    String contentType = connection.getContentType();
                    debug.event("get", (Object)connection.getResponseCode(), (Object)connection.getResponseMessage(), (Object)connection.getContentType());
                    if (responseCode == 200) {
                        if (contentType.startsWith("text/html")) {
                            if (!this.connected) {
                                if (this.getConfiguration() != null) {
                                    throw new AuthenticationException("Password expired");
                                }
                                throw new AuthenticationException("Password expired");
                            }
                            throw new SystemManagerConnectionException(contentType);
                        }
                        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                        SMResponseHandler handler = new SMResponseHandler(resourceType, modelName, context, connection.getInputStream(), connection.getURL()){

                            @Override
                            protected boolean isOK(int response) {
                                return response == 1024 || response == 1027;
                            }
                        };
                        parser.parse(handler.getInputStream(), (DefaultHandler)handler);
                        smResponse = handler.getResponse();
                        this.stubs.put(smResponse.getStub(), smResponse);
                        break block19;
                    }
                    ErrorHandler handler = null;
                    if (connection.getErrorStream() != null && this.isXML(contentType) && responseCode != 401) {
                        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                        handler = new ErrorHandler(connection.getErrorStream());
                        parser.parse(handler.getInputStream(), (DefaultHandler)handler);
                    }
                    if (responseCode == 404 && this.isConnected()) {
                        throw new TypeNotFoundException(url, responseCode, connection.getResponseMessage(), resourceType);
                    }
                    if (responseCode == 401) {
                        throw new AuthenticationException(connection.getResponseMessage());
                    }
                    if (responseCode == 403) {
                        smResponse = this.handleForbidden(resourceType, context, smResponse, connection, url, handler);
                        break block19;
                    }
                    String message = connection.getResponseMessage();
                    throw new SMConnectionException(url, connection.getResponseCode(), message == null ? "Unrecognized response" : message);
                }
                catch (IOException ex) {
                    debug.warning("get", (Object)ex);
                    throw new SMConnectionException(ex);
                }
                catch (ParserConfigurationException ex) {
                    debug.warning("get", (Object)ex);
                    throw new SMConnectionException(ex);
                }
                catch (SAXException ex) {
                    debug.warning("get", (Object)ex);
                    throw new SMConnectionException(ex);
                }
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        if ("CSDGROUP".equals(resourceType) && ContextHelper.getContextFrom((IContext)context, IAssociationContext.class) != null) {
            SMConnectionResponse fetchResponse = this.fetch(smResponse.getStub(), 1, smResponse.getRecordTotal());
            this.discard(fetchResponse.getStub());
            IAssociationContext associationContext = (IAssociationContext)ContextHelper.getContextFrom((IContext)context, IAssociationContext.class);
            SMConnectionRecord[] groupsInList = this.filterCSDGroupsByList(fetchResponse, associationContext);
            return this.createLocalResponse(resourceType, groupsInList, context);
        }
        debug.exit("get", (Object)smResponse);
        return smResponse;
    }

    private SMConnectionResponse handleForbidden(String resourceType, IContext context, SMConnectionResponse smResponse, HttpURLConnection connection, URL url, ErrorHandler handler) throws SMConnectionException, IOException {
        if (handler != null) {
            if (handler.isDefaultWarningCountExceeded()) {
                int recordCount = handler != null ? handler.getCurrentRecordCount() : 0;
                smResponse = new SMResponse("warn@" + UUID.randomUUID().toString().subSequence(0, 10), resourceType, recordCount, context, "NODATA");
                this.stubs.put(smResponse.getStub(), smResponse);
                return smResponse;
            }
            if (handler.errorMessageId != null) {
                throw new SMConnectionException(url, connection.getResponseCode(), String.valueOf(connection.getResponseMessage()) + ": " + handler.errorMessageId);
            }
        }
        String message = connection.getResponseMessage();
        throw new SMConnectionException(url, connection.getResponseCode(), message == null ? "Unrecognized response" : message);
    }

    protected SMConnectionResponse createLocalResponse(String resourceType, SMConnectionRecord[] records, IContext context) {
        SMResponse localResponse = new SMResponse(this.generateLocalStub(), resourceType, records, context);
        this.stubs.put(localResponse.getStub(), localResponse);
        return localResponse;
    }

    private SMConnectionRecord[] filterCSDGroupsByList(SMConnectionResponse groupsResponse, IAssociationContext associationContext) throws SystemManagerConnectionException, AuthenticationException {
        GroupsInListFilteredContext inListContext = new GroupsInListFilteredContext(associationContext);
        debug.event("getWithAssociation", (Object)inListContext);
        SMConnectionResponse lists = this.getResources("CSDINLST", (IContext)inListContext);
        LinkedList<SMConnectionRecord> recordList = new LinkedList<SMConnectionRecord>();
        block0: for (SMConnectionRecord group : groupsResponse) {
            String groupName = group.get("NAME");
            for (SMConnectionRecord list : lists) {
                String inListName = list.get("CSDGROUP");
                if (!groupName.equals(inListName)) continue;
                recordList.add(group);
                continue block0;
            }
        }
        return recordList.toArray(new SMConnectionRecord[0]);
    }

    private boolean isXML(String contentType) {
        if (contentType != null) {
            return contentType.contains("application/xml") || contentType.contains("text/xml");
        }
        return false;
    }

    private String generateLocalStub() {
        return "local@" + UUID.randomUUID();
    }

    private String getParameter(char prefix, String parameterName, String parameterValue) throws UnsupportedEncodingException {
        return String.valueOf(prefix) + URLEncoder.encode(parameterName, "UTF-8") + "=" + URLEncoder.encode(parameterValue, "UTF-8");
    }

    protected String buildGETRequest(String resourceType, IContext context) throws UnsupportedEncodingException, TypeNotFoundException, InvalidFilterException {
        String request;
        if (context.getContext() == null) {
            request = "//?NODISCARD=NODISCARD&SUMMONLY";
        } else {
            IScopedContext scopedContext;
            IFilteredContext filteredContext;
            request = "?NODISCARD=NODISCARD&SUMMONLY";
            IContext parentContext = context;
            if (context instanceof IOrderedContext) {
                if (this.isConnected()) {
                    debug.event("buildGETRequest", "connected true");
                    boolean permitted = this.checkOperation(resourceType, context, ICICSOperation.GET);
                    if (permitted) {
                        debug.event("buildGETRequest", "permitted true");
                        IOrderedContext oContext = (IOrderedContext)context;
                        List sOrders = oContext.getSortOrders();
                        if (sOrders.size() > 0) {
                            int count = 0;
                            StringBuffer paramVal = new StringBuffer();
                            Collections.reverse(sOrders);
                            for (SortOrder sortOrder : sOrders) {
                                paramVal.append(String.valueOf(sortOrder.getAttribute()) + (sortOrder.getDirection() ? "" : "/D"));
                                if (++count >= sOrders.size()) continue;
                                paramVal.append(",");
                            }
                            request = String.valueOf(request) + this.getParameter('&', PARAM_ORDERBY, paramVal.toString());
                        }
                    }
                }
                parentContext = ((IOrderedContext)context).getParentContext();
            }
            String csdgroup = null;
            StringBuilder filterCriteria = new StringBuilder();
            while (parentContext instanceof IFilteredContext) {
                filteredContext = (IFilteredContext)parentContext;
                csdgroup = filteredContext.getAttributeValue("CSDGROUP");
                String nextCriteria = this.getCriteriaFromFilteredContext(filteredContext);
                if (nextCriteria.length() != 0) {
                    if (filterCriteria.length() != 0) {
                        filterCriteria.append(CRITERIA_AND);
                    }
                    filterCriteria.append(nextCriteria);
                }
                parentContext = ContextHelper.getParentContext((IContext)filteredContext);
            }
            if (filterCriteria.length() > 0) {
                request = String.valueOf(request) + "&CRITERIA=(" + filterCriteria + ")";
            }
            if (parentContext instanceof IParameterisedContext) {
                IParameterisedContext parameterisedContext = (IParameterisedContext)parentContext;
                String parameters = this.getParametersFromParameterisedContext(parameterisedContext);
                if (parameters.length() > 0) {
                    request = String.valueOf(request) + "&PARAMETER=" + parameters;
                }
                parentContext = parameterisedContext.getParentContext();
            } else if (parentContext instanceof IComplexFilteredContext) {
                filteredContext = (IComplexFilteredContext)parentContext;
                String criteria = this.complexFilterOperatorRule.getCriteriaFromComplexFilteredContext((IComplexFilteredContext)filteredContext);
                if (criteria.length() > 0) {
                    request = String.valueOf(request) + "&CRITERIA=" + criteria;
                }
                parentContext = filteredContext.getParentContext();
            } else if (parentContext instanceof ICompoundFilteredContext) {
                ICompoundFilteredContext compoundFilteredContext = (ICompoundFilteredContext)parentContext;
                String criteria = this.getCriteriaFromCompoundFilteredContext(compoundFilteredContext);
                if (criteria.length() > 0) {
                    request = String.valueOf(request) + "&CRITERIA=(" + criteria + ")";
                }
                parentContext = compoundFilteredContext.getParentContext();
            }
            if (parentContext instanceof ISystemParameterContext) {
                ISystemParameterContext systemParameterContext = (ISystemParameterContext)parentContext;
                request = String.valueOf(request) + "&PARAMETER=" + URLEncoder.encode("PARMTYPE(" + systemParameterContext.getType() + ")", "UTF-8");
                request = String.valueOf(request) + "%20";
                request = String.valueOf(request) + URLEncoder.encode("PARMSRCE(" + systemParameterContext.getSource() + ")", "UTF-8");
                parentContext = systemParameterContext.getParentContext();
            }
            if (parentContext instanceof IGroupContext) {
                IGroupContext groupContext = (IGroupContext)parentContext;
                parentContext = groupContext.getParentContext();
                String groupName = groupContext.getResourceGroup();
                String parameterName = parentContext instanceof IScopedContext ? "CSDGROUP" : "RESGROUP";
                request = String.valueOf(request) + "&PARAMETER=" + URLEncoder.encode(String.valueOf(parameterName) + "(" + groupName + ")", "UTF-8");
            } else if (parentContext instanceof IScopedContext && IResourceTables.Helper.isCICSDefinition((String)resourceType) && (scopedContext = (IScopedContext)parentContext).getScope() != null) {
                request = String.valueOf(request) + "&PARAMETER=CSDGROUP(" + (csdgroup != null && csdgroup.trim().length() > 0 ? csdgroup : "*") + ")";
            }
            if (parentContext instanceof IScopedContext) {
                scopedContext = (IScopedContext)parentContext;
                String scope = scopedContext.getScope();
                if (scope == null) {
                    scope = "";
                }
                request = "/" + URLEncoder.encode(scope, "UTF-8") + request;
            }
            request = this.appendWorkloadParameter(request, context, parentContext, resourceType);
            request = "/" + URLEncoder.encode(parentContext.getContext(), "UTF-8") + request;
            if (parentContext instanceof IDefinitionContext) {
                IDefinitionContext definitionContext = (IDefinitionContext)parentContext;
                String resourceGroup = definitionContext.getResourceGroup();
                debug.event("buildGETRequest", (Object)definitionContext, (Object)resourceGroup);
                if (resourceGroup != null) {
                    request = String.valueOf(request) + "&PARAMETER=" + URLEncoder.encode("RESGROUP(" + definitionContext.getResourceGroup() + ")", "UTF-8");
                }
            } else if (ContextHelper.getContextFrom((IContext)parentContext, IAssociationContext.class) != null && !IResourceTables.Helper.isCSDDefinition((String)resourceType)) {
                IAssociationContext associationContext = (IAssociationContext)ContextHelper.getContextFrom((IContext)parentContext, IAssociationContext.class);
                String type = IModelNames.ModelNamesHelper.getModelName(associationContext.getResourceType());
                String name = associationContext.getResourceName();
                debug.event("buildGETRequest", (Object)associationContext, (Object)type, (Object)name);
                request = String.valueOf(request) + "&ASSOCIATION=" + URLEncoder.encode(String.valueOf(type) + "=" + name, "UTF-8");
            }
        }
        return request;
    }

    private String appendWorkloadParameter(String request, IContext context, IContext parentContext, String resourceType) {
        if (this.requiresWorkloadParameter(resourceType)) {
            String workloadName = "*";
            Object workloadContext = null;
            if (parentContext instanceof IWorkloadContext) {
                workloadName = ((IWorkloadContext)parentContext).getWorkloadName();
            } else if (context instanceof IWorkloadContext) {
                workloadName = ((IWorkloadContext)context).getWorkloadName();
            }
            debug.event("appendWorkloadParamater", workloadContext, (Object)workloadName);
            return String.valueOf(request) + "&PARAMETER=WORKLOAD(" + workloadName + ")";
        }
        return request;
    }

    protected boolean requiresWorkloadParameter(String resourceType) {
        return resourceType.equals("WLMAROUT") || resourceType.equals("WLMATAFF") || resourceType.equals("WLMATGRP") || resourceType.equals("WLMATRAN") || resourceType.equals("WLMAWAOR") || resourceType.equals("WLMAWDEF") || resourceType.equals("WLMAWTOR");
    }

    public SMConnectionResponse getResources(String resourceName, IContext context) throws SystemManagerConnectionException, AuthenticationException {
        debug.enter("getResources", (Object)this, (Object)resourceName, (Object)context);
        SMConnectionResponse response = this.get(resourceName, context);
        response = this.fetch(response.getStub(), 1, response.getRecordTotal());
        this.discard(response.getStub());
        debug.exit("getResources", (Object)response);
        return response;
    }

    public SMConnectionResponse fetch(String stub, int position, int count) throws SystemManagerConnectionException, AuthenticationException {
        SMResponse smResponse;
        block16: {
            debug.enter("fetch", (Object)this, (Object)stub, (Object)position, (Object)count);
            SMResponse smRequest = (SMResponse)this.stubs.get(stub);
            String resourceType = smRequest.getResourceType();
            String modelName = IModelNames.ModelNamesHelper.getModelName(resourceType);
            debug.event("fetch", (Object)smRequest, (Object)resourceType, (Object)modelName);
            HttpURLConnection connection = null;
            if (smRequest.getResponse().equals("NODATA")) {
                smResponse = new SMResponse(stub, resourceType, new String[0], smRequest.getContext());
            } else if (this.isLocal(stub)) {
                smResponse = new SMResponse(smRequest, position - 1, count);
            } else if (smRequest.getRecordTotal() == 0) {
                debug.event("fetch", (Object)smRequest);
                smResponse = new SMResponse(stub, resourceType, new String[0], null);
            } else {
                try {
                    try {
                        String request = "/" + stub + "/" + position + "/" + count;
                        request = String.valueOf(request) + "?NODISCARD=NODISCARD";
                        URL url = this.createURL("/CICSSystemManagement/CICSResultCache" + request);
                        debug.event("fetch", (Object)url);
                        connection = this.openConnection(url);
                        this.setAuthorization(connection);
                        connection.setDoOutput(true);
                        connection.setDoInput(true);
                        connection.setRequestMethod("GET");
                        int responseCode = connection.getResponseCode();
                        debug.event("fetch", (Object)connection.getResponseCode(), (Object)connection.getResponseMessage());
                        if (responseCode == 200) {
                            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                            SMResponseHandler handler = new SMResponseHandler(resourceType, modelName, smRequest.getContext(), connection.getInputStream(), connection.getURL());
                            parser.parse(handler.getInputStream(), (DefaultHandler)handler);
                            smResponse = handler.getResponse();
                            this.stubs.put(smRequest.getStub(), smRequest);
                            break block16;
                        }
                        if (responseCode == 404) {
                            this.stubs.remove(smRequest.getStub());
                            SMConnectionResponse getResponse = this.get(smRequest.getResourceType(), smRequest.getContext());
                            smResponse = this.fetch(getResponse.getStub(), position, count);
                            break block16;
                        }
                        throw new SMConnectionException(url, connection.getResponseCode(), connection.getResponseMessage());
                    }
                    catch (IOException ex) {
                        debug.warning("fetch", (Object)ex);
                        throw new SMConnectionException(ex);
                    }
                    catch (ParserConfigurationException ex) {
                        debug.warning("fetch", (Object)ex);
                        throw new SMConnectionException(ex);
                    }
                    catch (SAXException ex) {
                        debug.warning("fetch", (Object)ex);
                        throw new SMConnectionException(ex);
                    }
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
        }
        debug.exit("fetch", (Object)smResponse);
        return smResponse;
    }

    private boolean isLocal(String stub) {
        return stub.startsWith("local@");
    }

    public void discard(String stub) throws SMConnectionException {
        block9: {
            debug.enter("discard", (Object)this, (Object)stub);
            SMResponse smResponse = (SMResponse)this.stubs.remove(stub);
            debug.event("discard", (Object)smResponse);
            HttpURLConnection connection = null;
            if (smResponse != null && smResponse.getRecordTotal() != 0 && !this.isLocal(stub)) {
                try {
                    try {
                        String resourceType = smResponse.getResourceType();
                        String request = "/" + stub + "/?SUMMONLY";
                        URL url = this.createURL("/CICSSystemManagement/CICSResultCache" + request);
                        debug.event("discard", (Object)url);
                        connection = this.openConnection(url);
                        this.setAuthorization(connection);
                        connection.setDoOutput(true);
                        connection.setDoInput(true);
                        connection.setRequestMethod("GET");
                        int responseCode = connection.getResponseCode();
                        debug.event("discard", new Object[]{String.valueOf(connection.getResponseCode()), connection.getResponseMessage()});
                        if (responseCode == 200) {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
                            String declaration = reader.readLine();
                            String response = reader.readLine();
                            String resultSummary = reader.readLine();
                            debug.event("discard", (Object)declaration, (Object)response, (Object)resultSummary);
                            reader.close();
                            smResponse = new SMResponse(resourceType, "OK", smResponse.getContext());
                            break block9;
                        }
                        if (responseCode == 404) {
                            smResponse = new SMResponse(resourceType, "OK", smResponse.getContext());
                            break block9;
                        }
                        throw new SMConnectionException(url, connection.getResponseCode(), connection.getResponseMessage());
                    }
                    catch (IOException ex) {
                        debug.warning("discard", (Object)ex);
                        throw new SMConnectionException(ex);
                    }
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
        }
        debug.exit("discard", (Object)String.valueOf(this.stubs.size()));
    }

    public SMConnectionResponse update(String resourceType, IContext context, SMConnectionRecord record) throws ConnectionException {
        SMConnectionResponse smResponse;
        block9: {
            debug.enter("update", (Object)resourceType, (Object)context, (Object)record);
            HttpURLConnection connection = null;
            String modelName = IModelNames.ModelNamesHelper.getModelName(resourceType);
            try {
                try {
                    String request = this.buildUpdateRequest(resourceType, context);
                    URL url = this.createURL(FILE + modelName + request);
                    debug.event("update", (Object)url);
                    connection = this.openConnection(url);
                    this.setAuthorization(connection);
                    connection.setDoOutput(true);
                    connection.setDoInput(true);
                    connection.setRequestMethod("PUT");
                    String payload = this.buildUpdatePayload(resourceType, request.indexOf("CSDGROUP") != -1, (IMutableSMConnectionRecord)record);
                    debug.event("update", payload);
                    OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
                    writer.write(payload);
                    writer.flush();
                    writer.close();
                    int responseCode = connection.getResponseCode();
                    debug.event("update", new Object[]{String.valueOf(connection.getResponseCode()), connection.getResponseMessage()});
                    if (responseCode == 200) {
                        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                        SMResponseHandler handler = new SMResponseHandler(resourceType, modelName, context, connection.getInputStream(), connection.getURL());
                        parser.parse(handler.getInputStream(), (DefaultHandler)handler);
                        smResponse = handler.getResponse();
                        break block9;
                    }
                    throw new SMConnectionException(url, connection.getResponseCode(), connection.getResponseMessage());
                }
                catch (IOException ex) {
                    debug.warning("update", (Object)ex);
                    throw new SMConnectionException(ex);
                }
                catch (ParserConfigurationException ex) {
                    debug.warning("update", (Object)ex);
                    throw new SMConnectionException(ex);
                }
                catch (SAXException ex) {
                    debug.warning("update", (Object)ex);
                    throw new SMConnectionException(ex);
                }
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        debug.exit("update", (Object)smResponse);
        return smResponse;
    }

    private String buildUpdateRequest(String resourceType, IContext context) throws UnsupportedEncodingException {
        debug.enter("buildUpdateRequest", (Object)resourceType, (Object)context);
        String scope = "";
        String groupName = "*";
        String criteriaParameter = "";
        String groupParameter = "";
        String groupParameterName = "CSDGROUP";
        IContext parentContext = context;
        while (parentContext != null) {
            if (parentContext instanceof IFilteredContext && criteriaParameter.length() == 0) {
                IFilteredContext filteredContext = (IFilteredContext)parentContext;
                String criteria = this.getCriteriaFromFilteredContext(filteredContext);
                if (criteria.length() > 0) {
                    criteriaParameter = "?CRITERIA=(" + criteria + ")";
                }
                parentContext = filteredContext.getParentContext();
                debug.event("buildUpdateRequest", criteriaParameter);
                continue;
            }
            if (parentContext instanceof IGroupContext) {
                IGroupContext groupContext = (IGroupContext)parentContext;
                groupName = groupContext.getResourceGroup();
                parentContext = groupContext.getParentContext();
                groupParameterName = parentContext instanceof IScopedContext ? "CSDGROUP" : "RESGROUP";
                debug.event("buildUpdateRequest", groupName);
                continue;
            }
            if (parentContext instanceof IScopedContext) {
                IScopedContext scopedContext = (IScopedContext)parentContext;
                scope = scopedContext.getScope();
                if (scope == null) {
                    scope = "";
                }
                parentContext = null;
                debug.event("buildUpdateRequest", scope);
                continue;
            }
            parentContext = null;
        }
        if (scope.length() > 0 && IResourceTables.Helper.isCICSDefinition((String)resourceType)) {
            groupParameter = "&PARAMETER=" + groupParameterName + "(" + URLEncoder.encode(groupName, "UTF-8") + ")";
        }
        String request = "/" + URLEncoder.encode(context.getContext(), "UTF-8") + "/" + URLEncoder.encode(scope, "UTF-8") + "/" + criteriaParameter + groupParameter;
        request = this.appendWorkloadParameter(request, context, parentContext, resourceType);
        debug.exit("buildUpdateRequest", (Object)request);
        return request;
    }

    protected String buildUpdatePayload(String resourceType, boolean isCSD, IMutableSMConnectionRecord mutableRecord) {
        String payload = "<request><update>";
        if (isCSD) {
            payload = String.valueOf(payload) + "<parameter name=\"CSD\"/>";
        }
        payload = String.valueOf(payload) + "<attributes";
        for (String name : mutableRecord) {
            String value = mutableRecord.get(name);
            payload = String.valueOf(payload) + " " + this.escapeXmlPayload(name) + "=" + "\"" + this.escapeXmlPayload(value) + "\"";
        }
        payload = String.valueOf(payload) + " /></update></request>";
        return payload;
    }

    /*
     * Exception decompiling
     */
    private SMConnectionResponse delete(String resourceType, IContext context, boolean useMethodOverride) throws SystemManagerConnectionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SMConnectionResponse delete(String resourceType, IContext context) throws SystemManagerConnectionException {
        return this.delete(resourceType, context, false);
    }

    protected String buildDELETERequest(String resourceType, IContext context) throws UnsupportedEncodingException, TypeNotFoundException, InvalidFilterException {
        IScopedContext scopedContext;
        String criteria;
        IFilteredContext filteredContext;
        String request = "";
        IContext parentContext = context;
        String csdgroup = null;
        if (context instanceof IFilteredContext) {
            filteredContext = (IFilteredContext)parentContext;
            csdgroup = filteredContext.getAttributeValue("CSDGROUP");
            criteria = this.getCriteriaFromFilteredContext(filteredContext);
            if (criteria.length() > 0) {
                request = String.valueOf(request) + "?CRITERIA=(" + criteria + ")";
            }
            debug.event("delete", criteria);
            parentContext = filteredContext.getParentContext();
        } else if (parentContext instanceof IComplexFilteredContext) {
            filteredContext = (IComplexFilteredContext)parentContext;
            criteria = this.complexFilterOperatorRule.getCriteriaFromComplexFilteredContext((IComplexFilteredContext)filteredContext);
            if (criteria.length() > 0) {
                request = String.valueOf(request) + "&CRITERIA=" + criteria;
            }
            parentContext = filteredContext.getParentContext();
        } else if (context instanceof ICompoundFilteredContext) {
            ICompoundFilteredContext compoundFilteredContext = (ICompoundFilteredContext)parentContext;
            criteria = this.getCriteriaFromCompoundFilteredContext(compoundFilteredContext);
            if (criteria.length() > 0) {
                request = String.valueOf(request) + "?CRITERIA=(" + criteria + ")";
            }
            debug.event("delete", criteria);
            parentContext = compoundFilteredContext.getParentContext();
        }
        if (parentContext instanceof IScopedContext && IResourceTables.Helper.isCICSDefinition((String)resourceType)) {
            scopedContext = (IScopedContext)parentContext;
            if (scopedContext.getScope() != null) {
                request = String.valueOf(request) + "&PARAMETER=CSDGROUP(" + (csdgroup != null && csdgroup.trim().length() > 0 ? csdgroup : "*") + ")";
            }
        } else if (parentContext instanceof IGroupContext && IResourceTables.Helper.isCICSDefinition((String)resourceType)) {
            IGroupContext groupContext = (IGroupContext)parentContext;
            String groupName = groupContext.getResourceGroup();
            debug.event("delete", groupName);
            parentContext = groupContext.getParentContext();
            if (groupName != null && parentContext instanceof IScopedContext) {
                request = String.valueOf(request) + "&PARAMETER=CSDGROUP(" + URLEncoder.encode(groupName, "UTF-8") + ")";
            }
        }
        if (parentContext instanceof IScopedContext) {
            scopedContext = (IScopedContext)parentContext;
            String scope = scopedContext.getScope();
            if (scope == null) {
                scope = "";
            }
            debug.event("delete", scope);
            request = "/" + URLEncoder.encode(scope, "UTF-8") + request;
        }
        request = this.appendWorkloadParameter(request, context, parentContext, resourceType);
        request = "/" + URLEncoder.encode(parentContext.getContext(), "UTF-8") + request;
        return request;
    }

    private String buildDeletePayload(String resourceType, IContext context) {
        IContext parentContext;
        boolean hasPayload = false;
        String payload = "<request><delete>";
        if (context instanceof IParameterisedContext) {
            hasPayload = true;
            payload = this.appendParameters((IParameterisedContext)context, payload);
        } else if (context instanceof IFilteredContext && (parentContext = ((IFilteredContext)context).getParentContext()) instanceof IParameterisedContext) {
            hasPayload = true;
            payload = this.appendParameters((IParameterisedContext)parentContext, payload);
        }
        payload = String.valueOf(payload) + "</delete></request>";
        return hasPayload ? payload : "";
    }

    public SMConnectionResponse add(String resourceType, IFilteredContext definition, IFilteredContext group) throws ConnectionException {
        debug.enter("add", (Object)this, (Object)resourceType, (Object)definition, (Object)group);
        String groupName = group.getAttributeValue("RESGROUP");
        AbstractCICSAction addToGroupAction = new AbstractCICSAction("ADDTOGRP", new String[][]{{"RESGROUP", groupName}}){};
        debug.event("add", (Object)resourceType, (Object)definition, (Object)addToGroupAction);
        SMConnectionResponse response = this.perform(resourceType, (IContext)definition, (ICICSAction)addToGroupAction);
        debug.exit("add", (Object)response);
        return response;
    }

    public SMConnectionResponse remove(String resourceType, IFilteredContext child, IFilteredContext parent) throws SystemManagerConnectionException {
        SMConnectionResponse response;
        debug.enter("remove", (Object)this, (Object)resourceType, (Object)child, (Object)parent);
        String modelName = IModelNames.ModelNamesHelper.getModelName(resourceType);
        debug.event("remove", modelName);
        if (modelName == "CICSCSDGroup") {
            GroupInListPrimaryKey context = new GroupInListPrimaryKey(parent, child);
            debug.event("remove", (Object)context);
            response = this.delete("CSDINLST", (IContext)context);
        } else if (modelName == "CICSResourceGroup") {
            ResourceGroupInResourceDescriptionPrimaryKey context = new ResourceGroupInResourceDescriptionPrimaryKey(parent, child);
            debug.event("remove", (Object)context);
            response = this.delete("RESINDSC", (IContext)context);
        } else if (modelName == "CICSRegionDefinition") {
            RegionInRegionGroupPrimaryKey context = new RegionInRegionGroupPrimaryKey(parent, child);
            debug.event("remove", (Object)context);
            response = this.delete("CSGLCGCS", (IContext)context);
        } else if (modelName == "CICSRegionGroup") {
            RegionGroupInRegionGroupPrimaryKey context = new RegionGroupInRegionGroupPrimaryKey(parent, child);
            debug.event("remove", (Object)context);
            response = this.delete("CSGLCGCG", (IContext)context);
        } else if (IResourceTables.Helper.isCICSDefinition((String)resourceType)) {
            ResourcePrimaryKey resourceContext = new ResourcePrimaryKey(parent, resourceType, child);
            debug.event("remove", (Object)resourceContext);
            response = this.delete("RESINGRP", (IContext)resourceContext);
        } else {
            throw new UnsupportedOperationException(resourceType);
        }
        debug.exit("remove", (Object)response);
        return response;
    }

    public SMConnectionResponse install(String resourceType, IFilteredContext definition, IScopedContext target) throws ConnectionException {
        SMConnectionResponse response;
        debug.enter("install", (Object)this, (Object)resourceType, (Object)definition, (Object)target);
        if (resourceType == "RESGROUP") {
            response = this.installGroup(definition, target);
        } else {
            InstallAction action;
            if (this.isDefinitionFromCSD(definition)) {
                if (!target.getScope().equals(definition.getScope())) {
                    throw new InstallException("INSTALL", 1038, 1361, ErrorCodes.findErrorCodeByMnemonic((String)resourceType, (String)"INV_TSCOPE"), "NAME");
                }
                action = new InstallAction("CSDINSTALL", target);
            } else {
                action = new InstallAction(target);
            }
            response = this.perform(resourceType, (IContext)definition, (ICICSAction)action);
        }
        debug.exit("install", (Object)response);
        return response;
    }

    private boolean isDefinitionFromCSD(IFilteredContext definition) {
        return definition.getScope() != null;
    }

    public SMConnectionResponse installGroup(IFilteredContext group, IScopedContext target) throws ConnectionException {
        debug.enter("installGroup", (Object)this, (Object)group, (Object)target);
        SMConnectionResponse response = null;
        HashSet<String> resourceTypes = new HashSet<String>();
        SMConnectionResponse getResponse = this.getResources("RESINGRP", (IContext)group);
        int i = 0;
        while (i < getResponse.getRecordTotal()) {
            SMConnectionRecord record = getResponse.getRecord(i);
            String resourceType = record.get("DEFTYPE");
            resourceTypes.add(resourceType);
            ++i;
        }
        debug.event("installGroup", resourceTypes);
        if (resourceTypes.isEmpty()) {
            InstallAction action = new InstallAction(target);
            response = this.perform("RESGROUP", (IContext)group, (ICICSAction)action);
        } else {
            for (String resourceType : resourceTypes) {
                InstallAction action = new InstallAction(target, resourceType);
                response = this.perform("RESGROUP", (IContext)group, (ICICSAction)action);
            }
        }
        debug.exit("installGroup", (Object)response);
        return response;
    }

    public SMConnectionResponse perform(String resourceType, IContext context, ICICSAction action) throws ConnectionException {
        SMConnectionResponse smResponse;
        block27: {
            debug.enter("perform", (Object)this, (Object)resourceType, (Object)context, (Object)action);
            HttpURLConnection connection = null;
            String modelName = IModelNames.ModelNamesHelper.getModelName(resourceType);
            if (resourceType.equals("TSQNAME") | resourceType.equals("TSQSHR") && action == SystemManagerActions.Delete) {
                debug.enter("perform", (Object)this, (Object)resourceType, (Object)action);
                smResponse = this.getResources(resourceType, context);
                this.delete(resourceType, context);
            } else {
                try {
                    try {
                        IScopedContext scopedContext;
                        String criteria;
                        String request = "";
                        IContext parentContext = context;
                        String csdgroup = null;
                        if (context instanceof IFilteredContext) {
                            IFilteredContext filteredContext = (IFilteredContext)parentContext;
                            csdgroup = filteredContext.getAttributeValue("CSDGROUP");
                            criteria = this.getCriteriaFromFilteredContext(filteredContext);
                            if (criteria.length() > 0) {
                                request = String.valueOf(request) + "?CRITERIA=(" + criteria + ")";
                            }
                            parentContext = filteredContext.getParentContext();
                        } else if (context instanceof ICompoundFilteredContext) {
                            ICompoundFilteredContext compoundFilteredContext = (ICompoundFilteredContext)parentContext;
                            criteria = this.getCriteriaFromCompoundFilteredContext(compoundFilteredContext);
                            if (criteria.length() > 0) {
                                request = String.valueOf(request) + "?CRITERIA=(" + criteria + ")";
                            }
                            parentContext = compoundFilteredContext.getParentContext();
                        }
                        if (parentContext instanceof IScopedContext && IResourceTables.Helper.isCICSDefinition((String)resourceType)) {
                            scopedContext = (IScopedContext)parentContext;
                            if (scopedContext.getScope() != null) {
                                request = String.valueOf(request) + "&PARAMETER=CSDGROUP(" + (csdgroup != null && csdgroup.trim().length() > 0 ? csdgroup : "*") + ")";
                            }
                        } else if (parentContext instanceof IGroupContext && IResourceTables.Helper.isCICSDefinition((String)resourceType)) {
                            IGroupContext groupContext = (IGroupContext)parentContext;
                            String groupName = groupContext.getResourceGroup();
                            parentContext = groupContext.getParentContext();
                            if (groupName != null && parentContext instanceof IScopedContext) {
                                request = String.valueOf(request) + "&PARAMETER=CSDGROUP(" + URLEncoder.encode(groupName, "UTF-8") + ")";
                            }
                        }
                        if (parentContext instanceof IScopedContext) {
                            scopedContext = (IScopedContext)parentContext;
                            String scope = scopedContext.getScope();
                            if (scope == null) {
                                scope = "";
                            }
                            request = "/" + URLEncoder.encode(scope, "UTF-8") + request;
                        }
                        if (this.requiresWorkloadParameter(resourceType)) {
                            String workloadName = "*";
                            Object workloadContext = null;
                            if (parentContext instanceof IWorkloadContext) {
                                workloadName = ((IWorkloadContext)parentContext).getWorkloadName();
                            } else if (context instanceof IWorkloadContext) {
                                workloadName = ((IWorkloadContext)context).getWorkloadName();
                            }
                            debug.event("buildGETRequest", workloadContext, (Object)workloadName);
                            request = String.valueOf(request) + "&PARAMETER=WORKLOAD(" + URLEncoder.encode(workloadName, "UTF-8") + ")";
                        }
                        request = "/" + URLEncoder.encode(parentContext.getContext(), "UTF-8") + request;
                        URL url = this.createURL(FILE + modelName + request);
                        debug.event("perform", (Object)url);
                        connection = this.openConnection(url);
                        this.setAuthorization(connection);
                        connection.setDoOutput(true);
                        connection.setDoInput(true);
                        connection.setRequestMethod("PUT");
                        String payload = this.buildActionPayload(action);
                        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
                        writer.write(payload);
                        writer.flush();
                        writer.close();
                        int responseCode = connection.getResponseCode();
                        debug.event("perform", new Object[]{String.valueOf(connection.getResponseCode()), connection.getResponseMessage()});
                        if (responseCode == 200) {
                            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                            SMResponseHandler handler = new SMResponseHandler(resourceType, modelName, context, connection.getInputStream(), connection.getURL());
                            parser.parse(handler.getInputStream(), (DefaultHandler)handler);
                            smResponse = handler.getResponse();
                            break block27;
                        }
                        throw new SMConnectionException(url, connection.getResponseCode(), connection.getResponseMessage());
                    }
                    catch (IOException ex) {
                        debug.warning("perform", (Object)ex);
                        throw new SMConnectionException(ex);
                    }
                    catch (ParserConfigurationException ex) {
                        debug.warning("perform", (Object)ex);
                        throw new SMConnectionException(ex);
                    }
                    catch (SAXException ex) {
                        debug.warning("perform", (Object)ex);
                        throw new SMConnectionException(ex);
                    }
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
        }
        debug.exit("perform", (Object)smResponse);
        return smResponse;
    }

    private String buildActionPayload(ICICSAction action) {
        debug.enter("buildActionPayload", (Object)this, (Object)action);
        String payload = "<request><action name=\"" + action.getActionName() + "\">";
        for (String parameterName : action) {
            String parameterValue = action.getParameterValue(parameterName);
            payload = String.valueOf(payload) + "<parameter name=\"" + this.escapeXmlPayload(parameterName);
            if (parameterValue != null) {
                payload = String.valueOf(payload) + "\" value=\"" + this.escapeXmlPayload(parameterValue);
            }
            payload = String.valueOf(payload) + "\"/>";
        }
        payload = String.valueOf(payload) + "</action></request>";
        debug.exit("buildActionPayload", (Object)payload);
        return payload;
    }

    protected String getCriteriaFromCompoundFilteredContext(ICompoundFilteredContext compoundFilteredContext) throws UnsupportedEncodingException {
        debug.enter("getCriteriaFromCompoundFilteredContext", (Object)this, (Object)compoundFilteredContext);
        String compoundCriteria = "";
        for (IFilteredContext filteredContext : compoundFilteredContext) {
            String criteria;
            if (compoundCriteria.length() > 0) {
                compoundCriteria = String.valueOf(compoundCriteria) + "%20OR%20";
            }
            if ((criteria = this.getCriteriaFromFilteredContext(filteredContext)).length() <= 0) continue;
            compoundCriteria = String.valueOf(compoundCriteria) + "(" + criteria + ")";
        }
        debug.exit("getCriteriaFromCompoundFilteredContext", (Object)compoundCriteria);
        return compoundCriteria;
    }

    protected String getCriteriaFromFilteredContext(IFilteredContext filteredContext) throws UnsupportedEncodingException {
        String criteria = "";
        String equalsType = filteredContext instanceof IPrimaryKey ? "==" : "=";
        for (String name : filteredContext.getAttributeNames()) {
            String value = filteredContext.getAttributeValue(name);
            String criterion = "'" + value + "'";
            String fullString = String.valueOf(name) + equalsType + SMCPSMConnection.escape((String)criterion);
            if ("CSDGROUP==''".equals(fullString)) continue;
            if (criteria.length() > 0) {
                criteria = String.valueOf(criteria) + CRITERIA_AND;
            }
            criteria = String.valueOf(criteria) + "(" + fullString + ")";
        }
        return criteria;
    }

    private String getParametersFromParameterisedContext(IParameterisedContext parameterisedContext) throws UnsupportedEncodingException {
        String parameters = "";
        for (String name : parameterisedContext.getParameterNames()) {
            String value = parameterisedContext.getParameterValue(name);
            if (parameters.length() > 0) {
                parameters = String.valueOf(parameters) + ",";
            }
            String parameterValue = "(" + value + ")";
            parameters = String.valueOf(parameters) + name + SMCPSMConnection.escape((String)parameterValue);
        }
        return parameters;
    }

    protected void clearSupportedResources() {
        this.supportedResources.clear();
    }

    protected void addSupportedResource(String resource) {
        this.supportedResources.add(resource);
    }

    public List<IRepository> getRepositories() {
        return RepositoryDiscoverer.getRepositories((ISystemManagerConnection)this);
    }

    private static class ErrorHandler
    extends DefaultHandler {
        private String currentErrorInfoName;
        private final DebugInputStream debugInputStream;
        private String errorMessageId;
        private boolean defaultWarningCountExceeded;
        private int currentRecordCount = 0;
        private static final Debug debug = new Debug(ErrorHandler.class);

        public ErrorHandler(InputStream inputStream) {
            this.debugInputStream = new DebugInputStream(inputStream);
        }

        public InputStream getInputStream() {
            return this.debugInputStream;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("errorInfo")) {
                this.currentErrorInfoName = attributes.getValue("name");
            }
            if (name.equals("error")) {
                this.errorMessageId = attributes.getValue("message_id");
            }
        }

        private boolean isDefaultWarningCountExceeded() {
            return this.defaultWarningCountExceeded;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            if (this.currentErrorInfoName != null && this.currentErrorInfoName.equals("current_record_count")) {
                String s = new String(ch, start, length);
                this.currentRecordCount = Integer.valueOf(s);
                this.defaultWarningCountExceeded = true;
                this.errorMessageId = null;
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            super.endElement(uri, localName, name);
            this.currentErrorInfoName = null;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            debug.warning("error", (Object)e, (Object)this.debugInputStream.toString());
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            debug.warning("fatalError", (Object)e, (Object)this.debugInputStream.toString());
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
            debug.event("endDocument", this.debugInputStream.toString());
        }

        public int getCurrentRecordCount() {
            return this.currentRecordCount;
        }
    }

    private static final class GroupInListPrimaryKey
    extends AbstractFilteredContext {
        private static final String CSDINLIST_ATTRIBUTE_CSDLIST = "CSDLIST";
        private static final String CSDINLIST_ATTRIBUTE_CSDGROUP = "CSDGROUP";
        private final HashMap<String, String> attributes = new HashMap();

        public GroupInListPrimaryKey(IFilteredContext list, IFilteredContext group) {
            super((IContext)group);
            String listName = list.getAttributeValue("NAME");
            String groupName = group.getAttributeValue("NAME");
            this.attributes.put(CSDINLIST_ATTRIBUTE_CSDLIST, listName);
            this.attributes.put(CSDINLIST_ATTRIBUTE_CSDGROUP, groupName);
        }

        public Set getAttributeNames() {
            return this.attributes.keySet();
        }

        public String getAttributeValue(String attributeName) {
            return this.attributes.get(attributeName);
        }

        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + this.getContext() + "/" + this.attributes.values() + "]";
        }
    }

    private static final class GroupsInListFilteredContext
    implements IFilteredContext {
        private static final String CSDINLIST_ATTRIBUTE_CSDLIST = "CSDLIST";
        private final IScopedContext parentContext;
        private final HashMap<String, String> attributes = new HashMap();

        public GroupsInListFilteredContext(IAssociationContext list) {
            final IScopedContext scopedContext = (IScopedContext)list;
            this.parentContext = new IScopedContext(){

                public String getContext() {
                    return scopedContext.getContext();
                }

                public String getScope() {
                    return scopedContext.getScope();
                }
            };
            this.attributes.put(CSDINLIST_ATTRIBUTE_CSDLIST, list.getResourceName());
        }

        public Set getAttributeNames() {
            return this.attributes.keySet();
        }

        public String getAttributeValue(String attributeName) {
            return this.attributes.get(attributeName);
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "[" + this.getContext() + "/" + this.attributes.values() + "]";
        }

        public IContext getParentContext() {
            return this.parentContext;
        }

        public String getScope() {
            return this.parentContext.getScope();
        }

        public String getContext() {
            return this.parentContext.getContext();
        }
    }

    private static final class RegionGroupInRegionGroupPrimaryKey
    extends AbstractFilteredContext {
        private static final String CSGLCGCG_ATTRIBUTE_GROUP = "GROUP";
        private static final String CSGLCGCG_ATTRIBUTE_TOGROUP = "TOGROUP";
        private final HashMap<String, String> attributes = new HashMap();

        public RegionGroupInRegionGroupPrimaryKey(IFilteredContext parentRegionGroup, IFilteredContext regionGroup) {
            super(RegionGroupInRegionGroupPrimaryKey.getParentContext(parentRegionGroup));
            this.attributes.put(CSGLCGCG_ATTRIBUTE_TOGROUP, parentRegionGroup.getAttributeValue(CSGLCGCG_ATTRIBUTE_GROUP));
            this.attributes.put(CSGLCGCG_ATTRIBUTE_GROUP, regionGroup.getAttributeValue(CSGLCGCG_ATTRIBUTE_GROUP));
        }

        private static IContext getParentContext(final IFilteredContext list) {
            return new IContext(){

                public String getContext() {
                    return list.getContext();
                }
            };
        }

        public Set<String> getAttributeNames() {
            return this.attributes.keySet();
        }

        public String getAttributeValue(String attributeName) {
            return this.attributes.get(attributeName);
        }

        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + this.getContext() + "/" + this.attributes.values() + "]";
        }
    }

    private static final class RegionInRegionGroupPrimaryKey
    extends AbstractFilteredContext {
        private static final String CSGLCGCS_ATTRIBUTE_GROUP = "GROUP";
        private static final String CSGLCGCS_ATTRIBUTE_CICSNAME = "CICSNAME";
        private final HashMap<String, String> attributes = new HashMap();

        public RegionInRegionGroupPrimaryKey(IFilteredContext regionGroup, IFilteredContext region) {
            super(RegionInRegionGroupPrimaryKey.getParentContext(regionGroup));
            this.attributes.put(CSGLCGCS_ATTRIBUTE_GROUP, regionGroup.getAttributeValue(CSGLCGCS_ATTRIBUTE_GROUP));
            this.attributes.put(CSGLCGCS_ATTRIBUTE_CICSNAME, region.getAttributeValue("NAME"));
        }

        private static IContext getParentContext(final IFilteredContext list) {
            return new IContext(){

                public String getContext() {
                    return list.getContext();
                }
            };
        }

        public Set<String> getAttributeNames() {
            return this.attributes.keySet();
        }

        public String getAttributeValue(String attributeName) {
            return this.attributes.get(attributeName);
        }

        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + this.getContext() + "/" + this.attributes.values() + "]";
        }
    }

    private static final class ResourceGroupInResourceDescriptionPrimaryKey
    extends AbstractFilteredContext {
        private static final String RESINDSC_ATTRIBUTE_RESGROUP = "RESGROUP";
        private static final String RESINDSC_ATTRIBUTE_RESDESC = "RESDESC";
        private final HashMap<String, String> attributes = new HashMap();

        public ResourceGroupInResourceDescriptionPrimaryKey(IFilteredContext list, IFilteredContext group) {
            super(ResourceGroupInResourceDescriptionPrimaryKey.getParentContext(list));
            this.attributes.put(RESINDSC_ATTRIBUTE_RESDESC, list.getAttributeValue(RESINDSC_ATTRIBUTE_RESDESC));
            this.attributes.put(RESINDSC_ATTRIBUTE_RESGROUP, group.getAttributeValue(RESINDSC_ATTRIBUTE_RESGROUP));
        }

        private static IContext getParentContext(final IFilteredContext list) {
            return new IContext(){

                public String getContext() {
                    return list.getContext();
                }
            };
        }

        public Set<String> getAttributeNames() {
            return this.attributes.keySet();
        }

        public String getAttributeValue(String attributeName) {
            return this.attributes.get(attributeName);
        }

        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + this.getContext() + "/" + this.attributes.values() + "]";
        }
    }

    private static final class ResourcePrimaryKey
    extends AbstractFilteredContext {
        private static final String RESINGRP_ATTRIBUTE_RESGROUP = "RESGROUP";
        private final HashMap<String, String> attributes = new HashMap();

        public ResourcePrimaryKey(IContext context, String groupName, String definitionType, String definitionName, Long definitionVersion) {
            super(context);
            this.attributes.put(RESINGRP_ATTRIBUTE_RESGROUP, groupName);
            this.attributes.put("DEFTYPE", definitionType);
            this.attributes.put("DEFNAME", definitionName);
            this.attributes.put("DEFVER", String.valueOf(definitionVersion));
        }

        public ResourcePrimaryKey(IFilteredContext group, String definitionType, IFilteredContext definition) {
            super((IContext)group);
            String groupName = group.getAttributeValue(RESINGRP_ATTRIBUTE_RESGROUP);
            String definitionName = definition.getAttributeValue("NAME");
            String definitionVersion = definition.getAttributeValue("DEFVER");
            this.attributes.put(RESINGRP_ATTRIBUTE_RESGROUP, groupName);
            this.attributes.put("DEFTYPE", definitionType);
            this.attributes.put("DEFNAME", definitionName);
            this.attributes.put("DEFVER", definitionVersion);
        }

        public Set getAttributeNames() {
            return this.attributes.keySet();
        }

        public String getAttributeValue(String attributeName) {
            return this.attributes.get(attributeName);
        }

        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + this.getContext() + "/" + this.attributes.values() + "]";
        }
    }
}

