/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.LibraryReference;
import com.ibm.cics.core.model.LibraryType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ILibrary;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableLibrary;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableLibrary
extends MutableCICSResource
implements IMutableLibrary {
    private ILibrary delegate;
    private MutableSMRecord record;

    public MutableLibrary(ICPSM cpsm, IContext context, ILibrary cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("LIBRARY");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public Long getRanking() {
        String result = this.record.get("RANKING");
        if (result == null) {
            return this.delegate.getRanking();
        }
        return (Long)((CICSAttribute)LibraryType.RANKING).get(result, this.record.getNormalizers());
    }

    public ILibrary.CriticalStatusValue getCriticalStatus() {
        String result = this.record.get("CRITSTATUS");
        if (result == null) {
            return this.delegate.getCriticalStatus();
        }
        return (ILibrary.CriticalStatusValue)((CICSAttribute)LibraryType.CRITICAL_STATUS).get(result, this.record.getNormalizers());
    }

    public ILibrary.EnableStatusValue getEnableStatus() {
        String result = this.record.get("ENABLESTATUS");
        if (result == null) {
            return this.delegate.getEnableStatus();
        }
        return (ILibrary.EnableStatusValue)((CICSAttribute)LibraryType.ENABLE_STATUS).get(result, this.record.getNormalizers());
    }

    public Long getNumdsnames() {
        return this.delegate.getNumdsnames();
    }

    public Long getSearchPosition() {
        return this.delegate.getSearchPosition();
    }

    public Long getPgmloadcnt() {
        return this.delegate.getPgmloadcnt();
    }

    public String getChangeUserID() {
        return this.delegate.getChangeUserID();
    }

    public ILibrary.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getChangeAgentRelease() {
        return this.delegate.getChangeAgentRelease();
    }

    public Date getChangeTime() {
        return this.delegate.getChangeTime();
    }

    public String getDefineSource() {
        return this.delegate.getDefineSource();
    }

    public Date getDefineTime() {
        return this.delegate.getDefineTime();
    }

    public String getInstallUserID() {
        return this.delegate.getInstallUserID();
    }

    public Date getInstallTime() {
        return this.delegate.getInstallTime();
    }

    public ILibrary.InstallAgentValue getInstallAgent() {
        return this.delegate.getInstallAgent();
    }

    public Long getBasdefinever() {
        return this.delegate.getBasdefinever();
    }

    public void setRanking(Long _ranking) {
        if (_ranking.equals(this.delegate.getRanking())) {
            this.record.set("RANKING", null);
        } else {
            LibraryType.RANKING.validate((Object)_ranking);
            String connectionSpecificExternalValue = ((CICSAttribute)LibraryType.RANKING).set(_ranking, this.record.getNormalizers());
            this.record.set("RANKING", connectionSpecificExternalValue);
        }
    }

    public void setCriticalStatus(ILibrary.CriticalStatusValue _criticalStatus) {
        if (_criticalStatus.equals((Object)this.delegate.getCriticalStatus())) {
            this.record.set("CRITSTATUS", null);
        } else {
            LibraryType.CRITICAL_STATUS.validate((Object)_criticalStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)LibraryType.CRITICAL_STATUS).set(_criticalStatus, this.record.getNormalizers());
            this.record.set("CRITSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setEnableStatus(ILibrary.EnableStatusValue _enableStatus) {
        if (_enableStatus.equals((Object)this.delegate.getEnableStatus())) {
            this.record.set("ENABLESTATUS", null);
        } else {
            LibraryType.ENABLE_STATUS.validate((Object)_enableStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)LibraryType.ENABLE_STATUS).set(_enableStatus, this.record.getNormalizers());
            this.record.set("ENABLESTATUS", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == LibraryType.NAME) {
            return (V)this.getName();
        }
        if (attribute == LibraryType.RANKING) {
            return (V)this.getRanking();
        }
        if (attribute == LibraryType.CRITICAL_STATUS) {
            return (V)this.getCriticalStatus();
        }
        if (attribute == LibraryType.ENABLE_STATUS) {
            return (V)this.getEnableStatus();
        }
        if (attribute == LibraryType.NUMDSNAMES) {
            return (V)this.getNumdsnames();
        }
        if (attribute == LibraryType.SEARCH_POSITION) {
            return (V)this.getSearchPosition();
        }
        if (attribute == LibraryType.PGMLOADCNT) {
            return (V)this.getPgmloadcnt();
        }
        if (attribute == LibraryType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == LibraryType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == LibraryType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == LibraryType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == LibraryType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == LibraryType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == LibraryType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == LibraryType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == LibraryType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == LibraryType.BASDEFINEVER) {
            return (V)this.getBasdefinever();
        }
        return super.getAttributeValue(attribute);
    }

    public LibraryType getObjectType() {
        return LibraryType.getInstance();
    }

    @Override
    public LibraryReference getCICSObjectReference() {
        return new LibraryReference(this.getCICSContainer(), this.getName());
    }
}

