/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.TransactionDumpReference;
import com.ibm.cics.core.model.TransactionDumpType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ITransactionDump;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableTransactionDump;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableTransactionDump
extends MutableCICSResource
implements IMutableTransactionDump {
    private ITransactionDump delegate;
    private MutableSMRecord record;

    public MutableTransactionDump(ICPSM cpsm, IContext context, ITransactionDump cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("TRANDUMP");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public String getTransactionDumpCode() {
        return this.delegate.getTransactionDumpCode();
    }

    public Long getTransactionDumpsSinceReset() {
        return this.delegate.getTransactionDumpsSinceReset();
    }

    public Long getMaximumTransactionDumps() {
        String result = this.record.get("MAXIMUM");
        if (result == null) {
            return this.delegate.getMaximumTransactionDumps();
        }
        return (Long)((CICSAttribute)TransactionDumpType.MAXIMUM_TRANSACTION_DUMPS).get(result, this.record.getNormalizers());
    }

    public ITransactionDump.ShutdownOptionValue getShutdownOption() {
        String result = this.record.get("SHUTOPTION");
        if (result == null) {
            return this.delegate.getShutdownOption();
        }
        return (ITransactionDump.ShutdownOptionValue)((CICSAttribute)TransactionDumpType.SHUTDOWN_OPTION).get(result, this.record.getNormalizers());
    }

    public ITransactionDump.SystemDumpOptionValue getSystemDumpOption() {
        String result = this.record.get("SYSDUMPING");
        if (result == null) {
            return this.delegate.getSystemDumpOption();
        }
        return (ITransactionDump.SystemDumpOptionValue)((CICSAttribute)TransactionDumpType.SYSTEM_DUMP_OPTION).get(result, this.record.getNormalizers());
    }

    public ITransactionDump.TransactionDumpOptionValue getTransactionDumpOption() {
        String result = this.record.get("TRANDUMPING");
        if (result == null) {
            return this.delegate.getTransactionDumpOption();
        }
        return (ITransactionDump.TransactionDumpOptionValue)((CICSAttribute)TransactionDumpType.TRANSACTION_DUMP_OPTION).get(result, this.record.getNormalizers());
    }

    public Long getTransactionDumpsTaken() {
        return this.delegate.getTransactionDumpsTaken();
    }

    public Long getTransactionDumpsSuppressed() {
        return this.delegate.getTransactionDumpsSuppressed();
    }

    public Long getSystemDumpsTaken() {
        return this.delegate.getSystemDumpsTaken();
    }

    public Long getSystemDumpsSuppressed() {
        return this.delegate.getSystemDumpsSuppressed();
    }

    public ITransactionDump.TransactionDumpScopeValue getTransactionDumpScope() {
        String result = this.record.get("TDUMPSCOPE");
        if (result == null) {
            return this.delegate.getTransactionDumpScope();
        }
        return (ITransactionDump.TransactionDumpScopeValue)((CICSAttribute)TransactionDumpType.TRANSACTION_DUMP_SCOPE).get(result, this.record.getNormalizers());
    }

    public void setMaximumTransactionDumps(Long _maximumTransactionDumps) {
        if (_maximumTransactionDumps.equals(this.delegate.getMaximumTransactionDumps())) {
            this.record.set("MAXIMUM", null);
        } else {
            TransactionDumpType.MAXIMUM_TRANSACTION_DUMPS.validate((Object)_maximumTransactionDumps);
            String connectionSpecificExternalValue = ((CICSAttribute)TransactionDumpType.MAXIMUM_TRANSACTION_DUMPS).set(_maximumTransactionDumps, this.record.getNormalizers());
            this.record.set("MAXIMUM", connectionSpecificExternalValue);
        }
    }

    public void setShutdownOption(ITransactionDump.ShutdownOptionValue _shutdownOption) {
        if (_shutdownOption.equals((Object)this.delegate.getShutdownOption())) {
            this.record.set("SHUTOPTION", null);
        } else {
            TransactionDumpType.SHUTDOWN_OPTION.validate((Object)_shutdownOption);
            String connectionSpecificExternalValue = ((CICSAttribute)TransactionDumpType.SHUTDOWN_OPTION).set(_shutdownOption, this.record.getNormalizers());
            this.record.set("SHUTOPTION", connectionSpecificExternalValue);
        }
    }

    public void setSystemDumpOption(ITransactionDump.SystemDumpOptionValue _systemDumpOption) {
        if (_systemDumpOption.equals((Object)this.delegate.getSystemDumpOption())) {
            this.record.set("SYSDUMPING", null);
        } else {
            TransactionDumpType.SYSTEM_DUMP_OPTION.validate((Object)_systemDumpOption);
            String connectionSpecificExternalValue = ((CICSAttribute)TransactionDumpType.SYSTEM_DUMP_OPTION).set(_systemDumpOption, this.record.getNormalizers());
            this.record.set("SYSDUMPING", connectionSpecificExternalValue);
        }
    }

    public void setTransactionDumpOption(ITransactionDump.TransactionDumpOptionValue _transactionDumpOption) {
        if (_transactionDumpOption.equals((Object)this.delegate.getTransactionDumpOption())) {
            this.record.set("TRANDUMPING", null);
        } else {
            TransactionDumpType.TRANSACTION_DUMP_OPTION.validate((Object)_transactionDumpOption);
            String connectionSpecificExternalValue = ((CICSAttribute)TransactionDumpType.TRANSACTION_DUMP_OPTION).set(_transactionDumpOption, this.record.getNormalizers());
            this.record.set("TRANDUMPING", connectionSpecificExternalValue);
        }
    }

    public void setTransactionDumpScope(ITransactionDump.TransactionDumpScopeValue _transactionDumpScope) {
        if (_transactionDumpScope.equals((Object)this.delegate.getTransactionDumpScope())) {
            this.record.set("TDUMPSCOPE", null);
        } else {
            TransactionDumpType.TRANSACTION_DUMP_SCOPE.validate((Object)_transactionDumpScope);
            String connectionSpecificExternalValue = ((CICSAttribute)TransactionDumpType.TRANSACTION_DUMP_SCOPE).set(_transactionDumpScope, this.record.getNormalizers());
            this.record.set("TDUMPSCOPE", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == TransactionDumpType.TRANSACTION_DUMP_CODE) {
            return (V)this.getTransactionDumpCode();
        }
        if (attribute == TransactionDumpType.TRANSACTION_DUMPS_SINCE_RESET) {
            return (V)this.getTransactionDumpsSinceReset();
        }
        if (attribute == TransactionDumpType.MAXIMUM_TRANSACTION_DUMPS) {
            return (V)this.getMaximumTransactionDumps();
        }
        if (attribute == TransactionDumpType.SHUTDOWN_OPTION) {
            return (V)this.getShutdownOption();
        }
        if (attribute == TransactionDumpType.SYSTEM_DUMP_OPTION) {
            return (V)this.getSystemDumpOption();
        }
        if (attribute == TransactionDumpType.TRANSACTION_DUMP_OPTION) {
            return (V)this.getTransactionDumpOption();
        }
        if (attribute == TransactionDumpType.TRANSACTION_DUMPS_TAKEN) {
            return (V)this.getTransactionDumpsTaken();
        }
        if (attribute == TransactionDumpType.TRANSACTION_DUMPS_SUPPRESSED) {
            return (V)this.getTransactionDumpsSuppressed();
        }
        if (attribute == TransactionDumpType.SYSTEM_DUMPS_TAKEN) {
            return (V)this.getSystemDumpsTaken();
        }
        if (attribute == TransactionDumpType.SYSTEM_DUMPS_SUPPRESSED) {
            return (V)this.getSystemDumpsSuppressed();
        }
        if (attribute == TransactionDumpType.TRANSACTION_DUMP_SCOPE) {
            return (V)this.getTransactionDumpScope();
        }
        return super.getAttributeValue(attribute);
    }

    public TransactionDumpType getObjectType() {
        return TransactionDumpType.getInstance();
    }

    @Override
    public TransactionDumpReference getCICSObjectReference() {
        return new TransactionDumpReference(this.getCICSContainer(), this.getTransactionDumpCode());
    }
}

