/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.adapters;

import com.ibm.cics.core.model.ActiveWorkloadDefinitionType;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.extra.IAdaptableTreeNode;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.adapters.WLMAbstractRuleRelatedAdapter;
import com.ibm.cics.core.ui.adapters.WLMDefaultRoutingAdapter;
import com.ibm.cics.core.ui.adapters.WLMRuleAdapter;
import com.ibm.cics.core.ui.internal.cloud.ErrorWrapper;
import com.ibm.cics.model.AttributeValue;
import com.ibm.cics.model.IActiveWorkloadDefinition;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IWorkload;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class WLMRoutingRulesAdapter
implements IAdaptableTreeNode,
IAdaptable,
IDeferredWorkbenchAdapter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IWorkload activeWorkload;

    public WLMRoutingRulesAdapter(IWorkload wlmActiveWorkload) {
        this.activeWorkload = wlmActiveWorkload;
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        collector.add(this.getChildren(object), monitor);
    }

    public Object[] getChildren(Object o) {
        Object[] rulesForWorkload = this.getRulesForWorkload(this.activeWorkload);
        ArrayList<Object> children = new ArrayList<Object>();
        children.add(new WLMDefaultRoutingAdapter(this.activeWorkload));
        Object[] objectArray = rulesForWorkload;
        int n = rulesForWorkload.length;
        int n2 = 0;
        while (n2 < n) {
            Object oRule = objectArray[n2];
            if (oRule instanceof IActiveWorkloadDefinition) {
                children.add(new WLMRuleAdapter(this.activeWorkload, (IActiveWorkloadDefinition)oRule));
            } else {
                children.add(oRule);
            }
            ++n2;
        }
        Object[] sortedChildren = children.toArray();
        Arrays.sort(sortedChildren, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int cat2;
                int cat1 = this.category(o1);
                if (cat1 != (cat2 = this.category(o2))) {
                    return cat1 - cat2;
                }
                String desc1 = ((WLMRuleAdapter)o1).getLabel(o1);
                String desc2 = ((WLMRuleAdapter)o2).getLabel(o2);
                return desc1.compareTo(desc2);
            }

            public int category(Object element) {
                if (element instanceof WLMDefaultRoutingAdapter) {
                    return 0;
                }
                if (element instanceof WLMRuleAdapter) {
                    if (!((WLMRuleAdapter)element).getLabel(element).startsWith("$")) {
                        return 1;
                    }
                    return 2;
                }
                return 3;
            }
        });
        return sortedChildren;
    }

    private Object[] getRulesForWorkload(IWorkload activeWorkload) {
        Object[] activeWorkloadDefinitions;
        block2: {
            ICPSM cpsm = WLMAbstractRuleRelatedAdapter.getWorkloadCPSM(activeWorkload);
            Context context = WLMAbstractRuleRelatedAdapter.getWorkloadBaseContext(activeWorkload);
            FilteredContext filteredContext = new FilteredContext((IContext)context, new AttributeValue[]{new AttributeValue(ActiveWorkloadDefinitionType.WORKLOAD, (Object)activeWorkload.getName())});
            activeWorkloadDefinitions = new ICICSObject[]{};
            try {
                activeWorkloadDefinitions = cpsm.getDefinitions2((ICICSType)ActiveWorkloadDefinitionType.getInstance(), (IContext)filteredContext);
            }
            catch (CICSSystemManagerException e) {
                if (e.getCause() == null || e.getCause() instanceof SystemManagerConnectionException) break block2;
                return new Object[]{new ErrorWrapper(e.getCause())};
            }
        }
        return activeWorkloadDefinitions;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
    }

    public String getLabel(Object o) {
        return Messages.getString("WLMRoutingRulesAdapter.routingRules0");
    }

    public Object getParent(Object o) {
        return null;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public Object getAdapter(Class adapterType) {
        Object adapter = null;
        if (adapterType == IPropertySourceProvider.class) {
            adapter = new IPropertySourceProvider(){

                public IPropertySource getPropertySource(Object object) {
                    return null;
                }
            };
        } else if (adapterType == IWorkbenchAdapter.class) {
            adapter = this;
        }
        return adapter;
    }

    public ICPSM getCPSM() {
        return null;
    }
}

