/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.properties;

import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.properties.CICSAttributeLabelProvider;
import com.ibm.cics.model.ICICSAttribute;
import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Image;

public class CICSAttributeDecoratedLabelProvider
extends CICSAttributeLabelProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Logger logger = Logger.getLogger("com.ibm.cics.core.ui");
    private static final long Bytes = 0L;
    private static final long Kilobytes = 1024L;
    private static final long Megabytes = 0x100000L;
    private static final long Gigabytes = 0x40000000L;
    private static final long Terabytes = 0x10000000000L;
    private static final long Petabytes = 0x4000000000000L;
    private static Map<Long, String> unitsToDescriptions = new LinkedHashMap<Long, String>();

    static {
        unitsToDescriptions.put(0x4000000000000L, "PB");
        unitsToDescriptions.put(0x10000000000L, "TB");
        unitsToDescriptions.put(0x40000000L, "GB");
        unitsToDescriptions.put(0x100000L, "MB");
        unitsToDescriptions.put(1024L, "KB");
        unitsToDescriptions.put(0L, "B");
    }

    public CICSAttributeDecoratedLabelProvider(ICICSAttribute<?> cicsAttribute) {
        super(cicsAttribute);
    }

    public static String toByteString(long value) {
        if (value < 0L) {
            logger.log(Level.WARNING, "Unexpected situation - received negative value", value);
            return String.valueOf(value);
        }
        for (Map.Entry<Long, String> byteUnit : unitsToDescriptions.entrySet()) {
            if (value < byteUnit.getKey()) continue;
            return CICSAttributeDecoratedLabelProvider.format(value, byteUnit.getKey(), byteUnit.getValue());
        }
        return String.valueOf(value);
    }

    private static String format(long value, long byteUnit, String unitDescription) {
        double result = byteUnit > 1L ? (double)value / (double)byteUnit : (double)value;
        return String.valueOf(new DecimalFormat("#,##0.#").format(result)) + " " + unitDescription;
    }

    @Override
    public String getText(Object element) {
        if (this.cicsAttribute.getUnsupportedValue() == element) {
            return "N/A";
        }
        if (this.cicsAttribute.getUnexpectedValue() == element) {
            return "?";
        }
        if (this.isASpecialValue(element)) {
            return super.getText(element);
        }
        if (element instanceof Long) {
            return CICSAttributeDecoratedLabelProvider.toByteString((Long)element);
        }
        return super.getText(element);
    }

    private boolean isASpecialValue(Object element) {
        Map specialValues = this.cicsAttribute.getValuesHint().getSpecialValues();
        if (specialValues != null) {
            for (Long value : specialValues.values()) {
                if (!element.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Image getImage(Object element) {
        if (element != null) {
            return UIPlugin.getImage(element.toString());
        }
        return UIPlugin.getImage(UIPlugin.ERROR);
    }
}

