/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.properties;

import com.ibm.cics.core.ui.properties.ICICSObjectPropertyDescriptor;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IllegalCICSAttributeException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;

public class CICSAttributeDescriptor<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ICICSObjectPropertyDescriptor propertyDescriptor;
    private ICICSAttribute<T> attribute;
    private final ICICSType<?> type;

    public CICSAttributeDescriptor(ICICSAttribute<T> attribute, ICICSType<?> type, ICICSObjectPropertyDescriptor propertyDescriptor) {
        this.attribute = attribute;
        this.type = type;
        this.propertyDescriptor = propertyDescriptor;
    }

    public String getDescription() {
        return this.propertyDescriptor.getDescription();
    }

    public String getDisplayName() {
        return this.propertyDescriptor.getDisplayName();
    }

    public ICICSAttribute<T> getAttribute() {
        return this.attribute;
    }

    public ICICSType<?> getType() {
        return this.type;
    }

    public String getHelpContextId() {
        return (String)this.propertyDescriptor.getHelpContextIds();
    }

    public String getCategory() {
        return this.propertyDescriptor.getCategory();
    }

    public ILabelProvider getLabelProvider() {
        return this.propertyDescriptor.getLabelProvider();
    }

    public CellEditor createAttributeCellEditor(Composite parent) {
        return this.propertyDescriptor.createPropertyEditor(parent);
    }

    public void validate(Object value) throws IllegalCICSAttributeException {
        this.attribute.validate(value);
    }
}

