/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.viewers;

import com.ibm.cics.core.model.IModelListener;
import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.views.ResourcesView;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.logging.Logger;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public abstract class AbstractResourcesViewContentProvider
implements ILazyContentProvider,
IModelListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    final TableViewer tableViewer;
    protected final ResourcesView view;
    protected int lastTopIndex = -1;
    protected DateFormat dateTimeFormat = SimpleDateFormat.getDateTimeInstance();
    private static final Logger logger = Logger.getLogger(AbstractResourcesViewContentProvider.class.getPackage().getName());

    public AbstractResourcesViewContentProvider(TableViewer tableViewer, ResourcesView resourcesView) {
        this.tableViewer = tableViewer;
        this.view = resourcesView;
    }

    void refreshViewer() {
        this.lastTopIndex = -1;
        this.tableViewer.refresh();
        this.refreshSelection();
    }

    void refreshSelection() {
        ISelection selection = this.tableViewer.getSelection();
        Debug.event((Logger)logger, (String)AbstractResourcesViewContentProvider.class.getName(), (String)"refreshSelection", (Object)this, (Object)selection);
        if (!selection.isEmpty()) {
            this.tableViewer.setSelection(selection);
        }
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)AbstractResourcesViewContentProvider.class.getName(), (String)"dispose", (Object)this);
    }

    protected void schedule(Job job) {
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.view.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(job, 0L, true);
    }

    public void exceptionOccured(Exception exception) {
        Debug.enter((Logger)logger, (String)AbstractResourcesViewContentProvider.class.getName(), (String)"exceptionOccured", (Object)this, (Object)exception);
        final String message = this.createErrorMessage(exception);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                UIPlugin.logWarning(message);
                IStatusLineManager statusLine = AbstractResourcesViewContentProvider.this.view.getViewSite().getActionBars().getStatusLineManager();
                statusLine.setErrorMessage(null);
                statusLine.setErrorMessage(UIPlugin.getImage(UIPlugin.IMGD_ERROR), message);
                AbstractResourcesViewContentProvider.this.view.setContentDescription(message);
            }
        });
        Debug.exit((Logger)logger, (String)AbstractResourcesViewContentProvider.class.getName(), (String)"exceptionOccured");
    }

    protected int getPageSize() {
        Table table = this.tableViewer.getTable();
        int height = table.getSize().y;
        int itemHeight = table.getItemHeight();
        return (height + itemHeight - 1) / itemHeight;
    }

    protected abstract String createErrorMessage(Exception var1);

    public abstract void refresh();

    public String toString() {
        return this.getClass().getName();
    }
}

