/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.WorkloadType;
import com.ibm.cics.core.ui.views.IDefaultColumnsProvider;
import com.ibm.cics.core.ui.views.IElementTypeService;
import com.ibm.cics.core.ui.views.ResourcesTable;
import com.ibm.cics.core.ui.views.ResourcesView;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class WorkloadsView
extends ResourcesView {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(WorkloadsView.class);

    public WorkloadsView() {
        super((ICICSType<?>)WorkloadType.getInstance());
    }

    @Override
    protected String getHelpContextId() {
        return "com.ibm.cics.core.ui.view_wlmActiveWorkloads";
    }

    @Override
    protected List<ICICSAttribute<?>> getDefaultColumns() {
        return Arrays.asList(WorkloadType.NAME, WorkloadType.OWNING_SYSTEM_ID, WorkloadType.ACTIVE_ROUTING_REGIONS, WorkloadType.ACTIVE_TARGET_REGIONS, WorkloadType.DEFAULT_AFFINITY_TYPE, WorkloadType.DEFAULT_AFFINITY_LIFETIME, WorkloadType.DEFAULT_TARGET_SCOPE, WorkloadType.EVENT_NAME, WorkloadType.WORKLOAD_STATUS, WorkloadType.AUTOMATIC_AFFINITY_CREATION, WorkloadType.ALGORITHM_TYPE, WorkloadType.DESCRIPTION, WorkloadType.SHARED);
    }

    @Override
    protected ResourcesTable createResourcesTable(IElementTypeService elementTypeService, IDefaultColumnsProvider defaultColumnsProvider, String connectionCategoryId, boolean multiSelect) {
        return new ResourcesTable(elementTypeService, defaultColumnsProvider, connectionCategoryId, multiSelect){

            @Override
            protected void performDefaultViewAction(ICICSObject aCICSObject) {
                IActionFilter actionFilter = (IActionFilter)Platform.getAdapterManager().getAdapter((Object)aCICSObject, IActionFilter.class);
                if (actionFilter != null && actionFilter.testAttribute((Object)aCICSObject, "mutable", "true")) {
                    try {
                        Bundle editorsBundle = Platform.getBundle((String)"com.ibm.cics.core.ui.editors");
                        Class editAction = editorsBundle.loadClass("com.ibm.cics.core.ui.editors.actions.EditRoutingRuleAction");
                        IObjectActionDelegate editResourceDefinitionAction = (IObjectActionDelegate)editAction.newInstance();
                        editResourceDefinitionAction.setActivePart(null, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
                        editResourceDefinitionAction.selectionChanged(null, (ISelection)new StructuredSelection((Object)aCICSObject));
                        editResourceDefinitionAction.run(null);
                    }
                    catch (Exception ex) {
                        debug.error("createResourcesTable", (Throwable)ex);
                    }
                }
            }
        };
    }
}

