/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.decorators;

import com.ibm.cics.core.model.CICSRegionGroupDefinitionType;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.IContextProvider;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.PlatformType;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSRegionDefinition;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IResourceDescriptionDefinition;
import com.ibm.cics.model.IResourceGroupDefinition;
import com.ibm.cics.sm.comm.IContext;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class DescribableLabelDecorator
implements ILightweightLabelDecorator {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void decorate(Object element, IDecoration decoration) {
        String description;
        ICICSRegionDefinition definition;
        if (element instanceof ICICSRegionDefinition) {
            definition = (ICICSRegionDefinition)element;
            description = definition.getDescription();
        } else if (element instanceof ICICSRegionGroupDefinition) {
            definition = (ICICSRegionGroupDefinition)element;
            description = definition.getDescription();
            String platformName = definition.getPlatdef();
            if (platformName != null && platformName.trim().length() > 0 && !platformName.equals(CICSRegionGroupDefinitionType.PLATDEF.getUnsupportedValue())) {
                platformName = this.lookupFullPlatformName(((ICoreObject)definition).getCPSM(), ((IContextProvider)definition).getIContext().getContext(), platformName);
                String regionType = definition.getRegiontype();
                description = regionType != null && regionType.trim().length() > 0 && !regionType.equals(CICSRegionGroupDefinitionType.REGIONTYPE.getUnsupportedValue()) ? String.valueOf(platformName) + "/" + regionType : platformName;
                decoration.addOverlay(UIPlugin.IMGD_CSYSGRP_PLATFROM, 3);
            }
        } else if (element instanceof IResourceDescriptionDefinition) {
            definition = (IResourceDescriptionDefinition)element;
            description = definition.getDescription();
        } else if (element instanceof IResourceGroupDefinition) {
            definition = (IResourceGroupDefinition)element;
            description = definition.getDescription();
        } else {
            description = null;
        }
        if (description != null && description != "FORCE_ATTRIBUTE_UNSUPPORTED" && description.trim().length() > 0) {
            String suffix = " (" + description + ")";
            decoration.addSuffix(suffix);
        }
    }

    private String lookupFullPlatformName(ICPSM cpsm, String context, String platdefName) {
        String result = platdefName;
        FilteredContext filteredContext = new FilteredContext((IContext)new Context(context));
        filteredContext.setAttributeValue(PlatformType.PLATFORM_DEFINITION_NAME, (Object)platdefName);
        try {
            ICICSObject[] platforms = cpsm.getDefinitions2((ICICSType)PlatformType.getInstance(), (IContext)filteredContext);
            if (platforms.length == 1) {
                result = platforms[0].getName();
            }
        }
        catch (CICSSystemManagerException cICSSystemManagerException) {}
        return result;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

