/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.ApplicationType;
import com.ibm.cics.core.model.PlatformType;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public enum HierarchyStyle {
    PLATFORM((ICICSType<? extends ICICSObject>)PlatformType.getInstance()),
    APPLICATION((ICICSType<? extends ICICSObject>)ApplicationType.getInstance());

    private ICICSType<? extends ICICSObject> type;
    private final ImageDescriptor img;
    private static final Debug DEBUG;

    static {
        DEBUG = new Debug(HierarchyStyle.class);
    }

    private HierarchyStyle(ICICSType<? extends ICICSObject> type) {
        this.type = type;
        this.img = ImageDescriptor.createFromImage((Image)UIPlugin.getTableImage(type.getResourceTableName()));
    }

    public ICICSType<? extends ICICSObject> getType() {
        return this.type;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.img;
    }

    public static HierarchyStyle getPreferenceHierarchyStyle(boolean fallback) {
        HierarchyStyle prefHierarchyStyle;
        IEclipsePreferences prefs = UIPlugin.getPluginInstancePreferences();
        HierarchyStyle hierarchyStyle = prefHierarchyStyle = fallback ? PLATFORM : null;
        if (prefs != null) {
            String hierarchyStylePreference = prefs.get("cloudExplorerHierarchy", PLATFORM.name());
            try {
                prefHierarchyStyle = HierarchyStyle.valueOf(hierarchyStylePreference);
            }
            catch (IllegalArgumentException e) {
                DEBUG.error("showViewer", "Unable to parse preference as a hierarchy style", (Throwable)e);
            }
        }
        return prefHierarchyStyle;
    }
}

