/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.properties;

import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.properties.CICSObjectCellEditorValidator;
import com.ibm.cics.core.ui.properties.CICSObjectPropertyDescriptor;
import com.ibm.cics.core.ui.properties.IDescriptionProvider;
import com.ibm.cics.core.ui.properties.internal.CICSTextCellEditor;
import com.ibm.cics.core.ui.properties.internal.EnumCellEditor;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSEnum;
import com.ibm.cics.model.ICICSType;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;

public class MutableCICSObjectPropertyDescriptor
extends CICSObjectPropertyDescriptor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(MutableCICSObjectPropertyDescriptor.class.getPackage().getName());
    private boolean mutable;

    public MutableCICSObjectPropertyDescriptor(ICICSType cicsType, ICICSAttribute<?> cicsAttribute, String simpleClassName, IDescriptionProvider descriptionProvider, boolean mutable) {
        super(cicsType, cicsAttribute, simpleClassName, descriptionProvider);
        this.mutable = mutable;
    }

    @Override
    public CellEditor createPropertyEditor(Composite parent) {
        Object cellEditor;
        if (Debug.DEBUG_PROPERTIES) {
            Debug.enter((Logger)logger, (String)MutableCICSObjectPropertyDescriptor.class.getName(), (String)"createPropertyEditor", (Object)(this + ", parent=" + parent));
        }
        Class attributeType = this.getAttribute().getType();
        if (this.mutable) {
            cellEditor = ICICSEnum.class.isAssignableFrom(attributeType) ? EnumCellEditor.newInstance(parent, this.getAttribute()) : new CICSTextCellEditor(parent, this.getAttribute());
            cellEditor.setValidator(new CICSObjectCellEditorValidator(this.getAttribute()));
        } else {
            cellEditor = null;
        }
        if (Debug.DEBUG_PROPERTIES) {
            Debug.exit((Logger)logger, (String)MutableCICSObjectPropertyDescriptor.class.getName(), (String)"createPropertyEditor", (Object)cellEditor);
        }
        return cellEditor;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }
}

