/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.table;

import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.views.ResourcesViewColumnDialog;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ColumnSelectionDialog
extends TrayDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String PROPERTY_DESCRIPTOR = "PROPERTY_DESCRIPTOR";
    private static final String DIALOG_HELP_CONTEXT_ID = "com.ibm.cics.core.ui.dialog_ResourcesViewColumnDialog";
    private static final int RESET = 12345;
    private Button addButton;
    private Button removeButton;
    static final String X_LOCATION = "ResourcesView.customizeColumns.dialog.x_location";
    static final String Y_LOCATION = "ResourcesView.customizeColumns.dialog.y_location";
    static final String WIDTH = "ResourcesView.customizeColumns.dialog.width";
    static final String HEIGHT = "ResourcesView.customizeColumns.dialog.height";
    TableViewer availablePropertiesTableViewer;
    TableViewer displayedPropertiesTableViewer;
    private static final Logger logger = Logger.getLogger(ResourcesViewColumnDialog.class.getPackage().getName());
    private final String viewTitle;
    private final ILabelProvider labelProvider;
    private final PropertyManager<?> propertyManager;

    public static <T> ColumnSelectionDialog create(Shell parent, String viewTitle, Set<T> available, List<T> displayed, List<T> defaults, ILabelProvider labelProvider) {
        return new ColumnSelectionDialog(parent, viewTitle, new PropertyManager<T>(available, displayed, defaults), labelProvider);
    }

    private ColumnSelectionDialog(Shell parentShell, String viewTitle, PropertyManager<?> propertyManager, ILabelProvider labelProvider) {
        super(parentShell);
        this.propertyManager = propertyManager;
        this.labelProvider = labelProvider;
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"<init>", (Object)parentShell);
        this.viewTitle = viewTitle;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
        Debug.exit((Logger)logger, (String)ResourcesViewColumnDialog.class.getName(), (String)"<init>", (Object)((Object)this));
    }

    protected void initializeBounds() {
        super.initializeBounds();
        int x_location = this.getPreferenceValue(X_LOCATION);
        int y_location = this.getPreferenceValue(Y_LOCATION);
        if (x_location != 0 && y_location != 0) {
            this.getShell().setLocation(x_location, y_location);
        }
        int width = this.getPreferenceValue(WIDTH);
        int height = this.getPreferenceValue(HEIGHT);
        if (width != 0 && height != 0) {
            this.getShell().setSize(width, height);
        }
    }

    private int getPreferenceValue(String preferenceKey) {
        return UIPlugin.getDefault().getPreferenceStore().getInt(preferenceKey);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.viewTitle);
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        c.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite columnsComposite = new Composite(c, 0);
        columnsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        columnsComposite.setLayout((Layout)new GridLayout(3, false));
        Label l = new Label(columnsComposite, 0);
        l.setText(Messages.getString("ColumnSelectionDialog_AvailableProperties"));
        l = new Label(columnsComposite, 0);
        l = new Label(columnsComposite, 0);
        l.setText(Messages.getString("ColumnSelectionDialog_DisplayedProperties"));
        final Table availablePropertiesTable = new Table(columnsComposite, 2818);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.widthHint = 150;
        availablePropertiesTable.setLayoutData((Object)data);
        Composite buttonArea = new Composite(columnsComposite, 0);
        buttonArea.setLayout((Layout)new GridLayout(1, true));
        data = new GridData(0, 4, false, true);
        buttonArea.setLayoutData((Object)data);
        Table displayedPropertiesTable = new Table(columnsComposite, 2818);
        data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.widthHint = 150;
        displayedPropertiesTable.setLayoutData((Object)data);
        this.availablePropertiesTableViewer = new TableViewer(availablePropertiesTable);
        this.availablePropertiesTableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.availablePropertiesTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((PropertyManager)ColumnSelectionDialog.this.propertyManager).available.toArray();
            }
        });
        this.availablePropertiesTableViewer.setComparator(new ViewerComparator((Comparator)Collator.getInstance()));
        this.availablePropertiesTableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !((PropertyManager)ColumnSelectionDialog.this.propertyManager).displayed.contains(element);
            }
        });
        this.displayedPropertiesTableViewer = new TableViewer(displayedPropertiesTable);
        this.displayedPropertiesTableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.displayedPropertiesTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((PropertyManager)ColumnSelectionDialog.this.propertyManager).displayed.toArray();
            }
        });
        this.addButton = new Button(buttonArea, 8);
        this.addButton.setText(Messages.getString("ColumnSelectionDialog_Add"));
        data = new GridData(4, 0, true, false);
        this.addButton.setLayoutData((Object)data);
        this.addButton.setEnabled(false);
        this.removeButton = new Button(buttonArea, 8);
        this.removeButton.setText(Messages.getString("ColumnSelectionDialog_Remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.setLayoutData((Object)data);
        displayedPropertiesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnSelectionDialog.this.removeButton.setEnabled(true);
            }
        });
        availablePropertiesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnSelectionDialog.this.addButton.setEnabled(availablePropertiesTable.getSelectionCount() >= 1);
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ColumnSelectionDialog.this.availablePropertiesTableViewer.getSelection();
                ColumnSelectionDialog.this.add(selection);
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ColumnSelectionDialog.this.displayedPropertiesTableViewer.getSelection();
                ColumnSelectionDialog.this.remove(selection);
            }
        });
        this.availablePropertiesTableViewer.setInput(new Object());
        this.displayedPropertiesTableViewer.setInput(new Object());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Point location = ColumnSelectionDialog.this.getShell().getLocation();
                Point size = ColumnSelectionDialog.this.getShell().getSize();
                IPreferenceStore preferenceStore = UIPlugin.getDefault().getPreferenceStore();
                preferenceStore.setValue(ColumnSelectionDialog.X_LOCATION, location.x);
                preferenceStore.setValue(ColumnSelectionDialog.Y_LOCATION, location.y);
                preferenceStore.setValue(ColumnSelectionDialog.WIDTH, size.x);
                preferenceStore.setValue(ColumnSelectionDialog.HEIGHT, size.y);
                UIPlugin.getDefault().savePluginPreferences();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent.getShell(), DIALOG_HELP_CONTEXT_ID);
        return c;
    }

    void add(IStructuredSelection selection) {
        List<Object> elements = Arrays.asList(selection.toArray());
        this.propertyManager.add(elements);
        this.availablePropertiesTableViewer.refresh();
        this.displayedPropertiesTableViewer.refresh();
    }

    void remove(IStructuredSelection selection) {
        List<Object> elements = Arrays.asList(selection.toArray());
        this.propertyManager.remove(elements);
        this.availablePropertiesTableViewer.refresh();
        this.displayedPropertiesTableViewer.refresh();
    }

    void reset() {
        this.propertyManager.reset();
        this.availablePropertiesTableViewer.refresh();
        this.displayedPropertiesTableViewer.refresh();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12345) {
            this.reset();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12345, Messages.getString("ColumnSelectionDialog_Reset"), false);
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, true);
    }

    public void init(IWorkbench workbench) {
    }

    public static abstract class ColumnSelectionDialogList<E>
    implements List<E> {
        @Override
        public void add(int location, E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int location, Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E get(int location) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int lastIndexOf(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<E> listIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<E> listIterator(int location) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E remove(int location) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E set(int location, E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<E> subList(int start, int end) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            throw new UnsupportedOperationException();
        }
    }

    private static class PropertyManager<E> {
        private final Set<E> available;
        private final List<E> displayed;
        private final List<E> defaults;

        public PropertyManager(Set<E> available, List<E> displayed, List<E> defaults) {
            this.available = Collections.unmodifiableSet(available);
            this.displayed = displayed;
            this.defaults = defaults;
        }

        public void reset() {
            this.displayed.clear();
            this.displayed.addAll(this.defaults);
        }

        public void add(Collection<? extends E> elements) {
            this.displayed.addAll(elements);
        }

        public void remove(Collection<? extends E> elements) {
            this.displayed.removeAll(elements);
        }
    }
}

