/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm;

import com.ibm.cics.sm.comm.IResourceErrorCode;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import java.net.URL;
import java.util.List;

public class SMConnectionException
extends SystemManagerConnectionException {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = 1L;
    private int responseCode = 200;

    public SMConnectionException(String message) {
        super(message);
    }

    public SMConnectionException(Exception ex) {
        super(ex);
    }

    public SMConnectionException(URL url, String status) {
        super("request=" + url.toString() + ", status=" + status);
    }

    public SMConnectionException(URL url, int responseCode, String responseMessage) {
        super(url, responseCode, responseMessage);
        this.responseCode = responseCode;
    }

    public SMConnectionException(URL url, String request, int responseCode, String responseMessage) {
        super("url=" + url.toString() + ", request=" + request + ", code=" + responseCode + ", message=" + responseMessage);
        this.responseCode = responseCode;
    }

    public SMConnectionException(URL url, int response, int reason) {
        super(response, reason);
    }

    @Deprecated
    public SMConnectionException(URL url, int response, int reason, String function, int resp1, String resp1Name, int resp2, int errorCode, List<String> attributeNames) {
        super(response, reason, function, resp1, resp1Name, resp2, errorCode, attributeNames.get(0));
    }

    public SMConnectionException(String resourceType, int response, int reason, String function, int resp1, String resp1Name, int resp2, IResourceErrorCode errorCode, List<String> attributeNames) {
        super(resourceType, response, reason, function, resp1, resp1Name, resp2, errorCode, attributeNames.get(0));
    }

    public SMConnectionException(URL url, int response, int reason, String message) {
        super(message, response, reason);
    }

    public SMConnectionException(String resourceType, URL url, int response, int reason, String eibFunctionName, int resp1, String respName, int resp2) {
        super(resourceType, response, reason, eibFunctionName, resp1, respName, resp2);
    }

    public int getResponseCode() {
        return this.responseCode;
    }
}

